/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.mapping.Binding;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.text.Lexer;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.AutoloadSyntax;
import kawa.lang.Syntax;
import kawa.lang.Translator;
import kawa.repl;

public class define_autoload
extends Syntax {
    boolean fromFile;

    public define_autoload(boolean bl) {
        this.fromFile = bl;
    }

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        if (!(pair.cdr instanceof Pair)) {
            return super.scanForDefinitions(pair, vector, scopeExp, translator);
        }
        Pair pair2 = (Pair)pair.cdr;
        if (this.fromFile) {
            while (pair2.car instanceof FString) {
                if (!this.scanFile(pair2.car.toString(), scopeExp, translator)) {
                    return false;
                }
                Object object2 = pair2.cdr;
                if (object2 == LList.Empty) {
                    return true;
                }
                if (!(object2 instanceof Pair)) break;
                pair2 = (Pair)pair2.cdr;
            }
            translator.syntaxError("invalid syntax for define-autoloads-from-file");
            return false;
        }
        Object object3 = pair2.car;
        Object object4 = null;
        Object object5 = null;
        if (pair2.cdr instanceof Pair) {
            pair2 = (Pair)pair2.cdr;
            if (pair2.car == "::" && pair2.cdr instanceof Pair && ((Pair)pair2.cdr).cdr instanceof Pair) {
                pair2 = (Pair)pair2.cdr;
                object4 = pair2.car;
                pair2 = (Pair)pair2.cdr;
            }
            object5 = pair2.car;
            return define_autoload.process(object3, object4, object5, vector, scopeExp, translator);
        }
        translator.syntaxError("invalid syntax for define-autoload");
        return false;
    }

    public boolean scanFile(String string, ScopeExp scopeExp, Translator translator) {
        String string2;
        int n;
        File file;
        if (string.endsWith(".el")) {
            // empty if block
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(new File(translator.getFile()).getParent(), string);
        }
        if ((n = (string2 = file.getPath()).lastIndexOf(46)) >= 0) {
            String string3 = string2.substring(n);
            Interpreter interpreter = Interpreter.getInstance(string3);
            if (interpreter == null) {
                translator.syntaxError("unknown extension for " + string2);
                return true;
            }
            String string4 = repl.compilationPrefix;
            if (string4 == null) {
                string4 = "";
            }
            int n2 = string3.length();
            int n3 = string.length();
            String string5 = string.substring(0, n3 - n2);
            while (string5.startsWith("../")) {
                int n4 = string4.lastIndexOf(46, string4.length() - 2);
                if (n4 < 0) {
                    translator.syntaxError("cannot use relative filename \"" + string + "\" with simple prefix \"" + string4 + "\"");
                    return false;
                }
                string4 = string4.substring(0, n4 + 1);
                string5 = string5.substring(3);
            }
            String string6 = (string4 + string5).replace('/', '.');
            try {
                InPort inPort = InPort.openFile(string2);
                Lexer lexer = interpreter.getLexer(inPort, translator.getMessages());
                define_autoload.findAutoloadComments((LispReader)lexer, string6, scopeExp, translator);
            }
            catch (Exception exception) {
                translator.syntaxError("error reading " + string2 + ": " + exception);
                return true;
            }
        }
        return true;
    }

    public static void findAutoloadComments(LispReader lispReader, String string, ScopeExp scopeExp, Translator translator) throws IOException, SyntaxException {
        boolean bl = true;
        String string2 = ";;;###autoload";
        int n = string2.length();
        block0: while (true) {
            Object object2;
            int n2;
            if ((n2 = lispReader.peek()) < 0) {
                return;
            }
            if (n2 == 10 || n2 == 13) {
                lispReader.read();
                bl = true;
                continue;
            }
            if (bl && n2 == 59) {
                int n3 = 0;
                while (n3 != n) {
                    n2 = lispReader.read();
                    if (n2 < 0) {
                        return;
                    }
                    if (n2 == 10 || n2 == 13) {
                        bl = true;
                        continue block0;
                    }
                    if (n3 < 0 || n2 == string2.charAt(n3++)) continue;
                    n3 = -1;
                }
                if (n3 > 0) {
                    Object object3 = lispReader.readObject();
                    if (object3 instanceof Pair) {
                        String string3;
                        Pair pair = (Pair)object3;
                        AutoloadProcedure autoloadProcedure = null;
                        String string4 = null;
                        String string5 = string3 = pair.car instanceof String || pair.car instanceof Binding ? pair.car.toString() : null;
                        if (string3 == "defun") {
                            string4 = ((Pair)pair.cdr).car.toString();
                            autoloadProcedure = new AutoloadProcedure(string4, string, translator.getGlobalEnvironment());
                        } else {
                            translator.error('w', "unsupported ;;;###autoload followed by: " + pair.car);
                        }
                        if (autoloadProcedure != null) {
                            Declaration declaration = scopeExp.getDefine(string4, 'w', translator);
                            QuoteExp quoteExp = new QuoteExp(autoloadProcedure);
                            declaration.setFlag(16384);
                            declaration.noteValue(quoteExp);
                        }
                    }
                    bl = false;
                    continue;
                }
            }
            bl = false;
            lispReader.skip();
            if (n2 == 35 && lispReader.peek() == 124) {
                lispReader.skip();
                lispReader.readNestedComment('#', '|');
                continue;
            }
            if (!Character.isWhitespace((char)n2) && (object2 = lispReader.readObject(n2)) == Sequence.eofValue) break;
        }
    }

    public static boolean process(Object object2, Object object3, Object object4, Vector vector, ScopeExp scopeExp, Translator translator) {
        if (object2 instanceof Pair) {
            Pair pair = (Pair)object2;
            return define_autoload.process(pair.car, object3, object4, vector, scopeExp, translator) && define_autoload.process(pair.cdr, object3, object4, vector, scopeExp, translator);
        }
        if (object2 == LList.Empty) {
            return true;
        }
        if (object2 instanceof String) {
            Named named;
            String string;
            int n;
            String string2 = (String)object2;
            Declaration declaration = scopeExp.getDefine(string2, 'w', translator);
            if (object4 instanceof String && (n = (string = (String)object4).length()) > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                object4 = string.substring(1, n - 1);
            }
            if (object3 == "<syntax>" || object3 == "<macro>") {
                named = new AutoloadSyntax(string2, object4.toString(), translator.getGlobalEnvironment());
            } else if (object3 == "<procedure>" || object3 == "<interactive>" || object3 == null) {
                named = new AutoloadProcedure(string2, object4.toString(), translator.getGlobalEnvironment());
            } else {
                translator.syntaxError("unknown autoload type: " + object3);
                return false;
            }
            QuoteExp quoteExp = new QuoteExp(named);
            declaration.setFlag(16384);
            declaration.noteValue(quoteExp);
            return true;
        }
        return false;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return null;
    }
}

