/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import gnu.mapping.Procedure1;
import gnu.mapping.WrongType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Vector;
import kawa.lang.AnyPat;
import kawa.lang.EqualPat;
import kawa.lang.ListRepeatPat;
import kawa.lang.PairPat;
import kawa.lang.Pattern;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxRule;
import kawa.lang.Translator;

public class SyntaxRules
extends Procedure1
implements Printable,
Externalizable {
    String[] literal_identifiers;
    SyntaxRule[] rules;
    int maxVars = 0;

    private void calculate_maxVars() {
        int n = this.rules.length;
        while (--n >= 0) {
            int n2 = this.rules[n].num_variables + this.rules[n].template_identifiers.length;
            if (n2 <= this.maxVars) continue;
            this.maxVars = n2;
        }
    }

    public SyntaxRules() {
    }

    public SyntaxRules(String[] stringArray, SyntaxRule[] syntaxRuleArray) {
        this.literal_identifiers = stringArray;
        this.rules = syntaxRuleArray;
        this.calculate_maxVars();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyntaxRules(String[] stringArray, Object object2, Translator translator) {
        this.literal_identifiers = stringArray;
        int n = LList.listLength(object2, false);
        if (n <= 0) {
            n = 0;
            translator.syntaxError("missing or invalid syntax-rules");
        }
        this.rules = new SyntaxRule[n];
        int n2 = 0;
        while (true) {
            Object var19_18;
            int n3;
            int n4;
            String string;
            Pair pair;
            block11: {
                block10: {
                    block9: {
                        if (n2 >= n) {
                            this.calculate_maxVars();
                            return;
                        }
                        pair = (Pair)object2;
                        Object object3 = pair.car;
                        if (!(object3 instanceof Pair)) {
                            translator.syntaxError("missing pattern in " + n2 + "'th syntax rule");
                            return;
                        }
                        Pair pair2 = (Pair)object3;
                        Object object4 = pair2.car;
                        string = translator.getFile();
                        n4 = translator.getLine();
                        n3 = translator.getColumn();
                        try {
                            translator.setLine(pair2);
                            if (!(pair2.cdr instanceof Pair)) {
                                translator.syntaxError("missing template in " + n2 + "'th syntax rule");
                                var19_18 = null;
                                translator.setLine(string, n4, n3);
                                return;
                            }
                            pair2 = (Pair)pair2.cdr;
                            if (pair2.cdr != LList.Empty) {
                                translator.syntaxError("junk after " + n2 + "'th syntax rule");
                                break block9;
                            }
                            Object object5 = pair2.car;
                            StringBuffer stringBuffer = new StringBuffer();
                            Vector vector = new Vector();
                            if (!(object4 instanceof Pair) || !(((Pair)object4).car instanceof String)) {
                                translator.syntaxError("pattern does not start with name");
                                break block10;
                            }
                            stringArray[0] = (String)((Pair)object4).car;
                            object4 = ((Pair)object4).cdr;
                            Pattern pattern = SyntaxRules.translate_pattern(object4, stringArray, vector, stringBuffer, 0, translator);
                            String string2 = stringBuffer.toString();
                            this.rules[n2] = new SyntaxRule(pattern, string2, vector, object5, translator);
                            break block11;
                        }
                        catch (Throwable throwable) {
                            var19_18 = null;
                            translator.setLine(string, n4, n3);
                            throw throwable;
                        }
                    }
                    var19_18 = null;
                    translator.setLine(string, n4, n3);
                    return;
                }
                var19_18 = null;
                translator.setLine(string, n4, n3);
                return;
            }
            var19_18 = null;
            translator.setLine(string, n4, n3);
            ++n2;
            object2 = pair.cdr;
        }
    }

    public static Pattern translate_pattern(Object object2, String[] stringArray, Vector vector, StringBuffer stringBuffer, int n, Translator translator) {
        if (object2 instanceof Pair) {
            Object object3;
            Pair pair = (Pair)object2;
            if (pair.cdr instanceof Pair) {
                object3 = (Pair)pair.cdr;
                if (((Pair)object3).car == "...") {
                    if (((Pair)object3).cdr != LList.Empty) {
                        translator.syntaxError("junk follows ... in syntax-rule pattern");
                    }
                    Pattern pattern = SyntaxRules.translate_pattern(pair.car, stringArray, vector, stringBuffer, n + 1, translator);
                    return new ListRepeatPat(pattern);
                }
            }
            object3 = SyntaxRules.translate_pattern(pair.car, stringArray, vector, stringBuffer, n, translator);
            return new PairPat((Pattern)object3, SyntaxRules.translate_pattern(pair.cdr, stringArray, vector, stringBuffer, n, translator));
        }
        if (object2 instanceof String) {
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (stringArray[n2] != object2) continue;
                return new EqualPat(object2);
            }
            if (vector.contains(object2)) {
                translator.syntaxError("duplicated pattern variable " + object2);
            }
            vector.addElement(object2);
            stringBuffer.append((char)n);
            return new AnyPat();
        }
        return new EqualPat(object2);
    }

    public Object apply1(Object object2) {
        Pair pair;
        SyntaxForm syntaxForm;
        try {
            syntaxForm = (SyntaxForm)object2;
            pair = (Pair)syntaxForm.form;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, this, 0);
        }
        return this.expand(pair, syntaxForm.tr);
    }

    public Object expand(Pair pair, Translator translator) {
        Object object2 = pair.cdr;
        Object[] objectArray = new Object[this.maxVars];
        int n = 0;
        while (n < this.rules.length) {
            SyntaxRule syntaxRule = this.rules[n];
            if (syntaxRule.pattern.match(object2, objectArray, 0)) {
                Object object3 = syntaxRule.execute_template(objectArray, translator, pair);
                return object3;
            }
            ++n;
        }
        return translator.syntaxError("no matching syntax-rule for " + this.literal_identifiers[0]);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<macro " + this.literal_identifiers[0] + ">");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.literal_identifiers);
        objectOutput.writeObject(this.rules);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.literal_identifiers = (String[])objectInput.readObject();
        this.rules = (SyntaxRule[])objectInput.readObject();
        this.calculate_maxVars();
    }
}

