/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongArguments;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import kawa.standard.load;

public class Shell {
    private static Class[] noClasses = new Class[0];
    private static Class[] boolClasses = new Class[]{Boolean.TYPE};
    private static Class[] xmlPrinterClasses = new Class[]{class$gnu$lists$Consumer == null ? (class$gnu$lists$Consumer = Shell.class$("gnu.lists.Consumer")) : class$gnu$lists$Consumer, class$java$lang$Object == null ? (class$java$lang$Object = Shell.class$("java.lang.Object")) : class$java$lang$Object};
    private static Class[] httpPrinterClasses = new Class[]{class$gnu$mapping$OutPort == null ? (class$gnu$mapping$OutPort = Shell.class$("gnu.mapping.OutPort")) : class$gnu$mapping$OutPort};
    private static Object portArg = "(port)";
    static Object[][] formats = new Object[][]{{"scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.FALSE}, {"readable-scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.TRUE}, {"elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.FALSE}, {"readable-elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.TRUE}, {"clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"xml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, null}, {"html", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "html"}, {"xhtml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "xhtml"}, {"cgi", "gnu.kawa.xml.HttpPrinter", "make", httpPrinterClasses, portArg}, {"ignore", "gnu.lists.VoidConsumer", "getInstance", noClasses}, {null}};
    public static String defaultFormatName;
    public static Object[] defaultFormatInfo;
    public static Method defaultFormatMethod;
    static /* synthetic */ Class class$gnu$lists$Consumer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$gnu$mapping$OutPort;

    public static void setDefaultFormat(String string) {
        defaultFormatName = string = string.intern();
        int n = 0;
        while (true) {
            Object[] objectArray;
            Object object2;
            if ((object2 = (objectArray = formats[n])[0]) == null) {
                System.err.println("kawa: unknown output format '" + string + "'");
                System.exit(-1);
            } else if (object2 == string) {
                defaultFormatInfo = objectArray;
                try {
                    Class<?> clazz = Class.forName((String)objectArray[1]);
                    defaultFormatMethod = clazz.getMethod((String)objectArray[2], (Class[])objectArray[3]);
                }
                catch (Throwable throwable) {
                    System.err.println("kawa:  caught " + throwable + " while looking for format '" + string + "'");
                    System.exit(-1);
                }
                break;
            }
            ++n;
        }
        if (!defaultFormatInfo[1].equals("gnu.lists.VoidConsumer")) {
            ModuleBody.setMainPrintValues(true);
        }
    }

    public static Consumer getOutputConsumer(OutPort outPort) {
        Object[] objectArray = defaultFormatInfo;
        if (outPort == null) {
            return VoidConsumer.getInstance();
        }
        if (objectArray == null) {
            return Interpreter.getInterpreter().getOutputConsumer(outPort);
        }
        try {
            Object[] objectArray2 = new Object[objectArray.length - 4];
            System.arraycopy(objectArray, 4, objectArray2, 0, objectArray2.length);
            int n = objectArray2.length;
            while (--n >= 0) {
                if (objectArray2[n] != portArg) continue;
                objectArray2[n] = outPort;
            }
            Object object2 = defaultFormatMethod.invoke(null, objectArray2);
            if (object2 instanceof FormatToConsumer) {
                outPort.objectFormat = (FormatToConsumer)object2;
                return outPort;
            }
            return (Consumer)object2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("cannot get output-format '" + defaultFormatName + "' - caught " + throwable);
        }
    }

    public static void run(Interpreter interpreter) {
        Shell.run(interpreter, interpreter.getEnvironment());
    }

    public static void run(Interpreter interpreter, Environment environment) {
        Procedure procedure;
        InPort inPort = InPort.inDefault();
        if (inPort instanceof TtyInPort && (procedure = interpreter.getPrompter()) != null) {
            ((TtyInPort)inPort).setPrompter(procedure);
        }
        Shell.run(interpreter, environment, inPort, OutPort.outDefault(), OutPort.errDefault());
    }

    public static void run(Interpreter interpreter, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        FormatToConsumer formatToConsumer = null;
        if (outPort != null) {
            formatToConsumer = outPort.objectFormat;
        }
        Consumer consumer = Shell.getOutputConsumer(outPort);
        try {
            Shell.run(interpreter, environment, inPort, consumer, outPort2);
            Object var8_7 = null;
            if (outPort != null) {
                outPort.objectFormat = formatToConsumer;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (outPort != null) {
                outPort.objectFormat = formatToConsumer;
            }
            throw throwable;
        }
    }

    public static void run(Interpreter interpreter, Environment environment, InPort inPort, Consumer consumer, OutPort outPort) {
        SourceMessages sourceMessages = new SourceMessages();
        Lexer lexer = interpreter.getLexer(inPort, sourceMessages);
        if (inPort instanceof TtyInPort) {
            lexer.setInteractive(true);
        }
        CallContext callContext = CallContext.getInstance();
        Consumer consumer2 = null;
        if (consumer != null) {
            consumer2 = callContext.consumer;
            callContext.consumer = consumer;
        }
        try {
            block7: while (true) {
                try {
                    ModuleExp moduleExp;
                    while ((moduleExp = interpreter.parse(environment, lexer)) != null) {
                        int n;
                        moduleExp.setName("atInteractiveLevel");
                        if (lexer.checkErrors(outPort, 20)) continue;
                        while ((n = inPort.read()) >= 0 && n != 13 && n != 10) {
                            if (n == 32 || n == 9) continue;
                            inPort.unread();
                            break;
                        }
                        moduleExp.evalModule(environment, callContext);
                        callContext.runUntilDone();
                        if (n >= 0) continue;
                        break block7;
                    }
                }
                catch (WrongArguments wrongArguments) {
                    if (wrongArguments.usage != null) {
                        outPort.println("usage: " + wrongArguments.usage);
                    }
                    wrongArguments.printStackTrace(outPort);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    outPort.println("Invalid parameter, was: " + classCastException.getMessage());
                    classCastException.printStackTrace(outPort);
                    continue;
                }
                catch (SyntaxException syntaxException) {
                    syntaxException.printAll(outPort, 20);
                    syntaxException.clear();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(outPort);
                    continue;
                }
                break;
            }
            Object var14_15 = null;
            if (consumer != null) {
                callContext.consumer = consumer2;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (consumer != null) {
                callContext.consumer = consumer2;
            }
            throw throwable;
        }
    }

    public static void runString(String string, Interpreter interpreter, Environment environment) {
        Shell.run(interpreter, environment, (InPort)new CharArrayInPort(string), ModuleBody.getMainPrintValues() ? OutPort.outDefault() : null, OutPort.errDefault());
    }

    public static void runFile(String string) {
        Environment environment = Environment.user();
        try {
            if (string.equals("-")) {
                load.loadSource(InPort.inDefault(), environment);
            } else {
                load.apply(string, environment);
            }
        }
        catch (SyntaxException syntaxException) {
            syntaxException.printAll(OutPort.errDefault(), 20);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open file " + string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

