/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.FluidBinding;
import gnu.mapping.FluidConstraint;
import gnu.mapping.Future;
import gnu.mapping.Procedure;
import gnu.mapping.ValueStack;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import gnu.math.IntNum;

public class CallContext
implements Runnable {
    static ThreadLocal currentContext = new ThreadLocal();
    Thread currentThread;
    public Procedure proc;
    public int pc;
    public ValueStack vstack = new ValueStack();
    public Consumer consumer = this.vstack;
    public Object value1;
    public Object value2;
    public Object value3;
    public Object value4;
    public Object[] values;
    public int ivalue1;
    public int ivalue2;
    public int count;
    public int next;
    int where;
    static final int ARG_IN_VALUES_ARRAY = 0;
    static final int ARG_IN_VALUE1 = 1;
    static final int ARG_IN_VALUE2 = 2;
    static final int ARG_IN_VALUE3 = 3;
    static final int ARG_IN_VALUE4 = 4;
    static final int ARG_IN_IVALUE1 = 5;
    static final int ARG_IN_IVALUE2 = 6;
    public FluidBinding fluidBindings;

    public final Environment getEnvironment() {
        if (this.currentThread instanceof Future) {
            return ((Future)this.currentThread).environment;
        }
        return Environment.global;
    }

    public static void setInstance(CallContext callContext) {
        Thread thread2;
        callContext.currentThread = thread2 = Thread.currentThread();
        currentContext.set(callContext);
    }

    public static CallContext getOnlyInstance() {
        return (CallContext)currentContext.get();
    }

    public static CallContext getInstance() {
        CallContext callContext = CallContext.getOnlyInstance();
        if (callContext == null) {
            callContext = new CallContext();
            CallContext.setInstance(callContext);
        }
        return callContext;
    }

    public Object getArgAsObject(int n) {
        if (n < 8) {
            switch (this.where >> 4 * n & 0xF) {
                case 1: {
                    return this.value1;
                }
                case 2: {
                    return this.value2;
                }
                case 3: {
                    return this.value3;
                }
                case 4: {
                    return this.value4;
                }
                case 5: {
                    return IntNum.make(this.ivalue1);
                }
                case 6: {
                    return IntNum.make(this.ivalue2);
                }
            }
        }
        return this.values[n];
    }

    public Object getNextArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(this.proc, this.count);
        }
        return this.getArgAsObject(this.next++);
    }

    public int getNextIntArg() {
        if (this.next >= this.count) {
            throw new WrongArguments(this.proc, this.count);
        }
        Object object2 = this.getArgAsObject(this.next++);
        return ((Number)object2).intValue();
    }

    public Object getNextArg(Object object2) {
        if (this.next >= this.count) {
            return object2;
        }
        return this.getArgAsObject(this.next++);
    }

    public int getNextIntArg(int n) {
        if (this.next >= this.count) {
            return n;
        }
        return ((Number)this.getArgAsObject(this.next++)).intValue();
    }

    public void lastArg() {
        if (this.next < this.count) {
            throw new WrongArguments(this.proc, this.count);
        }
        this.values = null;
    }

    public void setArgs() {
        this.count = 0;
        this.where = 0;
        this.next = 0;
    }

    public void setArgs(Object object2) {
        this.value1 = object2;
        this.count = 1;
        this.where = 1;
        this.next = 0;
    }

    public void setArgs(Object object2, Object object3) {
        this.value1 = object2;
        this.value2 = object3;
        this.count = 2;
        this.where = 33;
        this.next = 0;
    }

    public void setArgs(Object object2, Object object3, Object object4) {
        this.value1 = object2;
        this.value2 = object3;
        this.value3 = object4;
        this.count = 3;
        this.where = 801;
        this.next = 0;
    }

    public void setArgs(Object object2, Object object3, Object object4, Object object5) {
        this.value1 = object2;
        this.value2 = object3;
        this.value3 = object4;
        this.value4 = object5;
        this.count = 4;
        this.where = 17185;
        this.next = 0;
    }

    public void setArgsN(Object[] objectArray) {
        this.values = objectArray;
        this.count = objectArray.length;
        this.where = 0;
        this.next = 0;
    }

    public Object[] getArgs() {
        if (this.where == 0) {
            return this.values;
        }
        int n = this.count;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            objectArray[n] = this.getArgAsObject(n);
        }
        return objectArray;
    }

    public void runUntilDone() throws Throwable {
        Procedure procedure;
        while ((procedure = this.proc) != null) {
            this.proc = null;
            procedure.apply(this);
        }
    }

    public final Object runUntilValue() throws Throwable {
        Consumer consumer = this.consumer;
        ValueStack valueStack = this.vstack;
        this.consumer = valueStack;
        int n = valueStack.gapStart;
        int n2 = valueStack.oindex;
        try {
            this.runUntilDone();
            Object object2 = Values.make(valueStack, n, valueStack.gapStart);
            Object var7_6 = null;
            this.consumer = consumer;
            valueStack.gapStart = n;
            valueStack.oindex = n2;
            return object2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.consumer = consumer;
            valueStack.gapStart = n;
            valueStack.oindex = n2;
            throw throwable;
        }
    }

    public final void runUntilValue(Consumer consumer) throws Throwable {
        Consumer consumer2 = this.consumer;
        this.consumer = consumer;
        try {
            this.runUntilDone();
            Object var4_3 = null;
            this.consumer = consumer2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.consumer = consumer2;
            throw throwable;
        }
    }

    public void run() {
        try {
            this.runUntilDone();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    public void writeValue(Object object2) {
        Values.writeValues(object2, this.consumer);
    }

    public void setFluids(FluidBinding fluidBinding) {
        FluidBinding fluidBinding2 = this.fluidBindings;
        FluidBinding fluidBinding3 = fluidBinding;
        while (fluidBinding3 != fluidBinding2) {
            Binding binding = fluidBinding3.binding;
            Constraint constraint = binding.constraint;
            if (constraint instanceof FluidConstraint) {
                ++((FluidConstraint)constraint).referenceCount;
            } else {
                binding.constraint = new FluidConstraint(constraint);
            }
            fluidBinding3 = fluidBinding3.previous;
        }
        this.fluidBindings = fluidBinding;
    }

    public void resetFluids(FluidBinding fluidBinding) {
        FluidBinding fluidBinding2;
        FluidBinding fluidBinding3 = fluidBinding2 = this.fluidBindings;
        while (fluidBinding3 != fluidBinding) {
            Binding binding = fluidBinding3.binding;
            FluidConstraint fluidConstraint = (FluidConstraint)binding.constraint;
            if (fluidConstraint.referenceCount-- <= 0) {
                binding.constraint = fluidConstraint.savedConstraint;
            }
            fluidBinding3 = fluidBinding3.previous;
        }
        this.fluidBindings = fluidBinding;
    }
}

