/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CpsProcedure;
import gnu.xml.QName;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ElementConstructor
extends CpsProcedure
implements Inlineable,
Externalizable {
    String sname;
    QName qname;
    static final Method beginGroupMethod = Compilation.typeConsumer.getDeclaredMethod("beginGroup", 2);
    static final Method endGroupMethod = Compilation.typeConsumer.getDeclaredMethod("endGroup", 1);

    public String getXmlName() {
        return this.sname;
    }

    public QName getQName() {
        return this.qname;
    }

    public final String getNamespaceURI() {
        return this.qname.getNamespaceURI();
    }

    public final String getLocalName() {
        return this.qname.getLocalName();
    }

    public final String getPrefix() {
        int n = this.sname.indexOf(58);
        if (n <= 0) {
            return null;
        }
        return this.sname.substring(0, n);
    }

    public static ElementConstructor make(String string, QName qName) {
        ElementConstructor elementConstructor = new ElementConstructor();
        elementConstructor.sname = string.intern();
        elementConstructor.qname = qName;
        return elementConstructor;
    }

    public static ElementConstructor make(String string, String string2, String string3) {
        ElementConstructor elementConstructor = new ElementConstructor();
        elementConstructor.sname = string.intern();
        elementConstructor.qname = QName.make(string2, string3);
        return elementConstructor;
    }

    public void apply(CallContext callContext) {
        Consumer consumer = callContext.consumer;
        int n = callContext.count;
        consumer.beginGroup(this.sname, this.qname);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = callContext.getArgAsObject(n2);
            if (object2 instanceof Consumable) {
                ((Consumable)object2).consume(consumer);
            } else {
                consumer.writeObject(object2);
            }
            ++n2;
        }
        consumer.endGroup(this.sname);
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        if (target instanceof ConsumerTarget) {
            Variable variable = ((ConsumerTarget)target).getConsumerVariable();
            Expression[] expressionArray = applyExp.getArgs();
            int n = expressionArray.length;
            CodeAttr codeAttr = compilation.getCode();
            codeAttr.emitLoad(variable);
            compilation.compileConstant(this.sname, Target.pushObject);
            compilation.compileConstant(this.qname, Target.pushObject);
            codeAttr.emitInvokeInterface(beginGroupMethod);
            int n2 = 0;
            while (n2 < n) {
                expressionArray[n2].compileWithPosition(compilation, target);
                ++n2;
            }
            codeAttr.emitLoad(variable);
            compilation.compileConstant(this.sname, Target.pushObject);
            codeAttr.emitInvokeInterface(endGroupMethod);
        } else if (target instanceof IgnoreTarget) {
            ApplyExp.compile(applyExp, compilation, target);
        } else {
            ConsumerTarget.compileUsingConsumer(applyExp, compilation, target);
        }
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Compilation.typeObject;
    }

    public String toString() {
        return "#<ElementConstructor " + this.sname + " :: " + this.qname + '>';
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.sname);
        objectOutput.writeObject(this.qname);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sname = ((String)objectInput.readObject()).intern();
        this.qname = (QName)objectInput.readObject();
    }
}

