/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.bytecode.ClassType;
import gnu.expr.PrimProcedure;
import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.BufferKeymap;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Mode;
import gnu.jemacs.buffer.ProcessDefaultAction;
import gnu.jemacs.buffer.Signal;
import gnu.lists.CharSeq;
import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;

public class ProcessMode
extends Mode {
    protected Writer toInferior;
    protected Marker processMark;
    protected boolean lineMode = false;
    static Procedure enterAction = new PrimProcedure(ClassType.make("gnu.jemacs.buffer.ProcessMode").getDeclaredMethod("enterAction", 0));
    public static Keymap modeMap = BufferKeymap.makeEmptyKeymap("process");

    public Marker getProcessMark() {
        return this.processMark;
    }

    public static void enterAction() {
        Buffer buffer = Buffer.getCurrent();
        ProcessMode processMode = ProcessMode.getProcessMode(buffer);
        processMode.enter();
    }

    public void enter() {
        try {
            if (this.lineMode) {
                this.buffer.insert('\n', 1, null);
                int n = this.buffer.getDot();
                int n2 = this.processMark.getOffset();
                Segment segment = new Segment();
                this.buffer.getText(n2, n - n2, segment);
                this.processMark.setDot(n);
                System.err.println("sent to inf: (pos:" + n + " pmark:" + n2 + ") " + segment.count + " \"" + new String(segment.array, segment.offset, segment.count) + "\"");
                this.toInferior.write(segment.array, segment.offset, segment.count);
            } else {
                this.toInferior.write(13);
            }
            this.toInferior.flush();
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public static ProcessMode getProcessMode(Buffer buffer) {
        Mode mode = buffer.modes;
        while (true) {
            if (mode == null) {
                Signal.error("not in process mode");
            }
            if (mode instanceof ProcessMode) {
                return (ProcessMode)mode;
            }
            mode = mode.next;
        }
    }

    public void writeToInferior(CharSeq charSeq) throws IOException {
        charSeq.writeTo(this.toInferior);
        this.toInferior.flush();
    }

    static {
        BufferKeymap.defineKey(modeMap, "\n", enterAction);
        modeMap.setDefaultAction(new ProcessDefaultAction());
    }
}

