/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.KawaConvert;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Undefined;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class Interpreter {
    public static Interpreter defaultInterpreter = null;
    public static final Boolean trueObject = Boolean.TRUE;
    public static final Boolean falseObject = Boolean.FALSE;
    public static final Undefined undefinedObject;
    public static final Object voidObject;
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    static String[][] languages;
    protected Environment environ;
    public static final int VALUE_NAMESPACE = 1;
    public static final int FUNCTION_NAMESPACE = 2;

    public static Interpreter getInterpreter() {
        return defaultInterpreter;
    }

    public static String[][] getLanguages() {
        return languages;
    }

    public static void registerLanguage(String[] stringArray) {
        String[][] stringArrayArray = new String[languages.length + 1][];
        System.arraycopy(languages, 0, stringArrayArray, 0, languages.length);
        stringArrayArray[stringArrayArray.length - 1] = stringArray;
        languages = stringArrayArray;
    }

    public static Interpreter getInstanceFromFilenameExtension(String string) {
        Interpreter interpreter;
        int n = string.lastIndexOf(46);
        if (n > 0 && (interpreter = Interpreter.getInstance(string.substring(n))) != null) {
            return interpreter;
        }
        return null;
    }

    public static Interpreter getInstance(String string) {
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String[] stringArray = languages[n2];
            int n4 = n3 = stringArray.length - 1;
            while (--n4 >= 0) {
                Class<?> clazz;
                if (string != null && !stringArray[n4].equalsIgnoreCase(string)) continue;
                try {
                    clazz = Class.forName(stringArray[n3]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break;
                }
                return Interpreter.getInstance(stringArray[0], clazz);
            }
            ++n2;
        }
        return null;
    }

    protected Interpreter() {
        Convert.setInstance(KawaConvert.getInstance());
    }

    public static Interpreter getInstance(String string, Class clazz) {
        try {
            Method method;
            Class[] classArray = new Class[]{};
            try {
                String string2 = Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase();
                String string3 = "get" + string2 + "Instance";
                method = clazz.getDeclaredMethod(string3, classArray);
            }
            catch (Exception exception) {
                method = clazz.getDeclaredMethod("getInstance", classArray);
            }
            return (Interpreter)method.invoke(null, Values.noArgs);
        }
        catch (Exception exception) {
            string = clazz.getName();
            exception.printStackTrace();
            throw new WrappedException("getInstance for '" + string + "' failed", exception);
        }
    }

    public boolean isTrue(Object object2) {
        return object2 != Boolean.FALSE;
    }

    public Object booleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object noValue() {
        return Values.empty;
    }

    public boolean hasSeparateFunctionNamespace() {
        return false;
    }

    public Environment getEnvironment() {
        return this.environ;
    }

    public void setEnvironment(Environment environment) {
        this.environ = environment;
    }

    public void define(String string, Object object2) {
        this.environ.define(string, object2);
    }

    public final void defineFunction(Named named) {
        this.defineFunction(named.getName(), named);
    }

    public void defineFunction(String string, Object object2) {
        this.environ.define(string, object2);
    }

    public void defineAll(Object object2) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            String string = field.getName();
            if ((field.getModifiers() & 0x10) != 0) {
                try {
                    this.defineFromFieldValue(string, field.get(object2));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new WrappedException("error accessing field " + field, throwable);
                }
            }
            System.err.println("INTERNAL ERROR in defineAll for " + string + " in " + clazz);
        }
    }

    public void defineFromFieldValue(String string, Object object2) throws Throwable {
        string = object2 instanceof Named ? ((Named)object2).getName() : string.intern();
        if (object2 instanceof Binding) {
            this.environ.addBinding((Binding)object2);
        } else {
            this.environ.define(string, object2);
        }
    }

    public void loadClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            this.defineAll(obj);
            if (obj instanceof ModuleBody) {
                ((ModuleBody)obj).run();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public Object lookup(String string) {
        return this.environ.get(string);
    }

    public abstract Object read(InPort var1) throws IOException, SyntaxException;

    public void print(Object object2, OutPort outPort) {
        this.print(object2, outPort, false);
    }

    public void print(Object object2, OutPort outPort, boolean bl) {
        if (object2 == Values.empty) {
            return;
        }
        FormatToConsumer formatToConsumer = outPort.objectFormat;
        try {
            outPort.objectFormat = this.getFormat(bl);
            if (object2 instanceof Values) {
                Object[] objectArray = ((Values)object2).getValues();
                int n = 0;
                while (n < objectArray.length) {
                    outPort.println(objectArray[n]);
                    ++n;
                }
            } else {
                outPort.println(object2);
            }
            Object var8_7 = null;
            outPort.objectFormat = formatToConsumer;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            outPort.objectFormat = formatToConsumer;
            throw throwable;
        }
    }

    public abstract FormatToConsumer getFormat(boolean var1);

    public Consumer getOutputConsumer(OutPort outPort) {
        outPort.objectFormat = this.getFormat(false);
        return outPort;
    }

    public Environment getNewEnvironment() {
        return new Environment(this.environ);
    }

    public abstract String getName();

    public abstract Lexer getLexer(InPort var1, SourceMessages var2);

    public abstract ModuleExp parse(Environment var1, Lexer var2) throws IOException, SyntaxException;

    public abstract ModuleExp parseFile(InPort var1, SourceMessages var2);

    public abstract Type getTypeFor(Class var1);

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Interpreter.string2Type(string.substring(0, string.length() - 2));
            if (type == null) {
                return null;
            }
            type = ArrayType.make(type);
        } else if (Type.isValidJavaTypeName(string)) {
            type = Type.getType(string);
        } else {
            return null;
        }
        return type;
    }

    public Type getTypeFor(String string) {
        return Interpreter.string2Type(string);
    }

    public Type asType(Object object2) {
        if (!(object2 instanceof Type)) {
            if (object2 instanceof Class) {
                return this.getTypeFor((Class)object2);
            }
            if (object2 instanceof String || object2 instanceof Binding) {
                return this.getTypeFor(object2.toString());
            }
            if (object2 instanceof CharSeq) {
                return ClassType.make(object2.toString());
            }
        }
        return (Type)object2;
    }

    public Type getTypeFor(Expression expression) {
        if (expression instanceof QuoteExp) {
            try {
                return this.asType(((QuoteExp)expression).getValue());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (expression instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration != null && !declaration.getFlag(65536)) {
                return this.getTypeFor(declaration.getValue());
            }
            String string = referenceExp.getName();
            Object object2 = Environment.getCurrent().get(string);
            if (object2 instanceof Type) {
                return (Type)object2;
            }
            int n = string.length();
            if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                return this.getTypeFor(string.substring(1, n - 1));
            }
        } else if (expression instanceof ClassExp) {
            return ((ClassExp)expression).getType();
        }
        return null;
    }

    public int getNamespaceOf(Declaration declaration) {
        return 1;
    }

    public void emitPushBoolean(boolean bl, CodeAttr codeAttr) {
        codeAttr.emitGetStatic(bl ? Compilation.trueConstant : Compilation.falseConstant);
    }

    public void emitCoerceToBoolean(CodeAttr codeAttr) {
        this.emitPushBoolean(false, codeAttr);
        codeAttr.emitIfNEq();
        codeAttr.emitPushInt(1);
        codeAttr.emitElse();
        codeAttr.emitPushInt(0);
        codeAttr.emitFi();
    }

    public Object coerceFromObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceFromObject(object2);
    }

    public Object coerceToObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceToObject(object2);
    }

    public Object coerceToObject(int n) {
        return IntNum.make(n);
    }

    public Procedure getPrompter() {
        Binding binding = Environment.getCurrentBinding("default-prompter");
        return binding == null ? null : binding.getProcedure();
    }

    static {
        new Undefined();
        undefinedObject = Undefined.getInstance();
        voidObject = Values.empty;
        languages = new String[][]{{"scheme", ".scm", ".sc", "kawa.standard.Scheme"}, {"krl", ".krl", "gnu.kawa.brl.BRL"}, {"brl", ".brl", "gnu.kawa.brl.BRL"}, {"emacs", "elisp", "emacs-lisp", ".el", "gnu.jemacs.lang.ELisp"}, {"xquery", ".xql", "gnu.xquery.lang.XQuery"}, {"commonlisp", "common-lisp", "clisp", "lisp", ".lisp", ".lsp", ".cl", "gnu.commonlisp.lang.CommonLisp"}};
    }
}

