/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LetExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class FluidLetExp
extends LetExp {
    static ClassType typeCallContext = ClassType.make("gnu.mapping.CallContext");
    static Method getContextMethod = typeCallContext.addMethod("getInstance", Type.typeArray0, typeCallContext, 9);
    public static ClassType typeFluidBinding = ClassType.make("gnu.mapping.FluidBinding");
    static Field fluidBindingsField = typeCallContext.addField("fluidBindings", typeFluidBinding, 9);
    public static Field valueField = typeFluidBinding.addField("value", Type.pointer_type, 1);
    static Method setFluidsMethod;
    static Method resetFluidsMethod;
    static Method makeFluidBindingMethod;

    public FluidLetExp(Expression[] expressionArray) {
        super(expressionArray);
    }

    public void compile(Compilation compilation, Target target) {
        Type type;
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.pushScope();
        Type type2 = type = target instanceof IgnoreTarget ? null : this.getType();
        Target target2 = type == null ? Target.Ignore : (type == Type.pointer_type ? Target.pushObject : new StackTarget(type));
        Variable variable = codeAttr.addLocal(typeCallContext);
        if (compilation.curLambda.isHandlingTailCalls()) {
            compilation.loadCallContext();
        } else {
            codeAttr.emitInvokeStatic(getContextMethod);
        }
        codeAttr.emitDup(1);
        codeAttr.emitStore(variable);
        codeAttr.emitDup(1);
        codeAttr.emitGetField(fluidBindingsField);
        Variable variable2 = codeAttr.addLocal(typeFluidBinding);
        codeAttr.emitDup(1);
        codeAttr.emitStore(variable2);
        codeAttr.enterScope(this.scope);
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            declaration.allocateVariable(codeAttr);
            this.inits[n].compile(compilation, Target.pushObject);
            declaration.base.load(compilation);
            codeAttr.emitInvokeStatic(makeFluidBindingMethod);
            codeAttr.emitDup(1);
            codeAttr.emitStore(declaration.getVariable());
            ++n;
            declaration = declaration.nextDecl();
        }
        codeAttr.emitInvokeVirtual(setFluidsMethod);
        codeAttr.emitTryStart(true, type);
        this.body.compileWithPosition(compilation, target2);
        codeAttr.emitTryEnd();
        codeAttr.emitFinallyStart();
        codeAttr.emitLoad(variable);
        codeAttr.emitLoad(variable2);
        codeAttr.emitInvokeVirtual(resetFluidsMethod);
        codeAttr.emitTryCatchEnd();
        codeAttr.popScope();
        codeAttr.popScope();
        if (type != null) {
            target.compileFromStack(compilation, type);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkFluidLetExp(this);
    }

    static {
        Type[] typeArray = new Type[]{typeFluidBinding};
        setFluidsMethod = typeCallContext.addMethod("setFluids", typeArray, Type.void_type, 1);
        resetFluidsMethod = typeCallContext.addMethod("resetFluids", typeArray, Type.void_type, 1);
        typeArray = new Type[]{typeFluidBinding, Type.pointer_type, ClassType.make("gnu.mapping.Binding")};
        makeFluidBindingMethod = typeFluidBinding.addMethod("make", typeArray, typeFluidBinding, 9);
    }
}

