/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.Graphics;
import turtlekit.kernel.GridCanvas;
import turtlekit.kernel.Observer;
import turtlekit.kernel.Patch;
import turtlekit.kernel.Turtle;
import turtlekit.kernel.TurtleProbe;

public class Viewer
extends Observer {
    private static final long serialVersionUID = 1547995005111504481L;
    int cellSize;
    GridCanvas onScreen;
    int cpt = 10;
    int flashTime = 10;
    boolean flash = false;
    boolean show = true;
    boolean redrawAll = false;
    TurtleProbe allTurtles;

    public void setFlash(boolean bl) {
        if (bl) {
            this.redrawAll = true;
            this.onScreen.display();
            this.redrawAll = false;
        }
        this.flash = bl;
    }

    public boolean getRedrawAll() {
        return this.redrawAll;
    }

    public void setRedrawAll(boolean bl) {
        this.redrawAll = bl;
    }

    public boolean getFlash() {
        return this.flash;
    }

    public void setShow(boolean bl) {
        if (bl && !this.show && this.onScreen != null) {
            this.redrawAll = true;
            this.onScreen.display();
            this.redrawAll = false;
            this.show = true;
        } else {
            this.show = bl;
        }
    }

    public boolean getShow() {
        return this.show;
    }

    public void setFlashStepSize(int n) {
        this.cpt = this.flashTime = n;
    }

    public int getFlashStepSize() {
        return this.flashTime;
    }

    public final void initGUI() {
        this.onScreen = new GridCanvas(this.cellSize * this.envWidth, this.cellSize * this.envHeight, this);
        this.setGUIObject(this.onScreen);
    }

    public void setup() {
        this.leaveRole("Turtlekit", this.getSimulationGroup(), "observer");
        this.requestRole("Turtlekit", this.getSimulationGroup(), "viewer", null);
        this.allTurtles = new TurtleProbe(this.getSimulationGroup(), "turtle");
        this.addProbe(this.allTurtles);
        this.onScreen.initialisation();
    }

    public void paintPatch(Graphics graphics, Patch patch, int n, int n2, int n3) {
        graphics.setColor(patch.color);
        graphics.fillRect(n, n2, n3, n3);
    }

    public void paintTurtle(Graphics graphics, Turtle turtle, int n, int n2, int n3) {
        graphics.setColor(turtle.color);
        graphics.fillRect(n, n2, n3, n3);
    }

    final void paintInfo(Graphics graphics) {
        int n;
        int n2;
        if (this.redrawAll) {
            for (n2 = this.envWidth - 1; n2 >= 0; --n2) {
                for (n = this.envHeight - 1; n >= 0; --n) {
                    this.paintPatch(graphics, this.patchGrid[n2][n], n2 * this.cellSize, (this.envHeight - n - 1) * this.cellSize, this.cellSize);
                }
            }
        } else {
            for (n2 = this.envWidth - 1; n2 >= 0; --n2) {
                for (n = this.envHeight - 1; n >= 0; --n) {
                    if (!this.patchGrid[n2][n].change) continue;
                    this.paintPatch(graphics, this.patchGrid[n2][n], n2 * this.cellSize, (this.envHeight - n - 1) * this.cellSize, this.cellSize);
                }
            }
        }
        for (Turtle turtle : this.allTurtles.getCurrentAgentsList()) {
            if (turtle.hidden) continue;
            this.paintTurtle(graphics, turtle, turtle.xcor() * this.cellSize, (this.envHeight - turtle.ycor() - 1) * this.cellSize, this.cellSize);
        }
    }

    public void display() {
        if (this.show) {
            if (this.flash) {
                --this.cpt;
                if (this.cpt < 0) {
                    this.redrawAll = true;
                    this.cpt = this.flashTime;
                    this.onScreen.display();
                    this.redrawAll = false;
                }
            } else {
                this.onScreen.display();
            }
        }
    }
}

