/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.tests;

import java.awt.Color;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.gravity.BlackHole;
import turtlekit.simulations.gravity.Star;
import turtlekit.simulations.tests.Ovni;
import turtlekit.simulations.tests.Walker;

public class Creator
extends Turtle {
    public int life = 50;

    public Creator() {
        super("ride");
    }

    public void setup() {
        this.playRole("creator");
    }

    public String ride() {
        this.fd(1);
        if (this.getPatchColor() == Color.white) {
            if (Math.random() < 0.99) {
                this.createTurtle(new Walker());
            } else if (Math.random() < 0.95) {
                for (int i = 0; i < 50; ++i) {
                    this.createTurtle(new Ovni());
                }
            } else {
                this.launchGravity();
            }
            --this.life;
            this.setPatchColor(Color.black);
            return "erase";
        }
        this.setPatchColor(Color.white);
        return "ride";
    }

    public String erase() {
        if (this.life < 0) {
            return null;
        }
        this.turnLeft(Math.random() * 50.0);
        this.turnRight(Math.random() * 50.0);
        this.fd(1);
        if (this.getPatchColor() == Color.white) {
            this.setColor(Color.lightGray);
            this.setPatchColor(Color.black);
            return "erase";
        }
        this.setColor(Color.cyan);
        return "ride";
    }

    public void launchGravity() {
        Turtle[] turtleArray = new Turtle[1];
        BlackHole blackHole = new BlackHole();
        turtleArray[0] = blackHole;
        this.createTurtle(blackHole);
        for (int i = 0; i < 30; ++i) {
            this.createTurtle(new Star(turtleArray, 13));
        }
    }
}

