/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt2;

import java.awt.Color;
import java.util.ArrayList;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.hunt2.Animat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Black
extends Animat {
    static final int SACRIFICE = 1;
    static final int WAIT = 2;
    static final int CHASE = 3;
    static final int REPRODUCING = 4;
    private int status = 2;
    private String enemyString = "Cyan";
    private String friendString = "Black";
    private ArrayList<Animat> ennemies = new ArrayList();
    private ArrayList<Animat> friends = new ArrayList();

    public Black(int n, int n2) {
        super(n, n2);
    }

    public void setup() {
        this.playRole("Black");
        this.randomHeading();
        this.setColor(Color.red);
    }

    private void updatePerceptionsNear(int n) {
        this.ennemies = new ArrayList();
        this.friends = new ArrayList();
        for (int i = 1; i <= n; ++i) {
            this.parseTurtles(this.turtlesAt(i, 0));
            this.parseTurtles(this.turtlesAt(i, -i));
            this.parseTurtles(this.turtlesAt(i, i));
            this.parseTurtles(this.turtlesAt(-i, i));
            this.parseTurtles(this.turtlesAt(-i, 0));
            this.parseTurtles(this.turtlesAt(-i, -i));
            this.parseTurtles(this.turtlesAt(0, i));
            this.parseTurtles(this.turtlesAt(0, -i));
        }
    }

    private void updatePerceptionsAll() {
        this.ennemies = new ArrayList();
        this.friends = new ArrayList();
        for (int i = -this.visionRadius; i <= this.visionRadius; ++i) {
            for (int j = -this.visionRadius; j <= this.visionRadius; ++j) {
                this.parseTurtles(this.turtlesAt(i, j));
            }
        }
    }

    private void parseTurtles(Turtle[] turtleArray) {
        for (Turtle turtle : turtleArray) {
            if (turtle.isPlayingRole(this.enemyString)) {
                this.ennemies.add((Animat)turtle);
                continue;
            }
            this.friends.add((Animat)turtle);
        }
    }

    public String live() {
        if (this.eatWhatever()) {
            if (this.resourceHere() > 10.0) {
                return "live";
            }
            if (this.goForResource()) {
                return "live";
            }
        }
        if (this.life > 25) {
            this.reproduce();
            if (this.goForResource()) {
                return "live";
            }
            this.updatePerceptionsNear(1);
            if (this.towardsTheNearestPrey()) {
                return "live";
            }
        }
        if (this.resourceHere() > 10.0) {
            this.consumeResource();
            if (this.goForResource()) {
                return "live";
            }
            this.updatePerceptionsNear(1);
            if (this.towardsTheNearestPrey()) {
                return "live";
            }
            this.move();
            return "live";
        }
        this.updatePerceptionsNear(this.visionRadius);
        for (Animat animat : this.ennemies) {
            if (this.isFleeingMe(animat)) continue;
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            this.move();
            return "live";
        }
        return "live";
    }

    private double resourceHere() {
        return this.getPatchVariable("resource");
    }

    private boolean goForResource() {
        if (this.towardsRessource()) {
            this.move();
            return true;
        }
        return false;
    }

    private boolean towardsTheNearestPrey() {
        if (!this.ennemies.isEmpty()) {
            Animat animat = this.ennemies.get(0);
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            this.move();
            return true;
        }
        return false;
    }

    public String sacrifice() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            return "waiting";
        }
        return "sacrifice";
    }

    private boolean eatWhatever() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            System.out.println("eatin");
            return true;
        }
        return false;
    }

    public String waiting() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            this.updatePerceptionsNear(1);
            if (this.ennemies.size() > 0) {
                this.flee(this.ennemies.get(0));
            }
            return "waiting";
        }
        this.updatePerceptionsAll();
        if (this.friends.size() > this.ennemies.size()) {
            if (this.life > 50) {
                this.reproduce();
            }
            this.updatePerceptionsNear(1);
            if (this.ennemies.size() > 0) {
                this.flee(this.ennemies.get(0));
            } else if (this.towardsRessource()) {
                this.move();
            }
            return "waiting";
        }
        this.move();
        this.updatePerceptionsNear(1);
        this.consumeResource();
        for (Animat animat : this.ennemies) {
            if (this.isFleeingMe(animat)) continue;
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            this.move();
            this.status = 3;
            return "chase";
        }
        if (this.countTurtlesHere() > 1) {
            this.randomHeading();
            this.move();
        }
        return "waiting";
    }

    private void flee(Animat animat) {
        this.setHeading(this.towards(-animat.realX(), -animat.realY()));
        this.move();
    }

    private boolean isFleeingMe(Animat animat) {
        return !(animat.getHeading() - this.towards(this.xcor() - animat.xcor(), this.ycor() - animat.ycor()) < 45.0);
    }

    public String chase() {
        ArrayList<Animat> arrayList = this.getPreysHere();
        if (!arrayList.isEmpty()) {
            this.eatPrey(arrayList.get(0));
            return "waiting";
        }
        if (this.life < 15) {
            this.status = 1;
            return "sacrifice";
        }
        this.updatePerceptionsNear(this.visionRadius);
        if (this.friends.size() < 2 && this.life > 100) {
            this.reproduce();
        }
        for (Animat animat : this.ennemies) {
            if (this.isFleeingMe(animat)) continue;
            this.setHeading(this.towards(animat.xcor(), animat.ycor()));
            this.move();
            this.status = 3;
            return "chase";
        }
        if (this.ennemies.isEmpty()) {
            this.status = 2;
            return "waiting";
        }
        if (this.towardsTheNearestPrey()) {
            this.move();
            this.status = 3;
            return "chase";
        }
        return "chase";
    }

    private ArrayList<Animat> getPreysHere() {
        ArrayList<Animat> arrayList = new ArrayList<Animat>();
        for (Turtle turtle : this.turtlesHere()) {
            if (!turtle.isPlayingRole(this.enemyString)) continue;
            arrayList.add((Animat)turtle);
        }
        return arrayList;
    }

    public int getStatus() {
        return this.status;
    }

    private boolean towardsRessource() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (j == 0 || i == 0 || !((d2 = this.getPatchVariableAt("resource", i, j)) > d)) continue;
                d = d2;
                n = i;
                n2 = j;
            }
        }
        if (d > 0.0) {
            this.setHeading(this.towards(this.xcor() + n, this.ycor() + n2));
            return true;
        }
        return false;
    }
}

