/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.hunt;

import turtlekit.kernel.Launcher;
import turtlekit.kernel.PatchVariable;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.hunt.Predator;
import turtlekit.simulations.hunt.Prey;

public class HuntLauncher
extends Launcher {
    private int nbOfprey = 50;
    private int nbOfpredator = 30;
    private int predatorVision = 6;
    private boolean withResource = true;
    private double density = 0.01;

    public HuntLauncher() {
        this.setCyclePause(10);
        this.setSimulationName("HUNT");
        this.setWidth(200);
        this.setHeight(200);
    }

    public void setNbOfprey(int n) {
        this.nbOfprey = n;
    }

    public int getNbOfprey() {
        return this.nbOfprey;
    }

    public void setPredatorVision(int n) {
        this.predatorVision = n;
    }

    public int getPredatorVision() {
        return this.predatorVision;
    }

    public void setNbOfpredator(int n) {
        this.nbOfpredator = n;
    }

    public int getNbOfpredator() {
        return this.nbOfpredator;
    }

    protected void initializePatchVariables() {
        PatchVariable patchVariable = new PatchVariable("resource");
        patchVariable.setDiffuseCoef(0.0);
        patchVariable.setEvapCoef(0.0);
        this.addPatchVariable(patchVariable);
    }

    public void addSimulationAgents() {
        Turtle turtle;
        int n;
        this.setCyclePause(10);
        for (n = 0; n < this.nbOfprey; ++n) {
            turtle = new Prey();
            this.addTurtle(turtle);
        }
        for (n = 0; n < this.nbOfpredator; ++n) {
            turtle = new Predator(this.predatorVision);
            this.addTurtle(turtle);
        }
        this.addViewer(3);
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public final boolean isWithResource() {
        return this.withResource;
    }

    public final void setWithResource(boolean bl) {
        this.withResource = bl;
    }
}

