/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.gravity;

import turtlekit.kernel.Launcher;
import turtlekit.kernel.Turtle;
import turtlekit.simulations.gravity.BlackHole;
import turtlekit.simulations.gravity.Star;

public class Gravity
extends Launcher {
    int nbOfPlanet = 200;
    int nbOfSun = 3;
    int rayonMax = 13;

    public void setNbOfPlanet(int n) {
        this.nbOfPlanet = n;
    }

    public int getNbOfPlanet() {
        return this.nbOfPlanet;
    }

    public void setNbOfSun(int n) {
        this.nbOfSun = n;
    }

    public int getNbOfSun() {
        return this.nbOfSun;
    }

    public void setRayonMax(int n) {
        this.rayonMax = n;
    }

    public int getRayonMax() {
        return this.rayonMax;
    }

    public Gravity() {
        this.setSimulationName("Gravity ");
        this.setWidth(200);
        this.setHeight(150);
    }

    public void addSimulationAgents() {
        int n;
        Turtle[] turtleArray = new Turtle[this.nbOfSun];
        for (n = 0; n < this.nbOfSun; ++n) {
            BlackHole blackHole = new BlackHole();
            turtleArray[n] = blackHole;
            this.addTurtle(blackHole);
        }
        for (n = 0; n < this.nbOfPlanet; ++n) {
            this.addTurtle(new Star(turtleArray, this.rayonMax));
        }
        this.addViewer(2);
    }
}

