/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.gameoflife;

import turtlekit.kernel.Launcher;
import turtlekit.kernel.PatchVariable;
import turtlekit.simulations.gameoflife.GridPlayer;
import turtlekit.simulations.gameoflife.LifeViewer;
import turtlekit.simulations.gameoflife.LifeViewer2;
import turtlekit.simulations.gameoflife.LifeViewer3;

public class GameOfLife
extends Launcher {
    double percentage = 0.5;
    boolean doubleGame = false;

    public void setAlivePercentage(double d) {
        this.percentage = d;
    }

    public double getAlivePercentage() {
        return this.percentage;
    }

    public void setDoubleGame(boolean bl) {
        this.doubleGame = bl;
    }

    public boolean getDoubleGame() {
        return this.doubleGame;
    }

    public GameOfLife() {
        this.setSimulationName("game of life");
        this.setWidth(100);
        this.setHeight(100);
        this.setCellSize(4);
    }

    protected void initializePatchVariables() {
        PatchVariable patchVariable = new PatchVariable("lifeValue");
        this.addPatchVariable(patchVariable);
        if (this.doubleGame) {
            PatchVariable patchVariable2 = new PatchVariable("lifeValue2");
            this.addPatchVariable(patchVariable2);
        }
    }

    public void addSimulationAgents() {
        this.addObserver(new GridPlayer(this.percentage, this.doubleGame), false);
        this.addViewer(new LifeViewer());
        if (this.doubleGame) {
            this.addViewer(new LifeViewer2());
            this.addViewer(new LifeViewer3());
        }
    }
}

