/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Kernel;
import madkit.kernel.Overlooker;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.RoleNotHandled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Role
extends HashSet<AgentAddress> {
    private transient HashSet<Overlooker<? extends AbstractAgent>> overlookers;
    private transient ArrayList<AbstractAgent> referenceableAgents;
    private transient ArrayList<AbstractAgent> tmpReferenceableAgents;
    private transient boolean modified = false;

    Role() {
        this.referenceableAgents = new ArrayList();
        this.tmpReferenceableAgents = new ArrayList();
        this.overlookers = new HashSet();
    }

    Role(int n) {
        super(n);
        this.referenceableAgents = new ArrayList(n);
        this.tmpReferenceableAgents = new ArrayList(n);
        this.overlookers = new HashSet();
    }

    synchronized boolean addMember(AgentAddress agentAddress) {
        if (this.add(agentAddress)) {
            AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
            if (abstractAgent instanceof ReferenceableAgent) {
                this.referenceableAgents.add(abstractAgent);
                this.updateOverlookers(abstractAgent, true);
            }
            return true;
        }
        return false;
    }

    synchronized boolean removeMember(AgentAddress agentAddress) {
        if (super.remove(agentAddress)) {
            AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
            if (this.referenceableAgents.remove(abstractAgent)) {
                this.updateOverlookers(abstractAgent, false);
            }
        } else {
            return false;
        }
        return this.isEmpty();
    }

    synchronized boolean removeMemberAndCheck(AgentAddress agentAddress) throws RoleNotHandled {
        if (super.remove(agentAddress)) {
            AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
            if (this.referenceableAgents.remove(abstractAgent)) {
                this.updateOverlookers(abstractAgent, false);
            }
        } else {
            throw new RoleNotHandled();
        }
        return this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.overlookers.isEmpty();
    }

    @Override
    public boolean remove(Object object) {
        if (super.remove(object)) {
            AbstractAgent abstractAgent = Kernel.getReference(object);
            if (this.referenceableAgents.remove(abstractAgent)) {
                this.updateOverlookers(abstractAgent, false);
            }
            return true;
        }
        return false;
    }

    private void updateOverlookers(AbstractAgent abstractAgent, boolean bl) {
        this.modified = true;
        for (Overlooker<? extends AbstractAgent> overlooker : this.overlookers) {
            overlooker.update(abstractAgent, bl);
        }
    }

    synchronized boolean addOverlooker(Overlooker<? extends AbstractAgent> overlooker) {
        if (this.overlookers.add(overlooker)) {
            overlooker.setOverlookedRole(this);
            return true;
        }
        return false;
    }

    synchronized boolean removeOverlooker(Overlooker<? extends AbstractAgent> overlooker) {
        if (this.overlookers.remove(overlooker)) {
            return this.isEmpty() && this.overlookers.isEmpty();
        }
        return false;
    }

    synchronized List<AbstractAgent> getAgentsList() {
        if (this.modified) {
            this.modified = false;
            this.tmpReferenceableAgents = new ArrayList<AbstractAgent>(this.referenceableAgents);
        }
        return this.tmpReferenceableAgents;
    }

    synchronized AbstractAgent getAgentNb(int n) {
        return this.referenceableAgents.get(n);
    }

    void update() {
        this.referenceableAgents = new ArrayList();
        this.overlookers = new HashSet(7);
    }

    @Override
    public void clear() {
        this.referenceableAgents = null;
        this.tmpReferenceableAgents = null;
        for (Overlooker<? extends AbstractAgent> overlooker : this.overlookers) {
            overlooker.setOverlookedRole(null);
        }
        this.overlookers = null;
        super.clear();
    }
}

