/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRException;
import madkit.kernel.Group;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.NotAMemberException;
import madkit.kernel.Overlooker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Organization
extends HashMap<String, Group> {
    private HashSet<AgentAddress> agentsIn = new HashSet();

    Organization() {
    }

    synchronized boolean createGroup(AgentAddress agentAddress, boolean bl, String string, String string2, GroupIdentifier groupIdentifier) {
        if (!this.containsKey(string)) {
            string.intern();
            this.put(string, new Group(agentAddress, bl, string2, groupIdentifier));
            return true;
        }
        if (((Group)this.get(string)).isEmpty()) {
            ((Group)this.get(string)).realCreation(agentAddress, bl, string2, groupIdentifier);
            return true;
        }
        return false;
    }

    synchronized void requestRole(AgentAddress agentAddress, String string, String string2, Object object) throws CGRException {
        Group group = (Group)this.get(string);
        try {
            if (!group.isEmpty() && !string2.equals("group manager")) {
                group.requestRole(agentAddress, string2, object);
            }
            this.agentsIn.add(agentAddress);
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-2, null, string, null, nullPointerException);
        }
        catch (CGRException cGRException) {
            cGRException.setGroup(string);
            throw cGRException;
        }
    }

    synchronized boolean leaveGroup(AgentAddress agentAddress, String string) throws CGRException {
        try {
            if (((Group)this.get(string)).leave(agentAddress)) {
                this.remove(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-2, null, string, null, nullPointerException);
        }
        catch (NotAMemberException notAMemberException) {
            throw new CGRException(-7, null, string, null, notAMemberException);
        }
        return this.isEmpty();
    }

    synchronized boolean leaveRole(AgentAddress agentAddress, String string, String string2) throws CGRException {
        try {
            if (((Group)this.get(string)).leaveRole(agentAddress, string2)) {
                this.remove(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-2, null, string, null, nullPointerException);
        }
        catch (CGRException cGRException) {
            cGRException.setGroup(string);
            throw cGRException;
        }
        return this.isEmpty();
    }

    synchronized boolean addOverlooker(AgentAddress agentAddress, Overlooker overlooker, Object object) {
        try {
            return ((Group)this.get(overlooker.group)).addOverlooker(agentAddress, overlooker, object);
        }
        catch (NullPointerException nullPointerException) {
            Group group = new Group();
            this.put(overlooker.group, group);
            return group.addOverlooker(agentAddress, overlooker, object);
        }
    }

    synchronized boolean removeOverlooker(Overlooker overlooker) {
        try {
            if (((Group)this.get(overlooker.group)).removeOverlooker(overlooker)) {
                this.remove(overlooker.group);
                return this.isEmpty();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    boolean isPlayingRole(AgentAddress agentAddress, String string, String string2) {
        try {
            return ((Group)this.get(string)).isPlayingRole(agentAddress, string2);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    Group getNotEmptyGroup(String string) {
        Group group = (Group)this.get(string);
        try {
            if (!group.isEmpty()) {
                return group;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    Collection<AgentAddress> getRolePlayers(String string, String string2) throws CGRException {
        try {
            return this.getNotEmptyGroup(string).getRolePlayers(string2);
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-2, null, string, null, nullPointerException);
        }
        catch (CGRException cGRException) {
            cGRException.setGroup(string);
            throw cGRException;
        }
    }

    AgentAddress getRolePlayer(String string, String string2) throws CGRException {
        try {
            return this.getNotEmptyGroup(string).getRolePlayer(string2);
        }
        catch (CGRException cGRException) {
            cGRException.setGroup(string);
            throw cGRException;
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-2, null, string, null, nullPointerException);
        }
    }

    String[] getGroupRolesOf(AgentAddress agentAddress, String string) {
        try {
            return ((Group)this.get(string)).getRolesOf(agentAddress);
        }
        catch (NullPointerException nullPointerException) {
            return new String[0];
        }
    }

    boolean isDistributed(String string) {
        try {
            return ((Group)this.get(string)).isDistributed();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    String[] getRolesIn(String string) {
        try {
            return ((Group)this.get(string)).availableRoles();
        }
        catch (NullPointerException nullPointerException) {
            return new String[0];
        }
    }

    synchronized String[] getGroups() {
        HashSet hashSet = new HashSet(this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (((Group)entry.getValue()).isEmpty()) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    synchronized Collection<String> getCurrentGroupsOf(AgentAddress agentAddress) {
        HashSet<String> hashSet = new HashSet<String>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (!((Group)entry.getValue()).isPlayingRole(agentAddress, Group.MEMBER_DEFAULT_ROLE)) continue;
            hashSet.add((String)entry.getKey());
        }
        return hashSet;
    }

    synchronized Map getLocalOrganization() {
        Hashtable hashtable = new Hashtable();
        for (Map.Entry entry : this.entrySet()) {
            if (((Group)entry.getValue()).isEmpty()) continue;
            hashtable.put(entry.getKey(), ((Group)entry.getValue()).mapForm());
        }
        return hashtable;
    }

    synchronized Organization exportOrg() {
        Organization organization = new Organization();
        for (Map.Entry entry : this.entrySet()) {
            Group group = (Group)entry.getValue();
            if (!group.isDistributed() || group.isEmpty()) continue;
            organization.put(entry.getKey(), entry.getValue());
        }
        return organization;
    }

    synchronized void importOrg(Organization organization, boolean bl) {
        for (Map.Entry entry : organization.entrySet()) {
            if (!this.containsKey(entry.getKey())) {
                Group group = new Group();
                this.put(entry.getKey(), group);
                group.merge((Group)entry.getValue(), bl);
                continue;
            }
            ((Group)this.get(entry.getKey())).merge((Group)entry.getValue(), bl);
        }
    }

    synchronized boolean removeAgentsFromKernel(KernelAddress kernelAddress) {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (!group.isDistributed() || !group.removeAgentsFromKernel(kernelAddress)) continue;
            iterator.remove();
        }
        return this.isEmpty();
    }

    ArrayList<String> removeAgentFromAllGroups(AgentAddress agentAddress) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Group group = (Group)entry.getValue();
            if (!group.removeAgentFromGroup(agentAddress)) continue;
            arrayList.add((String)entry.getKey());
            if (!group.isEmpty()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    boolean agentIn(AgentAddress agentAddress) {
        return this.agentsIn.contains(agentAddress);
    }

    void removeAgentFromGroups(Kernel kernel, AgentAddress agentAddress, String string) {
        for (Map.Entry<String, Group> entry : new HashMap<String, Group>(this).entrySet()) {
            entry.getValue().removeAgent(kernel, agentAddress, string, entry.getKey());
        }
    }
}

