/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.Collection;
import java.util.HashSet;
import madkit.boot.Madkit;
import madkit.kernel.AGRTrio;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Kernel;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.Organization;

final class KernelAgent
extends Agent {
    private final Collection<AgentAddress>[] monitor_hooks = new Collection[14];
    private Organization localOrg;

    KernelAgent() {
        for (int i = 0; i < 14; ++i) {
            this.monitor_hooks[i] = new HashSet<AgentAddress>(7);
        }
    }

    public final void activate() {
        this.requestRole("system", "kernel", null);
    }

    public final void live() {
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void end() {
        this.println("KERNEL AGENT KILLED !!!!!!!!!!!!!");
        this.println("UNSTABLE SYSTEM ....");
    }

    private final void handleMessage(Message message) {
        try {
            KernelMessage kernelMessage = (KernelMessage)message;
            switch (kernelMessage.getType()) {
                case 14: {
                    this.invokeKernelOperation(kernelMessage);
                    break;
                }
                default: {
                    this.manageHooks(kernelMessage);
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            this.debug("I received a message of an unknow type : " + classCastException);
        }
    }

    protected final void invokeKernelOperation(KernelMessage kernelMessage) {
        switch (kernelMessage.getOperation()) {
            case 20: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), this.localOrg.getGroups()));
                break;
            }
            case 22: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), this.localOrg.getLocalOrganization()));
                break;
            }
            case 27: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), this.getCurrentKernel().getDumpCommunities()));
                break;
            }
            case 21: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), Kernel.getLocalAgents()));
            }
        }
    }

    protected final void manageHooks(KernelMessage kernelMessage) {
        if (kernelMessage.getOperation() < 14) {
            switch (kernelMessage.getType()) {
                case 22: {
                    if (Madkit.debug) {
                        this.debug("Adding hook:" + kernelMessage.getOperation() + " for " + kernelMessage.getSender());
                    }
                    this.monitor_hooks[kernelMessage.getOperation()].add(kernelMessage.getSender());
                    break;
                }
                case 23: {
                    if (Madkit.debug) {
                        this.debug("Removing hook:" + kernelMessage.getOperation() + " for " + kernelMessage.getSender());
                    }
                    this.monitor_hooks[kernelMessage.getOperation()].remove(kernelMessage.getSender());
                }
            }
        } else {
            this.debug("undefined operation : " + kernelMessage);
        }
    }

    final synchronized void callHooks(int n, Object object) {
        if (Madkit.debug) {
            this.debug("hook called : hook's code is : " + n + " " + object);
        }
        for (AgentAddress agentAddress : this.monitor_hooks[n]) {
            this.sendMessage(agentAddress, new KernelMessage(15, n, object));
        }
    }

    final synchronized void callHooks(int n, AgentAddress agentAddress, String string, String string2, String string3) {
        if (Madkit.debug) {
            this.debug("hook called : hook's code is : " + n + " " + agentAddress + " " + string + " " + string2 + " " + string3);
        }
        for (AgentAddress agentAddress2 : this.monitor_hooks[n]) {
            this.sendMessage(agentAddress2, new KernelMessage(15, n, new AGRTrio(agentAddress, string, string2, string3)));
        }
    }

    final void setLocalOrg(Organization organization) {
        this.localOrg = organization;
    }
}

