/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AccessDeniedException;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRException;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.LeaveGroupException;
import madkit.kernel.NotAMemberException;
import madkit.kernel.Overlooker;
import madkit.kernel.Role;
import madkit.kernel.RoleAlreadyHandled;
import madkit.kernel.RoleNotHandled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Group
extends HashMap<String, Role> {
    private static final String GROUP_MANAGER = "group manager".intern();
    static final String MEMBER_DEFAULT_ROLE = "member".intern();
    private boolean distributed = false;
    private String description = null;
    private GroupIdentifier groupGate = null;

    Group() {
    }

    Group(AgentAddress agentAddress, boolean bl, String string, GroupIdentifier groupIdentifier) {
        this.realCreation(agentAddress, bl, string, groupIdentifier);
    }

    void realCreation(AgentAddress agentAddress, boolean bl, String string, GroupIdentifier groupIdentifier) {
        Serializable serializable;
        if (this.containsKey(GROUP_MANAGER)) {
            serializable = null;
            try {
                serializable = this.getRolePlayer(GROUP_MANAGER);
            }
            catch (CGRException cGRException) {
                // empty catch block
            }
            if (serializable != null) {
                ((Role)this.get(GROUP_MANAGER)).removeMember((AgentAddress)serializable);
            }
            ((Role)this.get(GROUP_MANAGER)).addMember(agentAddress);
        } else {
            serializable = new Role(1);
            ((Role)serializable).addMember(agentAddress);
            this.put(GROUP_MANAGER, serializable);
        }
        if (this.containsKey(MEMBER_DEFAULT_ROLE)) {
            ((Role)this.get(MEMBER_DEFAULT_ROLE)).addMember(agentAddress);
        } else {
            serializable = new Role();
            ((Role)serializable).addMember(agentAddress);
            this.put(MEMBER_DEFAULT_ROLE, serializable);
        }
        this.distributed = bl;
        this.description = string;
        this.groupGate = groupIdentifier;
    }

    private int roleAssignment(AgentAddress agentAddress, String string) throws CGRException {
        Role role = (Role)this.get(string);
        if (role != null) {
            if (role.addMember(agentAddress)) {
                return 1;
            }
            throw new CGRException(-4, null, null, string, new RoleAlreadyHandled());
        }
        string.intern();
        role = new Role();
        role.addMember(agentAddress);
        this.put(string, role);
        return 1;
    }

    int requestRole(AgentAddress agentAddress, String string, Object object) throws CGRException {
        if (this.groupGate != null) {
            if (this.groupGate.allowAgentToTakeRole(agentAddress, string, object)) {
                return this.roleAssignment(agentAddress, string);
            }
            throw new CGRException(-5, null, null, string, new AccessDeniedException());
        }
        return this.roleAssignment(agentAddress, string);
    }

    boolean leave(AgentAddress agentAddress) throws NotAMemberException {
        try {
            if (((Role)this.get(MEMBER_DEFAULT_ROLE)).removeMemberAndCheck(agentAddress)) {
                this.remove(MEMBER_DEFAULT_ROLE);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("!!!!!! This should not happen : kernel internal error ");
            nullPointerException.printStackTrace();
        }
        catch (RoleNotHandled roleNotHandled) {
            throw new NotAMemberException();
        }
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            if (!((Role)iterator.next()).removeMember(agentAddress)) continue;
            iterator.remove();
        }
        return super.isEmpty();
    }

    boolean removeAgentsFromKernel(KernelAddress kernelAddress) {
        ArrayList<AgentAddress> arrayList = new ArrayList<AgentAddress>(this.size());
        if (kernelAddress == null) {
            for (AgentAddress agentAddress : (Role)this.get(MEMBER_DEFAULT_ROLE)) {
                if (agentAddress.isLocal()) continue;
                arrayList.add(agentAddress);
            }
        } else {
            for (AgentAddress agentAddress : (Role)this.get(MEMBER_DEFAULT_ROLE)) {
                if (!agentAddress.getKernel().equals(kernelAddress)) continue;
                arrayList.add(agentAddress);
            }
        }
        for (AgentAddress agentAddress : arrayList) {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                if (!((Role)iterator.next()).removeMember(agentAddress)) continue;
                iterator.remove();
            }
        }
        return super.isEmpty();
    }

    boolean leaveRole(AgentAddress agentAddress, String string) throws CGRException {
        try {
            if (((Role)this.get(string)).removeMemberAndCheck(agentAddress)) {
                this.remove(string);
                return super.isEmpty();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-3, null, null, string, nullPointerException);
        }
        catch (RoleNotHandled roleNotHandled) {
            throw new CGRException(-6, null, null, string, roleNotHandled);
        }
        return false;
    }

    boolean addOverlooker(AgentAddress agentAddress, Overlooker<? extends AbstractAgent> overlooker, Object object) {
        if (this.groupGate != null && !this.groupGate.allowOverlooking(agentAddress, object)) {
            return false;
        }
        if (this.containsKey(overlooker.role)) {
            return ((Role)this.get(overlooker.role)).addOverlooker(overlooker);
        }
        Role role = Kernel.agressiveHeapMode ? new Role(Kernel.defaultAgentsAllocation) : new Role();
        this.put(overlooker.role, role);
        return role.addOverlooker(overlooker);
    }

    boolean removeOverlooker(Overlooker<? extends AbstractAgent> overlooker) {
        try {
            if (((Role)this.get(overlooker.role)).removeOverlooker(overlooker)) {
                this.remove(overlooker.role);
                return super.isEmpty();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    boolean isDistributed() {
        return this.distributed;
    }

    @Override
    public boolean isEmpty() {
        try {
            return ((Role)this.get(MEMBER_DEFAULT_ROLE)).isEmpty();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    boolean isPlayingRole(AgentAddress agentAddress, String string) {
        try {
            return ((Role)this.get(string)).contains(agentAddress);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    Collection<AgentAddress> getRolePlayers(String string) throws CGRException {
        Collection collection = (Collection)this.get(string);
        if (collection == null) {
            throw new CGRException(-3, null, null, string, null);
        }
        return collection;
    }

    AgentAddress getRolePlayer(String string) throws CGRException {
        try {
            ArrayList<AgentAddress> arrayList = new ArrayList<AgentAddress>(this.getRolePlayers(string));
            return (AgentAddress)arrayList.get((int)(Math.random() * (double)arrayList.size()));
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-3, null, null, string, nullPointerException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("!!!!!! This should not happen : kernel internal error ");
            indexOutOfBoundsException.printStackTrace();
            return null;
        }
    }

    String[] getRolesOf(AgentAddress agentAddress) {
        TreeSet treeSet = new TreeSet();
        for (Map.Entry entry : this.entrySet()) {
            if (!((Role)entry.getValue()).contains(agentAddress)) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    String[] availableRoles() {
        TreeSet treeSet = new TreeSet();
        for (Map.Entry entry : this.entrySet()) {
            if (((Role)entry.getValue()).isEmpty()) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    Map<String, Collection<Role>> mapForm() {
        Hashtable<String, Collection<Role>> hashtable = new Hashtable<String, Collection<Role>>();
        for (Map.Entry entry : this.entrySet()) {
            if (((Role)entry.getValue()).isEmpty()) continue;
            hashtable.put((String)entry.getKey(), new Vector((Collection)entry.getValue()));
        }
        return hashtable;
    }

    void merge(Group group, boolean bl) {
        if (bl) {
            try {
                if (group.getRolePlayer(GROUP_MANAGER) != null) {
                    this.realCreation(group.getRolePlayer(GROUP_MANAGER), true, group.getDescription(), group.getGroupIdentifier());
                }
            }
            catch (CGRException cGRException) {}
        } else {
            try {
                if (this.getRolePlayer(GROUP_MANAGER) == null || this.isEmpty() && group.getRolePlayer(MEMBER_DEFAULT_ROLE) != null) {
                    this.realCreation(group.getRolePlayer(MEMBER_DEFAULT_ROLE), true, this.getDescription(), this.getGroupIdentifier());
                }
            }
            catch (CGRException cGRException) {
                // empty catch block
            }
        }
        if (this.isEmpty()) {
            Role role = Kernel.agressiveHeapMode ? new Role(Kernel.defaultAgentsAllocation) : new Role();
            this.put(MEMBER_DEFAULT_ROLE, role);
        }
        for (String string : group.keySet()) {
            if (string.equals(GROUP_MANAGER)) continue;
            for (AgentAddress agentAddress : (Role)group.get(string)) {
                try {
                    this.roleAssignment(agentAddress, string);
                }
                catch (CGRException cGRException) {}
            }
        }
    }

    GroupIdentifier getGroupIdentifier() {
        return this.groupGate;
    }

    String getDescription() {
        return this.description;
    }

    void removeAgent(Kernel kernel, AgentAddress agentAddress, String string, String string2) {
        if (((Role)this.get(MEMBER_DEFAULT_ROLE)).contains(agentAddress)) {
            try {
                kernel.leaveGroup(agentAddress, string, string2);
            }
            catch (LeaveGroupException leaveGroupException) {
                leaveGroupException.printStackTrace();
            }
        }
    }

    boolean removeAgentFromGroup(AgentAddress agentAddress) {
        boolean bl = false;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.removeMember(agentAddress)) continue;
            if (role.isEmpty()) {
                iterator.remove();
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        for (Role role : this.values()) {
            role.clear();
        }
        super.clear();
    }
}

