/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Vector;
import madkit.boot.Madkit;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRException;
import madkit.kernel.Controller;
import madkit.kernel.Group;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.LaunchAgentException;
import madkit.kernel.LeaveGroupException;
import madkit.kernel.LeaveRoleException;
import madkit.kernel.MadkitException;
import madkit.kernel.Message;
import madkit.kernel.MessageException;
import madkit.kernel.OrganizationRequestException;
import madkit.kernel.RequestRoleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAgent
implements Serializable {
    private transient Object currentBean;
    private transient Writer ostream;
    private boolean debugFlag = false;
    private AgentAddress myAddress = null;
    transient Kernel currentKernel = null;
    final Vector<Message> messageBox;
    private Controller controller = null;
    private final int _hashCode = ++agentCounter;
    private static int agentCounter = 0;

    public AbstractAgent() {
        this.messageBox = new Vector();
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void activate() {
    }

    public void end() {
    }

    public int createGroup(boolean bl, String string, String string2, String string3, GroupIdentifier groupIdentifier) {
        if (string3 == null) {
            string3 = string2;
        }
        try {
            this.currentKernel.createGroup(this.getAddress(), bl, string, string2, string3, groupIdentifier);
        }
        catch (OrganizationRequestException organizationRequestException) {
            return this.handleException(organizationRequestException);
        }
        return 1;
    }

    public int createGroup(boolean bl, String string, String string2, GroupIdentifier groupIdentifier) {
        return this.createGroup(bl, Kernel.DEFAULT_COMMUNITY, string, string2, groupIdentifier);
    }

    public int requestRole(String string, String string2, String string3, Object object) {
        try {
            this.currentKernel.requestRole(this.getAddress(), string, string2, string3, object);
            return 1;
        }
        catch (RequestRoleException requestRoleException) {
            return this.handleException(requestRoleException);
        }
    }

    public int requestRole(String string, String string2, Object object) {
        return this.requestRole(Kernel.DEFAULT_COMMUNITY, string, string2, object);
    }

    public int leaveRole(String string, String string2, String string3) {
        try {
            this.currentKernel.leaveRole(this.getAddress(), string, string2, string3);
            return 1;
        }
        catch (LeaveRoleException leaveRoleException) {
            return this.handleException(leaveRoleException);
        }
    }

    public int leaveRole(String string, String string2) {
        return this.leaveRole(Kernel.DEFAULT_COMMUNITY, string, string2);
    }

    public int leaveGroup(String string, String string2) {
        try {
            this.currentKernel.leaveGroup(this.getAddress(), string, string2);
            return 1;
        }
        catch (LeaveGroupException leaveGroupException) {
            return this.handleException(leaveGroupException);
        }
    }

    public int leaveGroup(String string) {
        return this.leaveGroup(Kernel.DEFAULT_COMMUNITY, string);
    }

    public void joinGroup(String string) {
        if (this.currentKernel.isGroup(Kernel.DEFAULT_COMMUNITY, string)) {
            this.requestRole(Kernel.DEFAULT_COMMUNITY, string, Group.MEMBER_DEFAULT_ROLE, null);
        } else {
            this.createGroup(true, Kernel.DEFAULT_COMMUNITY, string, null, null);
        }
    }

    public void requestRole(String string, String string2) throws RequestRoleException {
        this.currentKernel.requestRole(this.getAddress(), Kernel.DEFAULT_COMMUNITY, string, string2, null);
    }

    public void foundGroup(String string) throws OrganizationRequestException {
        this.currentKernel.createGroup(this.getAddress(), true, Kernel.DEFAULT_COMMUNITY, string, string, null);
    }

    public AgentAddress[] getAgentsWithRole(String string, String string2, String string3) {
        try {
            return this.currentKernel.getRolePlayers(string, string2, string3);
        }
        catch (CGRException cGRException) {
            return new AgentAddress[0];
        }
    }

    public AgentAddress[] getAgentsWithRole(String string, String string2) {
        return this.getAgentsWithRole(Kernel.DEFAULT_COMMUNITY, string, string2);
    }

    public AgentAddress getAgentWithRole(String string, String string2, String string3) {
        try {
            return this.currentKernel.getAnotherRolePlayer(this, string, string2, string3);
        }
        catch (CGRException cGRException) {
            return null;
        }
    }

    public AgentAddress getAgentWithRole(String string, String string2) {
        return this.getAgentWithRole(Kernel.DEFAULT_COMMUNITY, string, string2);
    }

    public String[] getMyGroups(String string) {
        return this.currentKernel.getCurrentGroupsOf(this.getAddress(), string);
    }

    public String[] getMyGroups() {
        return this.currentKernel.getCurrentGroupsOf(this.getAddress(), Kernel.DEFAULT_COMMUNITY);
    }

    public String[] getExistingGroups(String string) {
        return this.currentKernel.getExistingGroups(string);
    }

    public String[] getExistingGroups() {
        return this.currentKernel.getExistingGroups(Kernel.DEFAULT_COMMUNITY);
    }

    public boolean isMemberOf(String string, String string2) {
        return this.currentKernel.isBelongingToGroup(this.getAddress(), string, string2);
    }

    public boolean isMemberOf(String string) {
        return this.currentKernel.isBelongingToGroup(this.getAddress(), Kernel.DEFAULT_COMMUNITY, string);
    }

    public boolean isBelongingToGroup(AgentAddress agentAddress, String string, String string2) {
        return this.currentKernel.isBelongingToGroup(agentAddress, string, string2);
    }

    public boolean isBelongingToGroup(AgentAddress agentAddress, String string) {
        return this.currentKernel.isBelongingToGroup(agentAddress, Kernel.DEFAULT_COMMUNITY, string);
    }

    public String[] getMyRoles(String string, String string2) {
        return this.currentKernel.getGroupRolesOf(this.getAddress(), string, string2);
    }

    public String[] getMyRoles(String string) {
        return this.currentKernel.getGroupRolesOf(this.getAddress(), Kernel.DEFAULT_COMMUNITY, string);
    }

    public String[] getExistingRoles(String string, String string2) {
        return this.currentKernel.getExistingRoles(string, string2);
    }

    public String[] getExistingRoles(String string) {
        return this.currentKernel.getExistingRoles(Kernel.DEFAULT_COMMUNITY, string);
    }

    public String[] getRoles(String string) {
        return this.getExistingRoles(Kernel.DEFAULT_COMMUNITY, string);
    }

    public boolean isRole(String string, String string2, String string3) {
        return this.getAgentWithRole(string, string2, string3) != null;
    }

    public boolean isRole(String string, String string2) {
        return this.isRole(Kernel.DEFAULT_COMMUNITY, string, string2);
    }

    public Vector<String> getGroups() {
        String[] stringArray = this.currentKernel.getCurrentGroupsOf(this.getAddress(), Kernel.DEFAULT_COMMUNITY);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public boolean isGroup(String string, String string2) {
        return this.currentKernel.isGroup(string, string2);
    }

    public boolean isGroup(String string) {
        return this.currentKernel.isGroup(Kernel.DEFAULT_COMMUNITY, string);
    }

    public boolean isCommunity(String string) {
        return this.currentKernel.isCommunity(string);
    }

    public String[] getAvailableCommunities() {
        return this.currentKernel.getCommunities();
    }

    public boolean connectedWithCommunity(String string) {
        return this.currentKernel.connectedWithCommunity(string);
    }

    public void destroyGroup(String string, String string2) {
        this.currentKernel.destroyGroup(string, string2);
    }

    public boolean isMessageBoxEmpty() {
        return this.messageBox.isEmpty();
    }

    public int getMessageBoxSize() {
        return this.messageBox.size();
    }

    public Message nextMessage() {
        if (!this.isMessageBoxEmpty()) {
            return this.messageBox.remove(0);
        }
        return null;
    }

    protected void receiveMessage(Message message) {
        this.messageBox.add(message);
    }

    public void sendMessage(AgentAddress agentAddress, Message message) throws MessageException {
        if (agentAddress != null) {
            try {
                message.setReceiver(agentAddress);
            }
            catch (NullPointerException nullPointerException) {
                throw new MessageException(this.getAddress(), " Cannot send a null message", null);
            }
            message.setSender(this.getAddress());
            try {
                this.currentKernel.sendMessage(message);
            }
            catch (MessageException messageException) {
                this.handleException(messageException);
            }
        } else {
            try {
                throw new MessageException(this.getAddress(), " Cannot send a message to a null recipient", null);
            }
            catch (MessageException messageException) {
                this.handleException(messageException);
                return;
            }
        }
    }

    public boolean sendMessage(String string, String string2, String string3, Message message) throws MessageException {
        if (!Kernel.interGroupMessage && !this.currentKernel.isBelongingToGroup(this.getAddress(), string, string2)) {
            throw new MessageException(this.getAddress(), " I am not allowed to send inter group messages !", null);
        }
        AgentAddress agentAddress = this.getAgentWithRole(string, string2, string3);
        if (agentAddress == null) {
            try {
                throw new MessageException(this.getAddress(), " Cannot send a message to a null recipient : no agent handles the role <" + string + "," + string2 + "," + string3 + ">", null);
            }
            catch (MessageException messageException) {
                this.handleException(messageException);
                return false;
            }
        }
        this.sendMessage(agentAddress, message);
        return true;
    }

    public void sendMessage(String string, String string2, Message message) throws MessageException {
        this.sendMessage(Kernel.DEFAULT_COMMUNITY, string, string2, message);
    }

    public void broadcastMessage(String string, String string2, String string3, Message message) throws MessageException {
        try {
            message.setSender(this.getAddress());
        }
        catch (NullPointerException nullPointerException) {
            throw new MessageException(this.getAddress(), " Cannot broadcast a null message", null);
        }
        try {
            this.currentKernel.sendBroadcastMessage(string, string2, string3, message);
        }
        catch (MessageException messageException) {
            this.handleException(messageException);
        }
    }

    public void broadcastMessage(String string, String string2, Message message) throws MessageException {
        this.broadcastMessage(Kernel.DEFAULT_COMMUNITY, string, string2, message);
    }

    public void launchAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        this.launchAgent(abstractAgent, string, bl ? new Point(-1, -1) : null, bl ? new Dimension(-1, -1) : null);
    }

    public void launchAgent(AbstractAgent abstractAgent, String string, Point point, Dimension dimension) {
        if (string == null) {
            string = "unamed";
        }
        try {
            this.currentKernel.launchAgent(abstractAgent, string, this, point != null, point, dimension);
        }
        catch (LaunchAgentException launchAgentException) {
            this.handleException(launchAgentException);
        }
    }

    public void restoreAgent(AbstractAgent abstractAgent) {
        this.currentKernel.restoreAgent(abstractAgent, abstractAgent.getName(), this, abstractAgent.hasGUI());
    }

    public void killAgent(AbstractAgent abstractAgent) {
        try {
            this.currentKernel.killAgent(abstractAgent, this);
        }
        catch (OrganizationRequestException organizationRequestException) {
            this.handleException(organizationRequestException);
        }
    }

    public AgentAddress getAddress() {
        return this.myAddress;
    }

    public void setName(String string) {
        this.myAddress.setName(string);
    }

    public String getName() {
        return this.myAddress.getName();
    }

    final void setCurrentKernel(Kernel kernel) {
        this.currentKernel = kernel;
    }

    final Kernel getCurrentKernel() {
        return this.currentKernel;
    }

    public KernelAddress getCurrentKernelAddress() {
        return Kernel.getAddress();
    }

    public boolean hasGUI() {
        return this.currentBean != null;
    }

    public void initGUI() {
        if (this.currentKernel != null) {
            this.setGUIObject(this.currentKernel.gui.getDefaultGUIObject(this));
        }
    }

    public void setBean(Object object) {
        this.currentBean = object;
    }

    public Object getBean() {
        return this.currentBean;
    }

    public void setGUIObject(Object object) {
        this.currentBean = object;
    }

    public Object getGUIObject() {
        return this.currentBean;
    }

    public void debug(String string) {
        if (this.debugFlag) {
            try {
                if (this.ostream != null) {
                    this.ostream.write("*Debug* " + string);
                } else {
                    System.err.println("[" + this.getAddress() + "] : *Debug* " + string);
                }
            }
            catch (IOException iOException) {
                this.currentKernel.displayln("IOException println: " + iOException.toString());
                iOException.printStackTrace();
            }
        }
    }

    public void setDebug(boolean bl) {
        this.debugFlag = bl;
    }

    public boolean getDebug() {
        return this.debugFlag;
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        try {
            if (this.ostream != null) {
                this.ostream.write(string);
            } else {
                System.err.println("[" + this.getName() + "] : " + string);
            }
        }
        catch (IOException iOException) {
            this.currentKernel.displayln("IOException println: " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    public void setOutput(Writer writer) {
        this.setOutputWriter(writer);
    }

    public void setOutputWriter(Writer writer) {
        this.ostream = writer;
    }

    public void disposeMyGUI() {
        this.setOutputWriter(null);
        this.currentKernel.disposeGUIOf(this);
    }

    public void hideMyGUI() {
        this.currentKernel.disposeGUIOf(this);
    }

    public void redisplayMyGUI() {
        this.currentKernel.redisplayGUIOf(this);
    }

    public void windowClosing(AWTEvent aWTEvent) {
        if (this.currentKernel != null) {
            this.killAgent(this);
        }
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return this.getAddress().toString();
    }

    private final int handleException(MadkitException madkitException) {
        if (Madkit.outputOnRequestErrors) {
            this.println(madkitException.getClass().getSimpleName() + madkitException.getMessage());
            if (this.getDebug()) {
                madkitException.printStackTrace();
            }
        }
        return madkitException.getCode();
    }

    final void setMyAddress(AgentAddress agentAddress) {
        this.myAddress = agentAddress;
    }

    Thread getAgentThread() {
        return null;
    }
}

