/*
 * Decompiled with CFR 0.152.
 */
package madkit.games.tictactoe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import madkit.games.tictactoe.FourInARow;
import madkit.games.tictactoe.GameCases;
import madkit.games.tictactoe.GameCasesDisplay;
import madkit.games.tictactoe.TicTacToe;
import madkit.games.tictactoe.TicTacToeAgent;

public class GameCasesFrame
extends JRootPane
implements ActionListener {
    public static final int TICTACTOE = 0;
    public static final int FOURINAROW = 1;
    public static final String[] gameName = new String[]{"TicTacToe", "4 in a row"};
    GameCases game;
    JLabel msg = new JLabel();
    int gameType = 0;
    TicTacToeAgent ag;
    int size = 5;
    int nbAlign = 5;
    JButton bNew;
    JTextField jtextSize;
    JTextField jtextNbAlign;
    JLabel jGameType;
    boolean master = false;
    GameCasesDisplay display;

    GameCases getGame() {
        return this.game;
    }

    void setMaster(boolean bl) {
        this.master = bl;
        if (bl) {
            this.bNew.setEnabled(bl);
            this.jtextSize.setEnabled(bl);
            this.jtextNbAlign.setEnabled(bl);
        }
    }

    public GameCasesFrame(TicTacToeAgent ticTacToeAgent) {
        this.ag = ticTacToeAgent;
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(400, 400);
        this.bNew = new JButton("New");
        this.bNew.setEnabled(false);
        JLabel jLabel = new JLabel("Size:");
        this.jtextSize = new JTextField("" + this.size, 3);
        this.jtextSize.setEnabled(false);
        JLabel jLabel2 = new JLabel("Number to align :");
        this.jtextNbAlign = new JTextField("" + this.nbAlign, 3);
        this.jtextNbAlign.setEnabled(false);
        this.jGameType = new JLabel(gameName[this.gameType]);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(this.jtextSize);
        jPanel.add(this.bNew);
        jPanel.add(jLabel2);
        jPanel.add(this.jtextNbAlign);
        jPanel.add(this.jGameType);
        this.getContentPane().add((Component)jPanel, "North");
        this.bNew.addActionListener(this);
        this.getContentPane().add((Component)this.msg, "South");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Start");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "New Game", "New", 78);
        this.addMenuItem(jMenu, "Quit", "Quit", 81);
        JMenu jMenu2 = new JMenu("Games");
        jMenuBar.add(jMenu2);
        this.addMenuItem(jMenu2, "TicTacToe", "TicTacToe", -1);
        this.addMenuItem(jMenu2, "4 in a Row ", "4InARow", -1);
        JMenu jMenu3 = new JMenu("Aide");
        jMenuBar.add(jMenu3);
        this.addMenuItem(jMenu3, "Help", "Help", -1);
        this.addMenuItem(jMenu3, "About", "About", -1);
    }

    void newGame() {
        int n = Integer.parseInt(this.jtextSize.getText());
        int n2 = Integer.parseInt(this.jtextNbAlign.getText());
        int n3 = this.gameType;
        this.newGame(n, n2, n3);
        this.ag.sendNewGame(n, n2, n3);
    }

    void newDefaultGame() {
        this.newGame(this.size, this.nbAlign, this.gameType);
    }

    void newGame(int n, int n2, int n3) {
        this.size = n;
        this.nbAlign = n2;
        this.gameType = n3;
        this.jtextSize.setText("" + n);
        this.jtextNbAlign.setText("" + n2);
        this.jGameType.setText(gameName[this.gameType]);
        if (this.nbAlign > this.size) {
            this.nbAlign = this.size;
        }
        switch (this.gameType) {
            case 0: {
                this.game = new TicTacToe(this, this.size, this.nbAlign);
                break;
            }
            case 1: {
                this.game = new FourInARow(this, this.size, this.nbAlign);
            }
        }
        if (this.display != null) {
            this.getContentPane().remove(this.display);
        }
        this.display = new GameCasesDisplay(this.game);
        this.game.setDisplay(this.display);
        this.game.setAgent(this.ag);
        this.ag.setGame(this.game);
        this.game.newGame();
        this.getContentPane().add((Component)this.display, "Center");
        this.validate();
    }

    void message(String string) {
        this.msg.setText(string);
    }

    void setColor(int n) {
        this.game.setCurrentColor(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("New")) {
            this.newGame();
        } else if (string.equals("Quit")) {
            System.exit(0);
        } else if (string.equals("TicTacToe")) {
            if (this.gameType != 0) {
                this.gameType = 0;
                this.newGame();
            }
        } else if (string.equals("4InARow") && this.gameType != 1) {
            this.gameType = 1;
            this.newGame();
        }
    }

    void addMenuItem(JMenu jMenu, String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        if (n > 0) {
            if (n != 127) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2, false));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 0, false));
            }
        }
    }
}

