/*
 * Decompiled with CFR 0.152.
 */
package madkit.demos.gpong;

import java.awt.Color;
import java.awt.Graphics;
import madkit.demos.gpong.ComputerPlayer;
import madkit.demos.gpong.GPongGUI;

public class PongBall {
    private int x_pos;
    private int y_pos;
    private int x_speed;
    private int y_speed;
    GPongGUI display;
    private int right_out = 390;
    private int left_out = 10;
    private int down_out = 290;
    private int up_out = 10;
    static final int radius = 10;

    public int getXSpeed() {
        return this.x_speed;
    }

    public int getYPos() {
        return this.y_pos;
    }

    public PongBall(GPongGUI gPongGUI, int n, int n2) {
        this.x_pos = n;
        this.y_pos = n2;
        this.x_speed = 3;
        this.y_speed = 3;
        this.display = gPongGUI;
    }

    void setSpeed(int n, int n2) {
        this.x_speed = n;
        this.y_speed = n2;
    }

    public void move() {
        this.x_pos += this.x_speed;
        this.y_pos += this.y_speed;
        this.isBallOut();
    }

    public void isBallOut() {
        this.down_out = this.display.getHeight() - 10;
        this.right_out = this.display.getWidth() - 10;
        if (this.x_speed < 0 && this.x_pos < this.left_out) {
            if (!this.display.getSide()) {
                this.display.leaveBall(this.y_pos, this.x_speed, this.y_speed);
            } else {
                this.x_speed = -this.x_speed;
            }
        } else if (this.x_speed > 0 && this.x_pos > this.right_out) {
            if (this.display.getSide()) {
                this.display.leaveBall(this.y_pos, this.x_speed, this.y_speed);
            } else {
                this.x_speed = -this.x_speed;
            }
        }
        if (this.y_speed < 0) {
            if (this.y_pos < this.up_out) {
                this.y_speed = -this.y_speed;
            }
        } else if (this.y_speed > 0 && this.y_pos > this.down_out) {
            this.y_speed = -this.y_speed;
        }
    }

    public void testForCollisionComputer(ComputerPlayer computerPlayer) {
        boolean bl = this.display.getSide();
        if (bl && this.x_speed < 0 || !bl && this.x_speed > 0) {
            int n = this.y_pos - 10;
            int n2 = this.y_pos + 10;
            int n3 = this.x_pos - 10;
            int n4 = this.x_pos + 10;
            int n5 = computerPlayer.getYPos();
            int n6 = computerPlayer.getYPos() + computerPlayer.getYSize();
            int n7 = computerPlayer.getXPos() + computerPlayer.getXSize();
            int n8 = computerPlayer.getXPos();
            if (n >= n5 - 10 && n2 <= n6 + 10) {
                if (bl) {
                    if (n3 <= n7) {
                        this.x_speed = -this.x_speed;
                    }
                } else if (n4 >= n8) {
                    this.x_speed = -this.x_speed;
                }
            }
        }
    }

    public void display(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.fillOval(this.x_pos - 10, this.y_pos - 10, 20, 20);
    }
}

