/*
 * Decompiled with CFR 0.152.
 */
package madkit.demos.gpong;

import madkit.demos.gpong.BallMessage;
import madkit.demos.gpong.GPongGUI;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ActMessage;

public class GPongAgent
extends Agent {
    AgentAddress other = null;
    boolean creator = false;
    String groupName = "graphic-ping-pong";
    GPongGUI gui;

    public void initGUI() {
        this.gui = new GPongGUI(this);
        this.setGUIObject(this.gui);
    }

    public void activate() {
        if (this.createGroup(true, this.groupName, null, null) == 1) {
            this.creator = true;
            this.gui.setRightPlayer();
        } else {
            this.creator = false;
            this.gui.setLeftPlayer();
        }
        this.requestRole(this.groupName, "player", null);
    }

    public void live() {
        Object object;
        Message message;
        do {
            this.exitImmediatlyOnKill();
            this.pause(100);
            message = this.getAgentsWithRole(this.groupName, "player");
            for (int i = 0; i < ((AgentAddress[])message).length; ++i) {
                object = message[i];
                if (object.equals((Object)this.getAddress())) continue;
                this.other = object;
            }
        } while (this.other == null);
        this.println("Other is :" + this.other);
        if (!this.creator) {
            this.sendMessage(this.other, (Message)new StringMessage("start"));
            this.gui.start();
        }
        while (true) {
            StringMessage stringMessage;
            if ((message = this.waitNextMessage()) instanceof BallMessage) {
                BallMessage ballMessage = (BallMessage)message;
                this.gui.createBall(ballMessage.getPosY(), ballMessage.getSpeedX(), ballMessage.getSpeedY());
                continue;
            }
            if (message instanceof ActMessage) {
                ActMessage actMessage = (ActMessage)message;
                if (!actMessage.getAction().equals("ball position")) continue;
                object = (int[])actMessage.getObject();
                this.gui.createBall((int)object[0], (int)object[1], (int)object[2]);
                continue;
            }
            if (!(message instanceof StringMessage) || !(stringMessage = (StringMessage)message).getString().equals("start")) continue;
            if (!this.creator) {
                this.creator = true;
                this.gui.setRightPlayer();
            }
            this.gui.createInitBall();
            this.gui.start();
        }
    }

    public void end() {
        this.gui.setGoOn(false);
    }

    void sendBall(int n, int n2, int n3) {
        AgentAddress[] agentAddressArray = this.getAgentsWithRole(this.groupName, "player");
        for (int i = 0; i < agentAddressArray.length; ++i) {
            AgentAddress agentAddress = agentAddressArray[i];
            if (agentAddress.equals((Object)this.getAddress())) continue;
            this.other = agentAddress;
            break;
        }
        int[] nArray = new int[]{n, n2, n3};
        this.sendMessage(this.other, (Message)new ActMessage("ball position", (Object)nArray));
    }
}

