/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.share.AbstractServerAgent;
import madkit.share.AssocPath;
import madkit.share.FicDataBase;
import madkit.share.FicMessage;
import madkit.share.FileInfo;
import madkit.share.IndexMessage;
import madkit.share.ListFic;
import madkit.share.ListPluginInfo;
import madkit.share.OffsetMessage;
import madkit.share.PluginInfo;
import madkit.share.PluginInfoMessage;
import madkit.share.PluginVersionNumber;
import madkit.share.RequestPluginInfoMessage;
import madkit.share.RequestSearchFileMessage;
import madkit.share.RequestTreeMessage;
import madkit.share.SearchFileMessage;
import madkit.share.SenderAgentPanel;
import madkit.share.SmallSenderAgent;
import madkit.share.TreeMessage;

public class SenderAgent
extends AbstractServerAgent {
    public String pluginsPath;
    FicDataBase pluginDataBase;
    ListPluginInfo listPluginInfo;

    public void initGUI() {
        this.display = new SenderAgentPanel(this);
        this.setGUIObject(this.display);
    }

    public void activate() {
        this.createGroup(true, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.live = true;
        this.initDir();
        this.dataBase = new FicDataBase();
        this.listPluginInfo = new ListPluginInfo();
        this.initPluginsDataBase(this.dataBase);
    }

    public void live() {
        while (this.live) {
            Message message = this.waitNextMessage();
            try {
                this.handleMessage(message);
            }
            catch (IOException iOException) {
                System.out.println("Error : SenderAgent --> HandleMessage");
            }
        }
    }

    public void end() {
        for (int i = 0; i < this.smallSenderAgentList.size(); ++i) {
            this.killAgent((AbstractAgent)((SmallSenderAgent)((Object)this.smallSenderAgentList.elementAt(i))));
        }
    }

    void handleMessage(Message message) throws IOException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        if (message instanceof RequestPluginInfoMessage) {
            System.out.println("(server) RequestPluginInfoMessage received");
            object4 = ((RequestPluginInfoMessage)message).getSender();
            this.sendMessage((AgentAddress)object4, new PluginInfoMessage(this.listPluginInfo));
        } else if (message instanceof RequestTreeMessage) {
            System.out.println("(server) RequestTreeMessage received");
            object4 = ((RequestTreeMessage)message).getText();
            if (((String)object4).equals("request-tree")) {
                object3 = ((RequestTreeMessage)message).getSender();
                this.sendMessage((AgentAddress)object3, new TreeMessage((DirEntry)((SenderAgentPanel)this.display).getEntry()));
            }
        } else if (message instanceof FicMessage) {
            object4 = ((FicMessage)message).getSender().getKernel().getHost().toString();
            object3 = ((FicMessage)message).getSender();
            object2 = ((FicMessage)message).getPath();
            n = ((FicMessage)message).getUpdatePlugin();
            System.out.println("(server) Request file " + (String)object2);
            object = this.dataBase.searchRealPath((String)object2);
            if (object.equals("error")) {
                System.out.println("Fichier non autorise :" + (String)object2);
                return;
            }
            ListFic listFic = new ListFic();
            File file = new File((String)object);
            if (file.isDirectory()) {
                if (n != 0) {
                    this.dirPluginIndex((String)object2, (String)object, listFic);
                } else {
                    this.dirIndex((String)object2, (String)object, listFic);
                }
            } else {
                int n2 = (int)file.length();
                FileInfo fileInfo = new FileInfo((String)object2, n2);
                listFic.getVector().addElement(fileInfo);
            }
            this.sendMessage((AgentAddress)object3, new IndexMessage(listFic, this.getAddress(), n != 0));
        } else if (message instanceof RequestSearchFileMessage) {
            object4 = ((RequestSearchFileMessage)message).getSender();
            object3 = ((RequestSearchFileMessage)message).getFile();
            object2 = this.dataBase.searchFile(((RequestSearchFileMessage)message).getFile());
            if (!((Vector)object2).isEmpty()) {
                System.out.println("---> File " + ((RequestSearchFileMessage)message).getFile() + " found");
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    this.sendMessage((AgentAddress)object4, new SearchFileMessage((String)object3, ((AssocPath)((Vector)object2).elementAt(n)).getVirtualPath(), ((AssocPath)((Vector)object2).elementAt(n)).getSizeFile(), ((AssocPath)((Vector)object2).elementAt(n)).isDirectory()));
                }
            }
        }
        if (message instanceof OffsetMessage) {
            object4 = ((OffsetMessage)message).getSender();
            object3 = ((OffsetMessage)message).getName();
            int n3 = ((OffsetMessage)message).getOffsetStart();
            n = ((OffsetMessage)message).getOffsetEnd();
            ++this.nbrSmallSenderAgent;
            object = new SmallSenderAgent((AgentAddress)object4, (String)object3, n3, n, this.dataBase, this);
            this.launchAgent((AbstractAgent)object, "smallSenderAgent" + this.nbrSmallSenderAgent, false);
            ++this.nbrSmallSenderAgent;
            this.smallSenderAgentList.add(object);
        } else if (message instanceof RequestSearchFileMessage) {
            object4 = ((RequestSearchFileMessage)message).getSender();
            object3 = ((RequestSearchFileMessage)message).getFile();
            object2 = this.dataBase.searchFile(((RequestSearchFileMessage)message).getFile());
            if (!((Vector)object2).isEmpty()) {
                System.out.println("---> File " + ((RequestSearchFileMessage)message).getFile() + " found");
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    this.sendMessage((AgentAddress)object4, new SearchFileMessage((String)object3, ((AssocPath)((Vector)object2).elementAt(n)).getVirtualPath(), ((AssocPath)((Vector)object2).elementAt(n)).getSizeFile(), ((AssocPath)((Vector)object2).elementAt(n)).isDirectory()));
                }
            }
        } else {
            super.handleMessage(message);
        }
    }

    public void initDir() {
        this.madkitDirectory = System.getProperty("madkit.dir");
        System.out.println("Madkit --> " + this.madkitDirectory);
        File file = new File(this.madkitDirectory + File.separator + this.groupName);
        file.mkdir();
        this.pluginsPath = this.madkitDirectory + File.separator + "plugins";
    }

    public void dirIndex(String string, String string2, ListFic listFic) {
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.dirIndex(string + separator + file2.getName(), string2 + separator + file2.getName(), listFic);
                    continue;
                }
                if (!file2.canRead()) continue;
                int n = (int)file2.length();
                FileInfo fileInfo = new FileInfo(string + separator + file2.getName(), n);
                listFic.getVector().addElement(fileInfo);
            }
        }
    }

    public void dirPluginIndex(String string, String string2, ListFic listFic) {
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.getName().equals("build")) continue;
                if (file2.isDirectory()) {
                    this.dirPluginIndex(string + separator + file2.getName(), string2 + separator + file2.getName(), listFic);
                    continue;
                }
                if (!file2.canRead()) continue;
                int n = (int)file2.length();
                FileInfo fileInfo = new FileInfo(string + separator + file2.getName(), n);
                listFic.getVector().addElement(fileInfo);
            }
        }
    }

    public void initPluginsDataBase(FicDataBase ficDataBase) {
        System.out.println("Server Plugins Path --> " + this.pluginsPath);
        File file = new File(this.pluginsPath);
        if (file.exists()) {
            ficDataBase.addDir(this.pluginsPath);
            File file2 = new File(this.pluginsPath);
            File[] fileArray = file2.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    String string = file3.getName();
                    File file4 = new File(this.pluginsPath + File.separator + string + File.separator + string + ".properties");
                    if (!file4.exists() || !file4.canRead()) continue;
                    try {
                        String string2;
                        RandomAccessFile randomAccessFile = new RandomAccessFile(file4, "r");
                        while ((string2 = randomAccessFile.readLine()) != null) {
                            int n = string2.indexOf("madkit.plugin.version=");
                            if (n == -1) continue;
                            PluginVersionNumber pluginVersionNumber = new PluginVersionNumber(string2.substring(n + 22, string2.length()));
                            this.listPluginInfo.add(new PluginInfo(string, pluginVersionNumber, "plugins/" + string));
                        }
                        randomAccessFile.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        System.out.println("(Server) Can't read plugin " + string + " properties ");
                    }
                }
                this.listPluginInfo.display();
            }
        }
    }
}

