/*
 * Decompiled with CFR 0.152.
 */
package jsynedit;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jsynedit.EditorPanel;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AbstractMadkitBooter;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ControlMessage;
import madkit.utils.agents.AbstractEditorAgent;

public class JSynEditAgent
extends AbstractEditorAgent {
    String targetGroup;
    String targetRole;
    Hashtable orgdump;
    String fileToEdit = null;
    EditorPanel display;
    boolean showInMessages = true;
    boolean showOutMessages = true;
    AgentAddress mykernel;

    void showInMessages(boolean bl) {
        this.showInMessages = bl;
    }

    void showOutMessages(boolean bl) {
        this.showOutMessages = bl;
    }

    public JSynEditAgent() {
    }

    public JSynEditAgent(String string) {
        this.fileToEdit = string;
    }

    public void initGUI() {
        this.display = new EditorPanel(this);
        this.setGUIObject(this.display);
        if (this.fileToEdit != null) {
            this.display.readFile(this.fileToEdit);
        }
    }

    public void enterGroupRole(String string, String string2, String string3, String string4) {
        this.display.print(":: Request role " + string3 + " in " + string2);
        int n = this.requestRole(string, string2, string3, string4);
        if (n == 1) {
            this.display.println(" with success");
        } else {
            this.display.println(" and failed");
        }
    }

    public void setTargetGroup(String string) {
        this.targetGroup = string;
        this.display.showCurrentGroup(string);
    }

    public void setTargetRole(String string) {
        this.targetRole = string;
        this.display.showCurrentRole(string);
    }

    public void setTarget(String string, String string2) {
        if (string == null) {
            return;
        }
        this.targetGroup = string;
        this.targetRole = string2;
        this.display.showCurrentGroup(string);
        this.display.showCurrentRole(string2);
    }

    public void leaveGR(String string, String string2) {
        if (string == null) {
            return;
        }
        this.leaveRole(string, string2);
    }

    public void activate() {
        this.createGroup(false, "system", null, null);
        this.requestRole("system", "editor", null);
        this.mykernel = this.getAgentWithRole("system", "kernel");
        if (this.mykernel == null) {
            System.err.println("ERROR : invalid kernel agent: " + this.mykernel);
        }
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 22));
    }

    public void handleMessage(Message message) {
        ControlMessage controlMessage;
        String string = null;
        if (message instanceof StringMessage) {
            string = ((StringMessage)message).getString();
            if (this.showInMessages) {
                this.display.println("<< receiving message from " + message.getSender() + ">> \n" + string);
            } else {
                this.display.print(string);
            }
        } else if (message instanceof KernelMessage) {
            Hashtable hashtable = null;
            KernelMessage kernelMessage = (KernelMessage)message;
            if (kernelMessage.getType() == 13) {
                this.orgdump = hashtable = (Hashtable)kernelMessage.getArgument();
            }
        } else if (message instanceof ControlMessage && "edit".equalsIgnoreCase((controlMessage = (ControlMessage)message).getAction())) {
            System.out.println(":: editing file: " + controlMessage.getContent());
            this.display.readFile(controlMessage.getContent());
        }
    }

    protected void requestJoinGroup() {
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 22));
    }

    protected Vector getAllGroups() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.orgdump.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        vector.removeElement("system");
        return vector;
    }

    protected void joinGroupInteractively(Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        this.display.joinGroup(vector);
    }

    public String[] askGetGroups() {
        return this.getExistingGroups();
    }

    public String[] askGetRoles(String string) {
        return this.getExistingRoles(string);
    }

    public String[] askGetOwnRoles(String string) {
        return this.getExistingRoles(string);
    }

    protected void clearRole() {
        if (this.targetRole != null && this.targetGroup != null) {
            this.leaveRole(this.targetGroup, this.targetRole);
        }
        this.targetRole = null;
        this.display.showCurrentRole("none");
    }

    public void live() {
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void sendString(String string) {
        if (this.showOutMessages) {
            this.display.println(">> " + string);
        }
        if (this.getRecipient() != null) {
            this.sendMessage(this.getRecipient(), (Message)new StringMessage(string));
        }
        if (this.targetGroup != null && this.targetRole != null) {
            AgentAddress[] agentAddressArray = this.getAgentsWithRole(this.targetGroup, this.targetRole);
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (agentAddressArray[i].equals((Object)this.getAddress())) continue;
                this.sendMessage(agentAddressArray[i], (Message)new StringMessage(string));
            }
        }
    }

    public void createAgentFromScript(String string) {
        Object var2_2 = null;
        try {
            if (string.endsWith(".scm")) {
                AbstractMadkitBooter.getBooter().makeScriptAgent((AbstractAgent)this, "madkit.scheme.SchemeAgent", "java.io.File", (Object)new File(string), true);
            } else if (string.endsWith(".clp")) {
                AbstractMadkitBooter.getBooter().makeScriptAgent((AbstractAgent)this, "madkit.jess.JessAgent", "java.lang.String", (Object)string, true);
            } else if (string.endsWith(".py")) {
                AbstractMadkitBooter.getBooter().makeScriptAgent((AbstractAgent)this, "madkit.python.PythonAgent", "java.lang.String", (Object)string, true);
            } else if (string.endsWith(".bsh")) {
                AbstractMadkitBooter.getBooter().makeScriptAgent((AbstractAgent)this, "madkit.bsh.BeanShellAgent", "java.lang.String", (Object)string, true);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: not a kwown Script file : " + string);
        }
    }
}

