/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.GUIUtilities;
import gnu.MenuAction;
import gnu.Plugin;
import gnu.jbrowser.JBrowse;
import gnu.jbrowser.JBrowseLineParser;
import gnu.jbrowser.JBrowseOptionPane;
import gnu.jbrowser.JBrowseParser;
import gnu.jbrowser.JEditLineSource;
import gnu.jbrowser.PropertyAccessor;
import gnu.jbrowser.UMLTree;
import gnu.options.OptionsDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Element;
import javax.swing.text.Position;
import jsynedit.AbstractEditorPanel;
import jsynedit.Utils;

public class JBrowsePlugin
implements Plugin {
    public static final String VER_NUM = "1.0.1";

    public void start() {
    }

    public void createMenuItems(AbstractEditorPanel abstractEditorPanel, Vector vector, Vector vector2) {
    }

    public void createOptionPanes(OptionsDialog optionsDialog) {
    }

    public void stop() {
    }

    public String getName() {
        return "JBrowse";
    }

    public static class TreeEventAdapter
    extends MouseAdapter
    implements TreeSelectionListener {
        UMLTree umlTree;
        JEditLineSource ls;
        AbstractEditorPanel view;

        TreeEventAdapter(UMLTree uMLTree, JEditLineSource jEditLineSource, AbstractEditorPanel abstractEditorPanel) {
            this.umlTree = uMLTree;
            this.ls = jEditLineSource;
            this.view = abstractEditorPanel;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.umlTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == this.umlTree.getMaxSelectionRow() && mouseEvent.getClickCount() == 1) {
                if (!this.verifyBuffer()) {
                    return;
                }
                UMLTree.Node node = (UMLTree.Node)this.umlTree.getLastSelectedPathComponent();
                this.setPosition(node);
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.umlTree.isSelectionEmpty()) {
                return;
            }
            if (!this.verifyBuffer()) {
                return;
            }
            UMLTree.Node node = (UMLTree.Node)this.umlTree.getSelectionPath().getLastPathComponent();
            this.setPosition(node);
        }

        private void setPosition(UMLTree.Node node) {
            Position position = (Position)node.getPosition();
            if (position == null) {
                return;
            }
            Element element = this.ls.getTextArea().getDocument().getDefaultRootElement();
            Element element2 = element.getElement(element.getElementIndex(position.getOffset()));
            if (element2 == null) {
                return;
            }
            this.view.getTextArea().select(element2.getStartOffset(), element2.getEndOffset() - 1);
        }

        private boolean verifyBuffer() {
            if (this.view.getTextArea().getDocument() != this.ls.getTextArea().getDocument()) {
                File file = this.ls.getTextArea().getFile();
                File file2 = this.view.getTextArea().getFile();
                String string = file != null ? file.getPath() : this.ls.getTextArea().getName();
                String string2 = file2 != null ? file2.getPath() : this.view.getTextArea().getName();
                GUIUtilities.error(Utils.getRealFrameParent(this.view), "jbrowse.msg.wrongBuffer", new Object[]{string, string2});
                return false;
            }
            return true;
        }
    }

    public static class PropAccessor
    implements PropertyAccessor {
        public String getProperty(String string) {
            return AbstractEditorPanel.getProperty(string);
        }

        public String getProperty(String string, String string2) {
            return AbstractEditorPanel.getProperty(string, string2);
        }

        public String getProperty(String string, Object[] objectArray) {
            return AbstractEditorPanel.getProperty(string, objectArray);
        }

        public Object setProperty(String string, String string2) {
            AbstractEditorPanel.setProperty(string, string2);
            return null;
        }
    }

    public static class OptPane
    extends JBrowseOptionPane {
        public Component getComponent() {
            JScrollPane jScrollPane = new JScrollPane(this);
            Dimension dimension = this.getPreferredSize();
            jScrollPane.setPreferredSize(new Dimension(dimension.width, 250));
            return jScrollPane;
        }
    }

    public static class OpenAction
    extends MenuAction
    implements JBrowse.Activator {
        static JBrowse b;
        AbstractEditorPanel view;
        JBrowseParser parser;
        UMLTree umlTree;
        PropertyAccessor props;
        Cursor savedCursor;

        public OpenAction() {
            super("jbrowse.open");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.props = new PropAccessor();
                this.view = OpenAction.getJextParent(actionEvent);
                this.savedCursor = this.view.getCursor();
                this.view.setCursor(new Cursor(3));
                JEditLineSource jEditLineSource = new JEditLineSource(this.view);
                this.parser = new JBrowseLineParser(jEditLineSource);
                this.umlTree = new UMLTree();
                TreeEventAdapter treeEventAdapter = new TreeEventAdapter(this.umlTree, jEditLineSource, this.view);
                this.umlTree.addTreeSelectionListener(treeEventAdapter);
                this.umlTree.addMouseListener(treeEventAdapter);
                if (b == null || this.view.getVerticalTabbedPane().indexOfComponent(b) == -1) {
                    b = new JBrowse(this);
                    b.actionPerformed(actionEvent);
                    this.view.getVerticalTabbedPane().add("JBrowse", b);
                } else {
                    b.actionPerformed(actionEvent);
                }
                this.view.getVerticalTabbedPane().setSelectedComponent(b);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.out.println(exception.toString());
            }
            finally {
                if (this.savedCursor != null) {
                    this.view.setCursor(this.savedCursor);
                } else {
                    this.view.setCursor(new Cursor(0));
                }
            }
        }

        public AbstractEditorPanel getOwner() {
            return this.view;
        }

        public PropertyAccessor getPropertyAccessor() {
            return this.props;
        }

        public JBrowseParser getJBrowseParser() {
            return this.parser;
        }

        public UMLTree getUMLTree() {
            return this.umlTree;
        }
    }
}

