/*
 * Decompiled with CFR 0.152.
 */
package gnu;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jsynedit.AbstractEditorPanel;

public class UUtilities {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    public static final int SCRIPT = 2;
    public static final String JDK_VERSION = System.getProperty("java.version");

    public static void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "utils.message", 1);
    }

    public static void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "utils.error", 0);
    }

    public static void showMessage(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 1);
    }

    public static Dimension getScreenDimension() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void centerComponent(Component component) {
        component.setLocation(new Point((UUtilities.getScreenDimension().width - component.getSize().width) / 2, (UUtilities.getScreenDimension().height - component.getSize().height) / 2));
    }

    public static void centerComponentChild(Component component, Component component2) {
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = component2.getBounds();
        component2.setLocation(new Point(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2));
    }

    public static String classToFile(String string) {
        return string.replace('.', '/').concat(".class");
    }

    public static String fileToClass(String string) {
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 6; i >= 0; --i) {
            if (cArray[i] != '/') continue;
            cArray[i] = 46;
        }
        return new String(cArray, 0, cArray.length - 6);
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void setCursorOnWait(Component component, boolean bl) {
        if (bl) {
            if (component instanceof AbstractEditorPanel) {
                ((AbstractEditorPanel)component).showWaitCursor();
            } else {
                component.setCursor(Cursor.getPredefinedCursor(3));
            }
        } else if (component instanceof AbstractEditorPanel) {
            ((AbstractEditorPanel)component).hideWaitCursor();
        } else {
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static String chooseFile(Component component, int n) {
        JFileChooser jFileChooser = UUtilities.getFileChooser(component, n);
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showDialog(component, null) == 0) {
            AbstractEditorPanel.setProperty("lastdir." + n, jFileChooser.getSelectedFile().getParent());
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        component.repaint();
        return null;
    }

    private static JFileChooser getFileChooser(Component component, int n) {
        JFileChooser jFileChooser = null;
        String string = AbstractEditorPanel.getProperty("lastdir." + n);
        if (string == null) {
            string = AbstractEditorPanel.getHomeDirectory();
        }
        if (component instanceof AbstractEditorPanel) {
            jFileChooser = ((AbstractEditorPanel)component).getFileChooser(n);
            if (AbstractEditorPanel.getBooleanProperty("editor.dirDefaultDialog") && n != 2) {
                String string2 = ((AbstractEditorPanel)component).getCurrentFile();
                if (string2 != null) {
                    jFileChooser.setCurrentDirectory(new File(string2));
                }
            } else {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        } else {
            jFileChooser = new JFileChooser(string);
            if (n == 1) {
                jFileChooser.setDialogType(1);
            } else {
                jFileChooser.setDialogType(0);
            }
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileHidingEnabled(true);
        return jFileChooser;
    }

    public static String createWhiteSpace(int n) {
        return UUtilities.createWhiteSpace(n, 0);
    }

    public static String createWhiteSpace(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            while (n-- > 0) {
                stringBuffer.append(' ');
            }
        } else {
            int n3 = n / n2;
            while (n3-- > 0) {
                stringBuffer.append('\t');
            }
            n3 = n % n2;
            while (n3-- > 0) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public static int getLeadingWhiteSpace(String string) {
        int n;
        block3: for (n = 0; n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return n;
    }

    public static int getLeadingWhiteSpaceWidth(String string, int n) {
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    ++n2;
                    continue block4;
                }
                case '\t': {
                    n2 += n - n2 % n;
                    continue block4;
                }
            }
        }
        return n2;
    }

    public static int getRealLength(String string, int n) {
        int n2 = 0;
        block3: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\t': {
                    n2 += n;
                    continue block3;
                }
                default: {
                    ++n2;
                }
            }
        }
        return n2;
    }

    public static String getShortStringOf(String string, int n) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 <= n) {
            return string;
        }
        if (string.indexOf(92) == -1 && string.indexOf(47) == -1) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - n));
            for (int i = 0; i < 3; ++i) {
                stringBuffer.setCharAt(i, '.');
            }
            return stringBuffer.toString();
        }
        int n5 = n3 = n4 / 2;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if (string.charAt(n2) != '\\' && string.charAt(n2) != '/') continue;
            n3 = n2;
            break;
        }
        for (n2 = n5 + 1; n2 < n4; ++n2) {
            if (string.charAt(n2) != '\\' && string.charAt(n2) != '/') continue;
            n5 = n2;
            break;
        }
        block9: while (n4 - (n5 - n3) > n) {
            block10: for (n2 = n3 - 1; n2 >= 0; --n2) {
                switch (string.charAt(n2)) {
                    case '/': 
                    case '\\': {
                        n3 = n2;
                        break block10;
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            if (n4 - (n5 - n3) < n) break;
            for (n2 = n5 + 1; n2 < n4; ++n2) {
                switch (string.charAt(n2)) {
                    case '/': 
                    case '\\': {
                        n5 = n2;
                        continue block9;
                    }
                }
            }
        }
        return string.substring(0, n3 + 1) + "..." + string.substring(n5);
    }

    public static String constructPath(String string) {
        int n;
        if (UUtilities.beginsWithRoot(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(UUtilities.getUserDirectory());
        int n2 = 0;
        boolean bl = false;
        string = string.trim();
        StringBuffer stringBuffer2 = new StringBuffer(string.length());
        block5: for (n = 0; n < string.length(); ++n) {
            int n3 = string.charAt(n);
            switch (n3) {
                case 46: {
                    if (n2 == 46) {
                        String string2 = new File(stringBuffer.toString()).getParent();
                        if (string2 != null) {
                            stringBuffer = new StringBuffer(string2);
                        }
                    } else if (n2 != 0 && n2 != 92 && n2 != 47 || n < string.length() - 1 && string.charAt(n + 1) != '.') {
                        stringBuffer2.append('.');
                    }
                    n2 = 46;
                    continue block5;
                }
                case 47: 
                case 92: {
                    if (n2 == 0) {
                        stringBuffer = new StringBuffer(UUtilities.getRoot(stringBuffer.toString()));
                    } else {
                        char c = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c != '\\' && c != '/') {
                            stringBuffer.append(File.separator).append(stringBuffer2.toString());
                        } else {
                            stringBuffer.append(stringBuffer2.toString());
                        }
                        stringBuffer2 = new StringBuffer();
                        bl = false;
                    }
                    n2 = 92;
                    continue block5;
                }
                case 126: {
                    if (n < string.length() - 1) {
                        if (string.charAt(n + 1) == '\\' || string.charAt(n + 1) == '/') {
                            stringBuffer = new StringBuffer(UUtilities.getHomeDirectory());
                        } else {
                            stringBuffer2.append('~');
                        }
                    } else if (n == 0) {
                        stringBuffer = new StringBuffer(UUtilities.getHomeDirectory());
                    } else {
                        stringBuffer2.append('~');
                    }
                    n2 = 126;
                    continue block5;
                }
                default: {
                    n2 = n3;
                    stringBuffer2.append((char)n3);
                    bl = true;
                }
            }
        }
        if (bl) {
            n = stringBuffer.charAt(stringBuffer.length() - 1);
            if (n != 92 && n != 47) {
                stringBuffer.append(File.separator).append(stringBuffer2.toString());
            } else {
                stringBuffer.append(stringBuffer2.toString());
            }
        }
        return stringBuffer.toString();
    }

    public static boolean beginsWithRoot(String string) {
        if (string.length() == 0) {
            return false;
        }
        File file = new File(string);
        File[] fileArray = file.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!string.regionMatches(true, 0, fileArray[i].getPath(), 0, fileArray[i].getPath().length())) continue;
            return true;
        }
        return false;
    }

    public static String getUserDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getHomeDirectory() {
        return System.getProperty("user.home");
    }

    public static String getRoot(String string) {
        File file = new File(string);
        File[] fileArray = file.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!string.startsWith(fileArray[i].getPath())) continue;
            return fileArray[i].getPath();
        }
        return string;
    }

    public static String[] getWildCardMatches(String string, boolean bl) {
        return UUtilities.getWildCardMatches(null, string, bl);
    }

    public static String[] getWildCardMatches(String string, String string2, boolean bl) {
        String[] stringArray;
        if (string2 == null) {
            return null;
        }
        String string3 = new String(string2.trim());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            string = UUtilities.getUserDirectory();
        }
        if ((stringArray = new File(string).list()) == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!UUtilities.match(string3, stringArray[i])) continue;
            File file = new File(UUtilities.getUserDirectory(), stringArray[i]);
            arrayList.add(new String(file.getName()));
        }
        Object[] objectArray = arrayList.toArray();
        Object[] objectArray2 = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i].toString();
        }
        objectArray = null;
        arrayList = null;
        if (bl) {
            Arrays.sort(objectArray2);
        }
        return objectArray2;
    }

    public static boolean match(String string, String string2) {
        int n = 0;
        while (true) {
            int n2 = 0;
            while (true) {
                boolean bl;
                boolean bl2 = n2 >= string2.length();
                boolean bl3 = bl = n >= string.length() || string.charAt(n) == '|';
                if (bl2 && bl) {
                    return true;
                }
                if (bl2 || bl) break;
                if (string.charAt(n) != '?') {
                    if (string.charAt(n) == '*') {
                        ++n;
                        for (int i = string2.length(); i >= n2; --i) {
                            if (!UUtilities.match(string.substring(n), string2.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (string.charAt(n) != string2.charAt(n2)) break;
                }
                ++n;
                ++n2;
            }
            if ((n = string.indexOf(124, n)) == -1) {
                return false;
            }
            ++n;
        }
    }

    public static void sortStrings(String[] stringArray) {
        Arrays.sort(stringArray);
    }

    public static File[] listFiles(String[] stringArray, boolean bl) {
        return UUtilities.listFiles(stringArray, UUtilities.getUserDirectory(), bl);
    }

    public static File[] listFiles(String[] stringArray, String string, boolean bl) {
        File[] fileArray = new File[stringArray.length];
        if (bl && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = bl ? new File(string + stringArray[i]) : new File(stringArray[i]);
        }
        return fileArray;
    }

    public static String globToRE(String string) {
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block9: for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (bl) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            switch (c) {
                case '*': {
                    stringBuffer.append('.').append('*');
                    continue block9;
                }
                case '?': {
                    stringBuffer.append('.');
                    continue block9;
                }
                case '\\': {
                    bl = true;
                    continue block9;
                }
                case '.': {
                    stringBuffer.append('\\').append('.');
                    continue block9;
                }
                case '{': {
                    stringBuffer.append('(');
                    bl2 = true;
                    continue block9;
                }
                case '}': {
                    stringBuffer.append(')');
                    bl2 = false;
                    continue block9;
                }
                case ',': {
                    if (bl2) {
                        stringBuffer.append('|');
                        continue block9;
                    }
                    stringBuffer.append(',');
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

