/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DelegatingRunnable
implements Runnable {
    private Object target;
    private String methodName;
    private Object[] args;

    public DelegatingRunnable(Object target, String methodName) {
        this(target, methodName, null);
    }

    public DelegatingRunnable(Object target, String methodName, Object[] args) {
        this.target = target;
        this.methodName = methodName;
        this.args = args;
    }

    public void run() {
        Method method = this.getMethod();
        if (method != null) {
            try {
                method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException iae) {
                System.out.println("IAE: " + iae);
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                System.out.println("ITE: " + ite);
                ite.printStackTrace();
                Throwable te = ite.getTargetException();
                System.out.println("target: " + ite);
                te.printStackTrace();
            }
        }
    }

    private Method getMethod() {
        try {
            Class[] types = null;
            if (this.args != null) {
                types = new Class[this.args.length];
                for (int counter = 0; counter < this.args.length; ++counter) {
                    types[counter] = this.args[counter].getClass();
                }
            }
            return this.target.getClass().getMethod(this.methodName, types);
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("NSME: " + nsme);
            return null;
        }
    }
}

