/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.ui;

import com.sun.jaf.ui.ActionList;
import com.sun.jaf.ui.ActionManager;
import com.sun.jaf.ui.StateChangeAction;
import com.sun.jaf.ui.ToggleActionPropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class UIFactory {
    private static UIFactory INSTANCE;
    private static ActionManager MANAGER;
    private HashMap groupMap;
    private static boolean DEBUG;

    private UIFactory() {
    }

    public static UIFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UIFactory();
        }
        return INSTANCE;
    }

    public static void setInstance(UIFactory factory) {
        INSTANCE = factory;
    }

    public static ActionManager getActionManager() {
        if (MANAGER == null) {
            MANAGER = ActionManager.getInstance();
        }
        return MANAGER;
    }

    public static void setActionManager(ActionManager manager) {
        MANAGER = manager;
    }

    public JToolBar createToolBar(Object id) {
        ActionList list = UIFactory.getActionManager().getActionList(id);
        if (list == null) {
            return null;
        }
        JToolBar toolbar = new JToolBar();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == null) {
                toolbar.addSeparator();
                continue;
            }
            if (!(element instanceof String)) continue;
            toolbar.add(this.createButton((String)element, list.getGroup((String)element), toolbar));
        }
        return toolbar;
    }

    public JPopupMenu createPopup(Object id) {
        ActionList list = UIFactory.getActionManager().getActionList(id);
        if (list == null) {
            return null;
        }
        JPopupMenu popup = new JPopupMenu();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == null) {
                popup.addSeparator();
                continue;
            }
            if (!(element instanceof String)) continue;
            popup.add(this.createMenuItem((String)element, list.getGroup((String)element), popup));
        }
        return popup;
    }

    public JMenuBar createMenuBar(Object id) {
        ActionList list = UIFactory.getActionManager().getActionList((String)id);
        if (list == null) {
            return null;
        }
        JMenuBar menubar = new JMenuBar();
        JMenu menu = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element == null) {
                if (menu == null) continue;
                menu.addSeparator();
                continue;
            }
            if (element instanceof String) {
                if (menu == null) continue;
                menu.add(this.createMenuItem((String)element, list.getGroup((String)element), menu));
                continue;
            }
            if (!(element instanceof ActionList) || (menu = this.createMenu((ActionList)element)) == null) continue;
            menubar.add(menu);
        }
        return menubar;
    }

    public JMenu createMenu(Object id) {
        ActionList list = UIFactory.getActionManager().getActionList((String)id);
        if (list == null) {
            return null;
        }
        return this.createMenu(list);
    }

    private JMenu createMenu(ActionList list) {
        Action action = this.getAction(list.getActionRef());
        if (action == null) {
            return null;
        }
        JMenu menu = new JMenu(action);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            JMenu newMenu;
            Object element = iter.next();
            if (element == null) {
                menu.addSeparator();
                continue;
            }
            if (element instanceof String) {
                menu.add(this.createMenuItem((String)element, list.getGroup((String)element), menu));
                continue;
            }
            if (!(element instanceof ActionList) || (newMenu = this.createMenu((ActionList)element)) == null) continue;
            menu.add(newMenu);
        }
        return menu;
    }

    private Action getAction(String id) {
        Action action = UIFactory.getActionManager().getAction(id);
        if (action == null) {
            throw new RuntimeException("ERROR: No Action for " + id);
        }
        return action;
    }

    private ButtonGroup getGroup(String groupid, JComponent container) {
        Integer hashCode;
        ButtonGroup group;
        if (this.groupMap == null) {
            this.groupMap = new HashMap();
        }
        if ((group = (ButtonGroup)this.groupMap.get(hashCode = new Integer(groupid.hashCode() ^ container.hashCode()))) == null) {
            group = new ButtonGroup();
            this.groupMap.put(hashCode, group);
        }
        return group;
    }

    private JMenuItem createMenuItem(String id, String groupid, JComponent container) {
        Action action = this.getAction(id);
        JMenuItem menuItem = action instanceof StateChangeAction ? (groupid != null ? UIFactory.createRadioButtonMenuItem(this.getGroup(groupid, container), (StateChangeAction)action) : UIFactory.createCheckBoxMenuItem((StateChangeAction)action)) : UIFactory.createMenuItem(action);
        return menuItem;
    }

    private AbstractButton createButton(String id, String groupid, JComponent container) {
        Action action = this.getAction(id);
        if (action == null) {
            System.out.println("ERROR: Action doesn't exist for " + id);
            return null;
        }
        AbstractButton button = action instanceof StateChangeAction ? (groupid == null ? this.createToggleButton((StateChangeAction)action) : this.createToggleButton((StateChangeAction)action, this.getGroup(groupid, container))) : this.createButton(action);
        return button;
    }

    private JButton createButton(Action action) {
        JButton button = new JButton(action);
        this.configureButton(button, action);
        return button;
    }

    private JToggleButton createToggleButton(StateChangeAction a) {
        return this.createToggleButton(a, null);
    }

    private JToggleButton createToggleButton(StateChangeAction a, ButtonGroup group) {
        JToggleButton button = new JToggleButton(a);
        button.addItemListener(a);
        button.setSelected(a.isSelected());
        if (group != null) {
            group.add(button);
        }
        this.configureToggleButton(button, a);
        return button;
    }

    protected void configureToggleButton(JToggleButton button, Action action) {
        this.configureButton(button, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(button));
    }

    protected void configureButton(AbstractButton button, Action action) {
        if (action.getValue("ShortDescription") == null) {
            button.setToolTipText((String)action.getValue("Name"));
        }
        if (action.getValue("LargeIcon") != null) {
            button.setIcon((Icon)action.getValue("LargeIcon"));
        }
        button.setText("");
    }

    protected static void configureToggleMenuItem(JMenuItem menuItem, Action action) {
        UIFactory.configureMenuItem(menuItem, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(menuItem));
    }

    protected static void configureMenuItem(JMenuItem menuItem, Action action) {
    }

    private static JMenuItem createMenuItem(Action action) {
        JMenuItem mi = new JMenuItem(action);
        UIFactory.configureMenuItem(mi, action);
        return mi;
    }

    private static JCheckBoxMenuItem createCheckBoxMenuItem(StateChangeAction a) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(a.isSelected());
        UIFactory.configureToggleMenuItem(mi, a);
        return mi;
    }

    private static JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup group, StateChangeAction a) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(a.isSelected());
        if (group != null) {
            group.add(mi);
        }
        UIFactory.configureToggleMenuItem(mi, a);
        return mi;
    }

    static {
        DEBUG = false;
    }
}

