/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.ui;

import com.sun.jaf.ui.ActionList;
import com.sun.jaf.ui.DelegateAction;
import com.sun.jaf.ui.StateChangeAction;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.EventHandler;
import java.beans.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ActionManager {
    private static final String ACTION_SET_ELEMENT = "action-set";
    private static final String ACTION_ELEMENT = "action";
    private static final String ACTION_LIST_ELEMENT = "action-list";
    private static final String EMPTY_ELEMENT = "empty";
    private static final String GROUP_ELEMENT = "group";
    private static final String ACCEL_ATTRIBUTE = "accel";
    private static final String DESC_ATTRIBUTE = "desc";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String ACTIONREF_ATTRIBUTE = "actionref";
    private static final String IDREF_ATTRIBUTE = "idref";
    private static final String MNEMONIC_ATTRIBUTE = "mnemonic";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SMICON_ATTRIBUTE = "smicon";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final int ACCEL_INDEX = 0;
    private static final int DESC_INDEX = 1;
    private static final int ICON_INDEX = 2;
    private static final int ID_INDEX = 3;
    private static final int MNEMONIC_INDEX = 4;
    private static final int NAME_INDEX = 5;
    private static final int SMICON_INDEX = 6;
    private static final int TYPE_INDEX = 7;
    private static SAXParserFactory parserfactory;
    private ActionHandler handler;
    private Map attributeMap;
    private Map actionMap;
    private Map actionSetMap;
    private Map actionListMap;
    private static ActionManager INSTANCE;
    private static boolean DEBUG;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public static ActionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionManager();
        }
        return INSTANCE;
    }

    public static void setInstance(ActionManager manager) {
        INSTANCE = manager;
    }

    private void addAttributes(Attributes attrs, String actionset) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        this.attributeMap.put(attrs.getValue(ID_ATTRIBUTE), new ActionAttributes(attrs));
        if (actionset != null && !actionset.equals("")) {
            ArrayList<String> list = this.getActionSet(actionset);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(attrs.getValue(ID_ATTRIBUTE));
            this.addActionSet(actionset, list);
        }
    }

    private ActionAttributes getAttributes(Object key) {
        if (this.attributeMap == null) {
            return null;
        }
        return (ActionAttributes)this.attributeMap.get(key);
    }

    public void unloadActions(Object actionset) {
        List list;
        if (DEBUG) {
            System.out.println("unloadActions(" + actionset + ")");
        }
        if ((list = this.getActionSet(actionset)) == null) {
            return;
        }
        String key = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            if (this.attributeMap != null) {
                this.attributeMap.remove(key);
            }
            if (this.actionMap == null) continue;
            this.actionMap.remove(key);
        }
        if (this.actionSetMap != null) {
            this.actionSetMap.remove(actionset);
        }
    }

    public Set getActionIDs() {
        if (this.attributeMap == null) {
            return null;
        }
        return this.attributeMap.keySet();
    }

    public Set getActionSetIDs() {
        if (this.actionSetMap == null) {
            this.actionSetMap = new HashMap();
        }
        return this.actionSetMap.keySet();
    }

    private List getActionSet(Object id) {
        if (this.actionSetMap == null) {
            this.actionSetMap = new HashMap();
        }
        return (List)this.actionSetMap.get(id);
    }

    private void addActionSet(String key, List set) {
        if (this.actionSetMap == null) {
            this.actionSetMap = new HashMap();
        }
        this.actionSetMap.put(key, set);
    }

    public Set getActionListIDs() {
        if (this.actionListMap == null) {
            this.actionListMap = new HashMap();
        }
        return this.actionListMap.keySet();
    }

    ActionList getActionList(Object id) {
        if (this.actionListMap == null) {
            return null;
        }
        return (ActionList)this.actionListMap.get(id);
    }

    private void addActionList(String id, ActionList list) {
        if (this.actionListMap == null) {
            this.actionListMap = new HashMap();
        }
        this.actionListMap.put(id, list);
    }

    private void addAction(String id, Action action) {
        if (this.actionMap == null) {
            this.actionMap = new HashMap();
        }
        this.actionMap.put(id, action);
    }

    public Action getAction(Object id) {
        Action action;
        if (this.actionMap == null) {
            this.actionMap = new HashMap();
        }
        if ((action = (Action)this.actionMap.get(id)) == null) {
            action = this.createAction(this.getAttributes(id));
        }
        return action;
    }

    private DelegateAction getDelegateAction(Object id) {
        Action a = this.getAction(id);
        if (a instanceof DelegateAction) {
            return (DelegateAction)a;
        }
        return null;
    }

    private StateChangeAction getStateChangeAction(Object id) {
        Action a = this.getAction(id);
        if (a instanceof StateChangeAction) {
            return (StateChangeAction)a;
        }
        return null;
    }

    public void setEnabled(Object id, boolean enabled) {
        Action action = this.getAction(id);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public boolean isEnabled(Object id) {
        Action action = this.getAction(id);
        if (action != null) {
            return action.isEnabled();
        }
        return false;
    }

    public void setSelected(Object id, boolean selected) {
        StateChangeAction action = this.getStateChangeAction(id);
        if (action != null) {
            action.setSelected(selected);
        }
    }

    public boolean isSelected(Object id) {
        StateChangeAction action = this.getStateChangeAction(id);
        if (action != null) {
            return action.isSelected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadActions(URL url) throws IOException {
        if (DEBUG) {
            System.out.println("loadActions(" + url + ")");
        }
        InputStream stream = url.openStream();
        try {
            this.loadActions(stream);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void loadActions(InputStream stream) throws IOException {
        if (DEBUG) {
            System.out.println("loadActions(" + stream + ")");
        }
        if (parserfactory == null) {
            parserfactory = SAXParserFactory.newInstance();
            parserfactory.setValidating(true);
        }
        if (this.handler == null) {
            this.handler = new ActionHandler();
        }
        try {
            SAXParser parser = parserfactory.newSAXParser();
            parser.parse(stream, this.handler, this.getClass().getResource("resources").toString() + "/");
        }
        catch (SAXException ex) {
            this.printException("SAXException: " + ex.getMessage(), ex);
            throw new IOException("Error parsing: " + ex.getMessage());
        }
        catch (IOException ex2) {
            this.printException("IOException: " + ex2.getMessage(), ex2);
            throw ex2;
        }
        catch (ParserConfigurationException ex3) {
            this.printException("ParserConfigurationException: " + ex3.getMessage(), ex3);
            throw new IOException("Error parsing: " + ex3.getMessage());
        }
    }

    private void printException(String message, Exception ex) {
        System.out.println(message);
        if (DEBUG) {
            ex.printStackTrace();
        }
    }

    Icon getIcon(String imagePath) {
        URL url;
        if (imagePath != null && !imagePath.equals("") && (url = this.getClass().getResource(imagePath)) != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    static void printAction(PrintStream stream, Action action) {
        stream.println("Attributes for " + action.getValue("ActionCommandKey"));
        if (action instanceof AbstractAction) {
            Object[] keys = ((AbstractAction)action).getKeys();
            for (int i = 0; i < keys.length; ++i) {
                stream.println("\tkey: " + keys[i] + "\tvalue: " + action.getValue((String)keys[i]));
            }
        }
    }

    static void printActionManager(PrintStream stream, ActionManager manager) {
        Set keys = manager.getActionSetIDs();
        int numItems = keys.size();
        stream.println("Num action-sets: " + numItems);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            stream.println("\t" + (String)iter.next());
        }
        keys = manager.getActionListIDs();
        if (keys != null) {
            numItems = keys.size();
            stream.println("\nNum action-lists: " + numItems);
            iter = keys.iterator();
            while (iter.hasNext()) {
                stream.println("\t" + (String)iter.next());
            }
        }
        if ((keys = manager.getActionIDs()) != null) {
            numItems = keys.size();
            stream.println("\nNum actions: " + numItems);
            iter = keys.iterator();
            while (iter.hasNext()) {
                ActionManager.printAction(stream, manager.getAction((String)iter.next()));
            }
        }
    }

    private Action createAction(ActionAttributes attr) {
        DelegateAction action = null;
        if (attr != null) {
            String type = attr.getValue(7);
            action = "toggle".equals(type) ? new StateChangeAction() : new DelegateAction();
            this.configureAction(action, attr);
            this.addAction(attr.getValue(3), action);
        }
        return action;
    }

    private void configureAction(Action action, ActionAttributes attr) {
        String accel;
        action.putValue("Name", attr.getValue(5));
        action.putValue("SmallIcon", this.getIcon(attr.getValue(6)));
        action.putValue("LargeIcon", this.getIcon(attr.getValue(2)));
        action.putValue("ActionCommandKey", attr.getValue(3));
        action.putValue("ShortDescription", attr.getValue(1));
        action.putValue("LongDescription", attr.getValue(1));
        String mnemonic = attr.getValue(4);
        if (mnemonic != null && !mnemonic.equals("")) {
            action.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
        }
        if ((accel = attr.getValue(0)) != null && !accel.equals("")) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel));
        }
    }

    public void registerCallback(Object id, Object handler, String method) {
        StateChangeAction sa = this.getStateChangeAction(id);
        if (sa != null) {
            sa.addItemListener(new BooleanInvocationHandler(handler, method));
            return;
        }
        DelegateAction a = this.getDelegateAction(id);
        if (a != null) {
            a.addActionListener((ActionListener)EventHandler.create(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionManager.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, handler, method));
        }
    }

    public boolean isStateChangeAction(Object id) {
        return this.getStateChangeAction(id) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEBUG = false;
    }

    class ActionHandler
    extends DefaultHandler {
        private String element;
        private Stack actionListStack;
        private Stack actionSetStack;
        private String actionset;
        private ActionList actionlist;
        private String action;
        private String group;

        ActionHandler() {
        }

        public void startDocument() {
            this.element = "";
            this.actionListStack = new Stack();
            this.actionSetStack = new Stack();
            this.actionset = null;
            this.actionlist = null;
            this.action = null;
            this.group = null;
        }

        public void startElement(String nameSpace, String localName, String name, Attributes attributes) {
            if (DEBUG) {
                System.out.println("startElement(" + nameSpace + "," + localName + "," + name + ",...)");
            }
            this.element = name;
            if (ActionManager.ACTION_SET_ELEMENT.equals(name)) {
                String newSet = attributes.getValue(ActionManager.ID_ATTRIBUTE);
                if (this.actionset != null) {
                    this.actionSetStack.push(this.actionset);
                }
                this.actionset = newSet;
            } else if (ActionManager.ACTION_LIST_ELEMENT.equals(name)) {
                ActionAttributes actionAtts;
                String id = attributes.getValue(ActionManager.ID_ATTRIBUTE);
                this.action = attributes.getValue(ActionManager.IDREF_ATTRIBUTE);
                if (this.action == null) {
                    this.action = id;
                }
                if ((actionAtts = ActionManager.this.getAttributes(this.action)) == null) {
                    ActionManager.this.addAttributes(attributes, this.actionset);
                } else {
                    actionAtts.setAttributes(attributes);
                }
                ActionList newList = new ActionList(id, this.action);
                if (this.actionlist != null) {
                    this.actionlist.add(newList);
                    this.actionListStack.push(this.actionlist);
                }
                ActionManager.this.addActionList(id, newList);
                this.actionlist = newList;
            } else if (ActionManager.ACTION_ELEMENT.equals(name)) {
                ActionAttributes actionAtts;
                this.action = attributes.getValue(ActionManager.IDREF_ATTRIBUTE);
                if (this.action == null) {
                    this.action = attributes.getValue(ActionManager.ID_ATTRIBUTE);
                }
                if ((actionAtts = ActionManager.this.getAttributes(this.action)) == null) {
                    ActionManager.this.addAttributes(attributes, this.actionset);
                } else {
                    actionAtts.setAttributes(attributes);
                }
                if (this.actionlist != null) {
                    this.actionlist.add(this.action);
                    if (this.group != null) {
                        this.actionlist.setGroup(this.action, this.group);
                    }
                }
            } else if (ActionManager.GROUP_ELEMENT.equals(name)) {
                this.group = attributes.getValue(ActionManager.ID_ATTRIBUTE);
            } else if (ActionManager.EMPTY_ELEMENT.equals(name) && this.actionlist != null) {
                this.actionlist.add(null);
            }
        }

        public void endElement(String nameSpace, String localName, String name) {
            if (DEBUG) {
                System.out.println("endElement(" + nameSpace + "," + localName + "," + name + ")");
            }
            if (ActionManager.ACTION_SET_ELEMENT.equals(name)) {
                try {
                    this.actionset = (String)this.actionSetStack.pop();
                }
                catch (EmptyStackException ex) {
                    this.actionset = null;
                }
            } else if (ActionManager.ACTION_LIST_ELEMENT.equals(name)) {
                try {
                    this.actionlist = (ActionList)this.actionListStack.pop();
                }
                catch (EmptyStackException ex) {
                    this.actionlist = null;
                }
            } else if (ActionManager.GROUP_ELEMENT.equals(name)) {
                this.group = null;
            }
        }

        public void endDocument() {
            this.element = "";
            this.actionListStack = new Stack();
            this.actionSetStack = new Stack();
            this.actionset = null;
            this.actionlist = null;
            this.action = null;
            this.group = null;
        }

        public void error(SAXParseException ex) throws SAXException {
            System.out.println("**** validation error");
            this.reportException(ex);
        }

        public void warning(SAXParseException ex) throws SAXException {
            System.out.println("**** validation warning");
            this.reportException(ex);
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            System.out.println("**** validation fatalError");
            this.reportException(ex);
        }

        private void reportException(SAXParseException ex) {
            System.out.println(ex.getLineNumber() + ":" + ex.getColumnNumber() + " " + ex.getMessage());
            System.out.println("Public ID: " + ex.getPublicId() + "\t" + "System ID: " + ex.getSystemId());
            if (DEBUG) {
                ex.printStackTrace();
            }
        }
    }

    private class BooleanInvocationHandler
    implements ItemListener {
        private Object target;
        private String methodName;

        public BooleanInvocationHandler(Object target, String methodName) {
            this.target = target;
            this.methodName = methodName;
        }

        public void itemStateChanged(ItemEvent evt) {
            Boolean value = Boolean.TRUE;
            if (evt.getStateChange() == 2) {
                value = Boolean.FALSE;
            }
            Statement statement = new Statement(this.target, this.methodName, new Object[]{value});
            try {
                statement.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class ActionAttributes {
        private String[] array = new String[8];

        public ActionAttributes(Attributes attrs) {
            this.array[0] = attrs.getValue(ActionManager.ACCEL_ATTRIBUTE);
            this.array[1] = attrs.getValue(ActionManager.DESC_ATTRIBUTE);
            this.array[2] = attrs.getValue(ActionManager.ICON_ATTRIBUTE);
            this.array[3] = attrs.getValue(ActionManager.ID_ATTRIBUTE);
            this.array[4] = attrs.getValue(ActionManager.MNEMONIC_ATTRIBUTE);
            this.array[5] = attrs.getValue(ActionManager.NAME_ATTRIBUTE);
            this.array[6] = attrs.getValue(ActionManager.SMICON_ATTRIBUTE);
            this.array[7] = attrs.getValue(ActionManager.TYPE_ATTRIBUTE);
        }

        public String getValue(int index) {
            return this.array[index];
        }

        public void setValue(int index, String value) {
            if (index < this.array.length && value != null) {
                this.array[index] = value;
            }
        }

        public void setAttributes(Attributes attrs) {
            this.setValue(0, attrs.getValue(ActionManager.ACCEL_ATTRIBUTE));
            this.setValue(1, attrs.getValue(ActionManager.DESC_ATTRIBUTE));
            this.setValue(2, attrs.getValue(ActionManager.ICON_ATTRIBUTE));
            this.setValue(4, attrs.getValue(ActionManager.MNEMONIC_ATTRIBUTE));
            this.setValue(5, attrs.getValue(ActionManager.NAME_ATTRIBUTE));
            this.setValue(6, attrs.getValue(ActionManager.SMICON_ATTRIBUTE));
            this.setValue(7, attrs.getValue(ActionManager.TYPE_ATTRIBUTE));
        }
    }
}

