/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.effects;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.EventHandler;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class FadeComponent
extends JComponent {
    private static final int TIME_DELAY = 750;
    private JComponent component;
    private Container parent;
    private Object cons;
    private Image componentBuffer;
    private long start;
    private Timer timer;
    private boolean fadeIn;
    private ActionListener listener;
    private Rectangle componentBounds;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public static void fadeIn(JComponent component, Object cons, ActionListener listener) {
        new FadeComponent(component, cons, true, listener).animate();
    }

    public static void fadeOut(JComponent component, Object cons, ActionListener listener) {
        new FadeComponent(component, cons, false, listener).animate();
    }

    FadeComponent(JComponent component, Object cons, boolean direction, ActionListener listener) {
        this.cons = cons;
        this.setOpaque(false);
        this.component = component;
        this.fadeIn = direction;
        this.parent = component.getParent();
        this.listener = listener;
        this.componentBounds = component.getBounds();
        this.setBounds(this.componentBounds);
        this.bufferImage();
        this.swap(component, this);
    }

    protected void paintChildren(Graphics g) {
        if (this.getComponentCount() > 0) {
            Graphics2D g2 = (Graphics2D)g;
            Composite defaultComposite = g2.getComposite();
            g2.setComposite(this.getComposite());
            super.paintChildren(g);
            g2.setComposite(defaultComposite);
        } else {
            super.paintChildren(g);
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.getComponentCount() > 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Composite defaultComposite = g2.getComposite();
        g2.setComposite(this.getComposite());
        g2.drawImage(this.componentBuffer, 0, 0, null);
        g2.setComposite(defaultComposite);
    }

    protected Composite getComposite() {
        long time = System.currentTimeMillis();
        float alpha = this.getDelta();
        if (!this.fadeIn) {
            alpha = 1.0f - alpha;
        }
        return AlphaComposite.getInstance(3, alpha);
    }

    private void swap(Component oldC, Component newC) {
        Component[] children = this.parent.getComponents();
        for (int counter = 0; counter < children.length; ++counter) {
            if (children[counter] != oldC) continue;
            JLayeredPane lp = this.parent instanceof JLayeredPane ? (JLayeredPane)this.parent : null;
            int position = -1;
            if (lp != null) {
                position = lp.getPosition(oldC);
            }
            this.parent.add(newC, this.cons, counter);
            this.parent.remove(oldC);
            if (lp == null) break;
            lp.setPosition(newC, position);
            break;
        }
    }

    protected void animate() {
        this.start = System.currentTimeMillis();
        this.timer = new Timer(1, (ActionListener)EventHandler.create(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = FadeComponent.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this, "animateLoop"));
        this.timer.start();
    }

    protected float getDelta() {
        return (float)Math.min(750L, System.currentTimeMillis() - this.start) / 750.0f;
    }

    public void animateLoop() {
        long end = this.start + 750L;
        long time = System.currentTimeMillis();
        this.repaint();
        if (time > end) {
            this.cleanup();
        }
    }

    protected void cleanup() {
        this.timer.stop();
        this.timer = null;
        if (this.fadeIn) {
            this.restoreComponentBounds(this.component);
            this.swap(this, this.component);
        } else {
            Rectangle bounds = this.getBounds();
            this.parent.remove(this);
            this.parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.removeAll();
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    protected void restoreComponentBounds(Component c) {
        c.setBounds(this.componentBounds);
    }

    private void bufferImage() {
        this.componentBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics g = this.componentBuffer.getGraphics();
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        RepaintManager rm = RepaintManager.currentManager(this.component);
        boolean isRMDB = rm.isDoubleBufferingEnabled();
        boolean isDB = this.component.isDoubleBuffered();
        rm.setDoubleBufferingEnabled(false);
        this.component.setDoubleBuffered(false);
        this.component.paint(g);
        this.component.setDoubleBuffered(isDB);
        rm.setDoubleBufferingEnabled(isRMDB);
        g.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

