/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import warbot.demo.KoyotBrain;
import warbot.kernel.Percept;

public class KKExplorer
extends KoyotBrain {
    final int clockWise = 1;
    final int antiClockWise = 2;
    final int getApens = 3;
    int escape = 0;

    public void activate() {
        this.roleName = "explorer";
        super.activate();
        this.setPriotityAdjustmentForRole(-30);
        this.behaviour = new int[][]{{75, -100, -100, -100, -100, 10, -100, -100, -100}, {25, 30, -100, -100, 75, 20, -100, -100, -100}, {35, 60, -100, -100, 60, 20, -100, -100, -100}, {50, 70, -100, -100, 65, 20, -100, -100, -100}, {40, -100, 85, -100, -100, 10, -100, -100, -100}, {20, -100, -100, -100, -100, 10, 60, -100, -100}, {20, -100, -100, -100, -100, 10, -100, 55, -100}};
    }

    public void call_attackBot() {
        if (this.escape > 0) {
            --this.escape;
            this.slide();
            return;
        }
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (!e.getTeam().equals(this.getTeam()) && e.getPerceptType().equals("RocketLauncher")) {
                    double X = e.getX();
                    double Y = e.getY();
                    double rdX = 0.0;
                    double rdY = 0.0;
                    double decay = 550.0;
                    this.computRotation(e);
                    decay = this.rotation == 1 ? (decay *= (double)-1) : (decay *= 1.0);
                    double dodgeY = 800.0;
                    double dodgeX = 100.0;
                    double closeDecay = 5000.0;
                    if (X <= 0.0 && Y <= 0.0) {
                        rdY = Y - decay;
                        rdX = X + decay;
                    } else if (Y <= 0.0 && X > 0.0) {
                        rdY = Y + decay;
                        rdX = X + decay;
                    } else if (X > 0.0 && Y > 0.0) {
                        rdX = X - decay;
                        rdY = Y + decay;
                    } else if (X <= 0.0 && Y > 0.0) {
                        rdY = Y - decay;
                        rdX = X - decay;
                    } else {
                        this.randomHeading();
                        this.slide();
                        return;
                    }
                    if (X * X < closeDecay && Y * Y < closeDecay) {
                        rdY = -Y;
                        rdX = -X;
                    }
                    this.setHeading(this.towards(rdX, rdY));
                    this.slide();
                    continue;
                }
                this.slide();
            }
        }
    }

    public void call_attackBase() {
        this.slide();
    }

    public void screamMessages(int action) {
        if (this.ennemyBase) {
            this.throwMessage("Home", 70, 1);
        }
        if (action == 1 && (this.underpower || this.equalpower)) {
            this.throwMessage("RocketLauncher", 70, 0);
        }
    }

    public void call_goHelp() {
        this.setHeading(this.towards(this.objectiveX, this.objectiveY));
        this.slide();
    }

    public void call_moveToBase() {
        this.setHeading(this.towards(this.objectiveX, this.objectiveY));
        this.slide();
    }

    public int[] GetEnergyLevelModifier(float ratio) {
        int[] modifier = ratio > (float)60 ? new int[]{20, 10, 10, -50, 5, -15, 0, 5, 10} : (ratio < (float)35 ? new int[]{0, -30, -10, -50, 25, 10, 35, 20, 0} : new int[]{5, -15, 0, -50, 10, 0, 25, 10, 5});
        return modifier;
    }

    public void processLeaveGroup(int action) {
        if (this.groupGoal != -1) {
            switch (this.groupGoal) {
                case 0: {
                    if (action == 2 || action == 6 || action == 7 || action == 1 || action == 8) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
                case 1: {
                    if (action != 0 && action != 2 && action != 8 && (action != 3 || this.testIfInMyGroup(this.maxPriorityMessage))) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
                case 2: {
                    if (action == 0 || action == 6 || action == 7 || action == 4) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
                case 3: {
                    if (action != 0 && action != 8 && action != 2 && (action != 3 || !this.helpBase)) break;
                    this.ejectFromCurrentGroup();
                    break;
                }
            }
        }
    }

    public void call_goAway() {
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (!e.getTeam().equals(this.getTeam()) && e.getPerceptType().equals("RocketLauncher")) {
                    this.setHeading(this.towards(-e.getX(), -e.getY()));
                    this.slide();
                    return;
                }
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("Explorer")) continue;
                this.slide();
            }
        }
    }

    public void computRotation(Percept ennemy) {
        double sumX = 0.0;
        double sumY = 0.0;
        int nbObstacles = 0;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getPerceptType().equals("Obstacle")) {
                    sumX += e.getX();
                    sumY += e.getY();
                    ++nbObstacles;
                    continue;
                }
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("RocketLauncher")) continue;
                sumX += e.getX();
                sumY += e.getY();
                ++nbObstacles;
            }
        }
        sumX = ennemy.getX() - sumX / (double)nbObstacles;
        sumY = ennemy.getY() - sumY / (double)nbObstacles;
        if (sumY > 0.0 && sumX > 0.0) {
            this.rotation = 2;
        } else if (sumY > 0.0 && sumX <= 0.0) {
            this.rotation = 1;
        } else if (sumY <= 0.0 && sumX > 0.0) {
            this.rotation = 1;
        } else if (sumY <= 0.0 && sumX <= 0.0) {
            this.rotation = 2;
        }
        if (this.rotation != this.lastRotation && this.lastRotation != 0) {
            this.escape = 20;
        }
        this.lastRotation = this.rotation;
    }
}

