/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.http;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Message {
    public static final String SESSION_ID = "JSESSIONID";
    public static final String SESSION_ID_PREFIX = "=";
    public static final String SESSION_ID_POSTFIX = ";";
    public static final String COOKIE = "Cookie";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String USER_AGENT = "User-Agent";
    public static final String TROLL = "Troll/1.0 (Life is Good) Troll/1.0";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ALL = "*/*";
    public static final String CHARSET = "iso-8859-1,*,utf-8";
    public static final String URL_FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String CONNECTION = "Connection";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String GET = "GET";
    public static final String POST = "POST";
    private static List sessionIds = null;
    private Map headers = null;
    private String body = null;
    private URL referer = null;

    public Message() {
        this(null, null);
    }

    public Message(Map headers) {
        this(headers, null);
    }

    public Message(String body) {
        this(null, body);
    }

    public Message(Map headers, String body) {
        this.headers = headers;
        this.body = body;
    }

    public String getHeader(String key) {
        Iterator i = this.getHeaders(key);
        return i.hasNext() ? (String)i.next() : null;
    }

    public Iterator getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        String k = null;
        Object o = null;
        Iterator i = this.getHeaderKeys();
        while (i != null && i.hasNext()) {
            k = (String)i.next();
            if (!k.equalsIgnoreCase(key)) continue;
            o = this.headers.get(k);
            if (o instanceof String) {
                values.add(o);
                continue;
            }
            if (!(o instanceof Collection)) continue;
            values.addAll(o);
        }
        return values.iterator();
    }

    public Iterator getHeaderKeys() {
        return this.headers != null ? this.headers.keySet().iterator() : Collections.EMPTY_LIST.iterator();
    }

    public void setHeader(String key, String value) {
        this.setHeader(key, (Object)value);
    }

    public void setHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(key, value);
    }

    public void setHeaders(Map headers) {
        String key = null;
        Iterator i = headers.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            this.setHeader(key, headers.get(key));
        }
    }

    public void removeHeader(String key) {
        if (this.headers != null) {
            this.headers.remove(key);
            if (this.headers.size() == 0) {
                this.headers = null;
            }
        }
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
            this.headers = null;
        }
    }

    public String getSessionId() {
        String s = this.getHeader(COOKIE);
        return s != null ? this.parseSessionIdFromHeader(s) : this.parseSessionIdFromBody(this.getBody());
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean hasBody() {
        return this.body != null && this.body.trim().length() > 0;
    }

    public void setReferer(URL referer) {
        this.referer = referer;
    }

    public URL getReferer() {
        return this.referer;
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String object = null;
        Object value = null;
        for (int i = 0; i < fields.length; ++i) {
            try {
                object = fields[i].getName();
                value = fields[i].get(this);
                if (value == null) {
                    value = new String("null");
                }
                map.put(object, value);
                continue;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
        if (clazz.getSuperclass().getSuperclass() != null) {
            map.put("super", clazz.getSuperclass().toString());
        }
        return clazz.getName() + map;
    }

    private String parseSessionIdFromHeader(String value) {
        String EQUAL = SESSION_ID_PREFIX;
        String id = null;
        String prefix = null;
        if (value != null) {
            Iterator i = sessionIds.iterator();
            while (i.hasNext()) {
                id = (String)i.next();
                if (value.indexOf(id) <= -1) continue;
                prefix = id;
                value = this.trim(value, id + SESSION_ID_PREFIX, SESSION_ID_POSTFIX);
                break;
            }
        }
        return value != null ? prefix + SESSION_ID_PREFIX + value : value;
    }

    private String parseSessionIdFromBody(String value) {
        String SEMI_COLON = SESSION_ID_POSTFIX;
        String QUOTE = "\"";
        String QUESTION_MARK = "?";
        String SINGLE_QUOTE = "'";
        String GREATER_THAN = ">";
        if (value != null && value.indexOf(SESSION_ID) > -1) {
            value = this.trim(value, SESSION_ID_POSTFIX + SESSION_ID.toLowerCase(), "\"");
            value = this.trim(value, null, "?");
            value = this.trim(value, null, "'");
            value = this.trim(value, null, ">");
        } else {
            value = null;
        }
        return value;
    }

    private String trim(String value, String prefix, String postfix) {
        StringBuffer sb = null;
        if (value != null && value.length() > 0) {
            sb = new StringBuffer(value);
            int j = prefix != null ? sb.indexOf(prefix) + prefix.length() : 0;
            int k = postfix != null ? sb.indexOf(postfix, j + 1) : sb.length() - 1;
            sb = new StringBuffer(sb.substring(j, k >= 0 ? k : sb.length()));
        }
        return sb != null ? sb.toString() : null;
    }

    static {
        sessionIds = new ArrayList();
        sessionIds.add(SESSION_ID);
    }
}

