/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import net.jxta.ext.http.HttpGet;
import net.jxta.ext.http.Message;

public class HttpPost
extends HttpGet {
    public HttpPost() {
        this(null);
    }

    public HttpPost(URL url) {
        this(url, null);
    }

    public HttpPost(URL url, Message msg) {
        super(url, msg);
        this.method = "POST";
    }

    public Message dispatch() throws IOException {
        URL u = this.getURL();
        this.connection = this.openConnection(u);
        this.doGet();
        this.doPost();
        Message response = this.getResponse(u);
        this.closeConnection();
        return response;
    }

    protected void doPost() throws IOException {
        Message msg = this.getMessage();
        if (this.method == "POST" && msg != null && msg.hasBody()) {
            BufferedWriter bw = null;
            boolean isError = false;
            try {
                char[] buf = msg.getBody().toCharArray();
                OutputStreamWriter osw = new OutputStreamWriter(this.connection.getOutputStream());
                int l = 4096;
                int c = 0;
                int m = buf.length;
                bw = new BufferedWriter(osw);
                while (c * 4096 < m) {
                    if ((c + l) * 4096 > m) {
                        l = m - c * 4096;
                    }
                    bw.write(buf, c++ * 4096, l);
                }
            }
            catch (Exception e) {
                isError = true;
            }
            if (bw != null) {
                bw.flush();
                bw.close();
            }
            if (isError) {
                throw new IOException();
            }
        }
    }

    static {
        headers.put("Accept-Charset", "iso-8859-1,*,utf-8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
    }
}

