/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.http;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jxta.ext.http.Dispatchable;
import net.jxta.ext.http.Message;

public class HttpGet
implements Dispatchable {
    protected static final int BLOCK = 4096;
    protected String method = "GET";
    protected URLConnection connection = null;
    protected static Map headers = new HashMap();
    private URL url = null;
    private Message message = null;

    public HttpGet() {
        this(null);
    }

    public HttpGet(URL url) {
        this(url, null);
    }

    public HttpGet(URL url, Message msg) {
        this.url = url;
        this.message = msg;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message msg) {
        this.message = msg;
    }

    public Message dispatch() throws IOException {
        return this.dispatch(this.url);
    }

    public void disconnect() {
        this.connection = null;
    }

    protected Message dispatch(URL u) throws IOException {
        this.connection = this.openConnection(u);
        this.doGet();
        Message response = this.getResponse(u);
        this.closeConnection();
        return response;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        URLConnection uc = null;
        uc = u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("https") ? this.openHttpConnection(u) : this.openFileConnection(u);
        return uc;
    }

    protected void closeConnection() {
        if (this.connection != null && this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        this.connection = null;
    }

    protected void doGet() throws IOException {
    }

    protected Message getResponse(URL u) throws IOException {
        Message msg = new Message();
        try {
            msg.setHeaders(this.getResponseHeaders());
            String clh = msg.getHeader("Content-Length");
            int cl = -1;
            try {
                cl = Integer.valueOf(clh != null ? clh : "-1");
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String ct = msg.getHeader("Content-Type");
            msg.setBody(cl == -1 && ct != null || cl > 0 ? this.getResponseBody() : "");
        }
        catch (Exception e) {
            throw new IOException();
        }
        return msg;
    }

    private HttpURLConnection openHttpConnection(URL u) throws IOException {
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setRequestMethod(this.method);
        String key = null;
        String value = null;
        Message msg = this.getMessage();
        if (msg != null) {
            Iterator k = msg.getHeaderKeys();
            while (k.hasNext()) {
                key = (String)k.next();
                value = msg.getHeader(key);
                c.setRequestProperty(key, value);
            }
        }
        boolean doOutput = this.method == "POST" && msg != null && msg.hasBody();
        boolean followRedirects = false;
        Iterator k = headers.keySet().iterator();
        while (k.hasNext()) {
            key = (String)k.next();
            if (c.getRequestProperty(key) != null) continue;
            value = (String)headers.get(key);
            c.setRequestProperty(key, value);
        }
        if (doOutput) {
            c.setRequestProperty("Content-Length", Integer.toString(msg.getBody().getBytes().length));
        }
        c.setDoOutput(doOutput);
        c.setDoInput(true);
        c.setUseCaches(false);
        HttpURLConnection.setFollowRedirects(followRedirects);
        c.setInstanceFollowRedirects(followRedirects);
        return c;
    }

    private URLConnection openFileConnection(URL u) throws IOException {
        return u.openConnection();
    }

    private Map getResponseHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.putAll(this.connection.getHeaderFields());
        headers.remove(null);
        return headers;
    }

    private String getResponseBody() throws IOException {
        CharArrayWriter w = new CharArrayWriter();
        try {
            InputStreamReader isr = new InputStreamReader(this.connection.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            char[] buf = new char[4096];
            int l = 0;
            while ((l = br.read(buf, 0, 4096)) > -1) {
                w.write(buf, 0, l);
            }
            br.close();
        }
        catch (Exception e) {
            throw new IOException();
        }
        return w.toString();
    }

    static {
        headers.put("User-Agent", "Troll/1.0 (Life is Good) Troll/1.0");
        headers.put("Accept", "*/*");
        headers.put("Connection", "Keep-Alive");
    }
}

