/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config.ui;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.jxta.exception.ConfiguratorException;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Configurator;
import net.jxta.ext.config.HttpTransport;
import net.jxta.ext.config.MulticastAddress;
import net.jxta.ext.config.Profile;
import net.jxta.ext.config.ProxyAddress;
import net.jxta.ext.config.PublicAddress;
import net.jxta.ext.config.TcpTransport;
import net.jxta.ext.config.TcpTransportAddress;
import net.jxta.ext.config.Trace;
import net.jxta.ext.config.Util;
import net.jxta.ext.config.ui.AutoLoaderListener;
import net.jxta.ext.config.ui.HttpTransportTableModel;
import net.jxta.ext.config.ui.TcpTransportTableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.swixml.SwingEngine;

public class ConfiguratorListener
implements ActionListener {
    private static final transient Logger LOG = Logger.getLogger((String)ConfiguratorListener.class.getName());
    private static final String DLG_AUTOLOAD = "net/jxta/ext/config/ui/resource/Autoloader.xml";
    static SwingEngine swix;
    static JTextField tcpPublicAddr;
    static JTextField tcpPublicPort;
    static JTextField httpPublicAddr;
    static JTextField httpPublicPort;
    static JTextField httpProxyAddr;
    static JTextField httpProxyPort;
    static JCheckBox tcpEnabled;
    static JCheckBox tcpManualEnabled;
    private JCheckBox tcpPublicEnabled;
    static JCheckBox httpEnabled;
    static JCheckBox httpManualEnabled;
    private JCheckBox httpPublicEnabled;
    static JCheckBox profileManualEnabled;
    static JTextField certFile;
    static JCheckBox rlyUsageEnabled;
    static JCheckBox rlySvcEnabled;
    static JCheckBox rdvSvcEnabled;
    static JCheckBox endpSvcEnabled;
    static JCheckBox proxySvcEnabled;
    static JPanel tcpPanel;
    static JPanel httpPanel;
    static JPanel rlyPanel;
    static JPanel rlySvcPanel;
    static JPanel rdvSvcPanel;
    static JPanel endpSvcPanel;
    static JPanel proxySvcPanel;
    static JCheckBox advEnabled;

    public ConfiguratorListener(SwingEngine swix) {
        ConfiguratorListener.swix = swix;
        profileManualEnabled = (JCheckBox)swix.find("id_peerprofilemethod");
        tcpPublicAddr = (JTextField)swix.find("id_tcppublicaddress");
        tcpPublicPort = (JTextField)swix.find("id_tcppublicport");
        httpPublicAddr = (JTextField)swix.find("id_httppublicaddress");
        httpPublicPort = (JTextField)swix.find("id_httppublicport");
        httpProxyAddr = (JTextField)swix.find("id_httpproxyaddress");
        httpProxyPort = (JTextField)swix.find("id_httpproxyport");
        tcpEnabled = (JCheckBox)swix.find("id_tcpenabled");
        tcpManualEnabled = (JCheckBox)swix.find("id_tcpmanualaddresses");
        this.tcpPublicEnabled = (JCheckBox)swix.find("id_tcphaspublicaddress");
        httpEnabled = (JCheckBox)swix.find("id_httpenabled");
        httpManualEnabled = (JCheckBox)swix.find("id_httpmanualaddresses");
        this.httpPublicEnabled = (JCheckBox)swix.find("id_httphaspublicaddress");
        certFile = (JTextField)swix.find("id_certfile");
        rlyUsageEnabled = (JCheckBox)swix.find("id_cfguserly");
        rlySvcEnabled = (JCheckBox)swix.find("id_cfgrlyservice");
        rdvSvcEnabled = (JCheckBox)swix.find("id_cfgrdvservice");
        endpSvcEnabled = (JCheckBox)swix.find("id_cfgendpservice");
        proxySvcEnabled = (JCheckBox)swix.find("id_cfgproxyservice");
        advEnabled = (JCheckBox)swix.find("id_advenabled");
        tcpPanel = (JPanel)swix.find("id_cfgtcpcard");
        httpPanel = (JPanel)swix.find("id_cfghttpcard");
        rlyPanel = (JPanel)swix.find("id_cfgrlycard");
        rlySvcPanel = (JPanel)swix.find("id_cfgrlyservicecard");
        rdvSvcPanel = (JPanel)swix.find("id_cfgrdvservicecard");
        endpSvcPanel = (JPanel)swix.find("id_cfgendpservicecard");
        proxySvcPanel = (JPanel)swix.find("id_cfgproxyservicecard");
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("enableTCPPublicAddress".equals(command)) {
            this.setPublicTcp();
        } else if ("enableHTTPPublicAddress".equals(command)) {
            this.setPublicHttp();
        } else if ("enableHTTPProxy".equals(command)) {
            this.setHttpProxy();
        } else if ("enableTCPSettings".equals(command)) {
            if (tcpEnabled.isSelected()) {
                this.enable(((JPanel)tcpPanel.getComponents()[0]).getComponents());
                this.setPublicTcp();
                this.addTcpTransport();
            } else {
                this.clearTcpTransports();
            }
        } else if ("AC_enableuserly".equals(command)) {
            if (rlyUsageEnabled.isSelected()) {
                this.enable(((JPanel)rlyPanel.getComponents()[0]).getComponents());
                this.setPublicHttp();
                this.setHttpProxy();
            } else {
                this.disable(((JPanel)rlyPanel.getComponents()[0]).getComponents());
                this.enable(rlyUsageEnabled);
                this.requestFocus(rlyUsageEnabled);
            }
        } else if ("AC_enablerdvservice".equals(command)) {
            if (rdvSvcEnabled.isSelected()) {
                this.enable(((JPanel)rdvSvcPanel.getComponents()[0]).getComponents());
            } else {
                this.disable(((JPanel)rdvSvcPanel.getComponents()[0]).getComponents());
                this.enable(rdvSvcEnabled);
                this.requestFocus(rdvSvcEnabled);
            }
        } else if ("AC_enablerlyservice".equals(command)) {
            if (rlySvcEnabled.isSelected()) {
                this.enable(((JPanel)rlySvcPanel.getComponents()[0]).getComponents());
            } else {
                this.disable(((JPanel)rlySvcPanel.getComponents()[0]).getComponents());
                this.enable(rlySvcEnabled);
                this.requestFocus(rlySvcEnabled);
            }
        } else if ("AC_enableendpservice".equals(command)) {
            if (endpSvcEnabled.isSelected()) {
                this.enable(((JPanel)endpSvcPanel.getComponents()[0]).getComponents());
            } else {
                this.disable(((JPanel)endpSvcPanel.getComponents()[0]).getComponents());
                this.enable(endpSvcEnabled);
                this.requestFocus(endpSvcEnabled);
            }
        } else if ("AC_enableproxyservice".equals(command)) {
            if (proxySvcEnabled.isSelected()) {
                this.enable(((JPanel)proxySvcPanel.getComponents()[0]).getComponents());
            } else {
                this.disable(((JPanel)proxySvcPanel.getComponents()[0]).getComponents());
                this.enable(proxySvcEnabled);
                this.requestFocus(proxySvcEnabled);
            }
        } else if ("enableManualTcpAddress".equals(command)) {
            JComboBox auto = (JComboBox)swix.find("id_tcpautoentry");
            JTextField manual = (JTextField)swix.find("id_tcpmanualentry");
            if (tcpManualEnabled.isSelected()) {
                manual.setMinimumSize(auto.getMinimumSize());
                manual.setPreferredSize(auto.getPreferredSize());
                manual.setMaximumSize(auto.getMaximumSize());
                this.show(manual);
                this.hide(auto);
            } else {
                this.hide(manual);
                this.show(auto);
            }
        } else if ("enableManualHttpAddress".equals(command)) {
            JComboBox auto = (JComboBox)swix.find("id_httpautoentry");
            JTextField manual = (JTextField)swix.find("id_httpmanualentry");
            if (httpManualEnabled.isSelected()) {
                manual.setMinimumSize(auto.getMinimumSize());
                manual.setPreferredSize(auto.getPreferredSize());
                manual.setMaximumSize(auto.getMaximumSize());
                this.show(manual);
                this.hide(auto);
            } else {
                this.hide(manual);
                this.show(auto);
            }
        } else if ("enableHTTPSettings".equals(command)) {
            if (httpEnabled.isSelected()) {
                this.enable(((JPanel)httpPanel.getComponents()[0]).getComponents());
                this.setPublicHttp();
                this.setHttpProxy();
                this.addHttpTransport();
            } else {
                this.clearHttpTransports();
            }
        } else if ("enableManualProfile".equals(command)) {
            JComboBox auto = (JComboBox)swix.find("id_peerprofilecombo");
            JTextField manual = (JTextField)swix.find("id_manualpeerprofile");
            if (profileManualEnabled.isSelected()) {
                this.hide(manual);
                this.show(auto);
            } else {
                manual.setMinimumSize(auto.getMinimumSize());
                manual.setPreferredSize(auto.getPreferredSize());
                manual.setMaximumSize(auto.getMaximumSize());
                this.show(manual);
                this.hide(auto);
            }
        } else if ("importCAFile".equals(command)) {
            FileDialog getFile = new FileDialog((Frame)new JFrame(), "Select Root Certificate File", 0);
            getFile.setDirectory(System.getProperty("user.home"));
            getFile.show();
            String inDir = getFile.getDirectory();
            String theFile = getFile.getFile();
            if (null != inDir && null != theFile) {
                String fullPath = inDir + theFile;
                certFile.setText(fullPath);
            }
        } else if ("downloadrdvrly".equals(command)) {
            try {
                SwingEngine swe = new SwingEngine();
                JDialog ldr = (JDialog)swe.render(DLG_AUTOLOAD);
                swe.setActionListener((Component)ldr, (ActionListener)new AutoLoaderListener(swe, swix));
                JTextField tf = (JTextField)swe.find("id_rdvbootstrap");
                tf.setText("http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2");
                tf = (JTextField)swe.find("id_rlybootstrap");
                tf.setText("http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2");
                ldr.setVisible(true);
                ldr.dispose();
                swe = null;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(swix.getRootComponent(), "Could not create dialog, please check log.", "Internal Error", 0);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Failed to create rdv/rly loader dialog", (Throwable)ex);
                }
            }
        } else if ("advancedAction".equals(command)) {
            if (advEnabled.isSelected()) {
                this.insertAdvNodes();
            } else {
                this.removeAdvNodes();
            }
        } else if ("AC_addtcprdv".equals(command)) {
            JList list = (JList)swix.find("id_cfgtcprdvlist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            String addr = ((JTextField)swix.find("id_cfgtcprdvaddr")).getText();
            String port = ((JTextField)swix.find("id_cfgtcprdvport")).getText();
            if (!addr.equals("") && !port.equals("")) {
                model.addElement(addr + ":" + port);
            }
        } else if ("AC_deltcprdv".equals(command)) {
            JList list = (JList)swix.find("id_cfgtcprdvlist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            int i = list.getSelectedIndex();
            if (i >= 0) {
                model.remove(i);
            }
        } else if ("AC_addhttprdv".equals(command)) {
            JList list = (JList)swix.find("id_cfghttprdvlist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            String addr = ((JTextField)swix.find("id_cfghttprdvaddr")).getText();
            String port = ((JTextField)swix.find("id_cfghttprdvport")).getText();
            if (!addr.equals("") && !port.equals("")) {
                model.addElement(addr + ":" + port);
            }
        } else if ("AC_delhttprdv".equals(command)) {
            JList list = (JList)swix.find("id_cfghttprdvlist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            int i = list.getSelectedIndex();
            if (i >= 0) {
                model.remove(i);
            }
        } else if ("AC_addtcprly".equals(command)) {
            JList list = (JList)swix.find("id_cfgtcprlylist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            String addr = ((JTextField)swix.find("id_cfgtcprlyaddr")).getText();
            String port = ((JTextField)swix.find("id_cfgtcprlyport")).getText();
            if (!addr.equals("") && !port.equals("")) {
                model.addElement(addr + ":" + port);
            }
        } else if ("AC_deltcprly".equals(command)) {
            JList list = (JList)swix.find("id_cfgtcprlylist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            int i = list.getSelectedIndex();
            if (i >= 0) {
                model.remove(i);
            }
        } else if ("AC_addhttprly".equals(command)) {
            JList list = (JList)swix.find("id_cfghttprlylist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            String addr = ((JTextField)swix.find("id_cfghttprlyaddr")).getText();
            String port = ((JTextField)swix.find("id_cfghttprlyport")).getText();
            if (!addr.equals("") && !port.equals("")) {
                model.addElement(addr + ":" + port);
            }
        } else if ("AC_delhttprly".equals(command)) {
            JList list = (JList)swix.find("id_cfghttprlylist");
            DefaultListModel model = (DefaultListModel)list.getModel();
            int i = list.getSelectedIndex();
            if (i >= 0) {
                model.remove(i);
            }
        } else if ("AC_addtcptransp".equals(command)) {
            this.addTcpTransport();
        } else if ("AC_deltcptransp".equals(command)) {
            this.deleteTcpTransport();
        } else if ("AC_addhttptransp".equals(command)) {
            this.addHttpTransport();
        } else if ("AC_OK".equals(command)) {
            if (this.validate() && this.writeConfig()) {
                JFrame cfg = (JFrame)swix.find("id_optionsframe");
                cfg.dispatchEvent(new WindowEvent(cfg, 201));
            }
        } else if ("AC_CANCEL".equals(command)) {
            JFrame cfg = (JFrame)swix.find("id_optionsframe");
            cfg.dispatchEvent(new WindowEvent(cfg, 201));
        }
    }

    private boolean validate() {
        boolean valid = false;
        String peername = ((JTextField)swix.find("id_peername")).getText();
        String secpeername = ((JTextField)swix.find("id_securepeername")).getText();
        String peerpw = new String(((JPasswordField)swix.find("id_peerpassword")).getPassword());
        String verify = new String(((JPasswordField)swix.find("id_peerpasswordverify")).getPassword());
        if (peername.equals("")) {
            JOptionPane.showMessageDialog(swix.getRootComponent(), "Peer name cannot be empty.", "Input Error", 0);
        } else if (secpeername.equals("")) {
            JOptionPane.showMessageDialog(swix.getRootComponent(), "Secure peer name cannot be empty.", "Input Error", 0);
        } else if (peerpw.equals("") || verify.equals("")) {
            JOptionPane.showMessageDialog(swix.getRootComponent(), "Password & Verification must not be empty.", "Input Error", 0);
        } else if (!peerpw.equals(verify)) {
            JOptionPane.showMessageDialog(swix.getRootComponent(), "Passwords do not match.", "Input Error", 0);
        } else {
            valid = true;
        }
        return valid;
    }

    private boolean writeConfig() {
        boolean saved;
        block27: {
            saved = false;
            Profile profile = Profile.get(((JComboBox)swix.find("id_peerprofilecombo")).getSelectedItem().toString());
            Configurator cfg = new Configurator(profile);
            try {
                if (advEnabled.isSelected()) {
                    String publicPort;
                    String publicAddr;
                    boolean enableIn;
                    boolean enableOut;
                    boolean hidePrivate;
                    String port;
                    String addr;
                    Object[] row;
                    JTable table;
                    cfg.setRendezVousDiscovery(((JCheckBox)swix.find("id_useonlycfgedrdv")).isSelected());
                    JList list = (JList)swix.find("id_cfgtcprdvlist");
                    DefaultListModel model = (DefaultListModel)list.getModel();
                    Vector<URI> alist = new Vector<URI>();
                    Enumeration each = model.elements();
                    while (each.hasMoreElements()) {
                        alist.addElement(new URI("tcp://" + each.nextElement()));
                    }
                    list = (JList)swix.find("id_cfghttprdvlist");
                    model = (DefaultListModel)list.getModel();
                    each = model.elements();
                    while (each.hasMoreElements()) {
                        alist.addElement(new URI("http://" + each.nextElement()));
                    }
                    if (!alist.isEmpty()) {
                        cfg.clearRendezVous();
                        cfg.setRendezVous(alist);
                    }
                    cfg.setProxy(proxySvcEnabled.isSelected());
                    if (rlyUsageEnabled.isSelected()) {
                        list = (JList)swix.find("id_cfgtcprlylist");
                        model = (DefaultListModel)list.getModel();
                        alist = new Vector();
                        each = model.elements();
                        while (each.hasMoreElements()) {
                            alist.addElement(new URI("tcp://" + each.nextElement()));
                        }
                        list = (JList)swix.find("id_cfghttprlylist");
                        model = (DefaultListModel)list.getModel();
                        each = model.elements();
                        while (each.hasMoreElements()) {
                            alist.addElement(new URI("http://" + each.nextElement()));
                        }
                        cfg.setRelayDiscovery(true);
                        cfg.clearRelays();
                        cfg.setRelays(alist);
                    } else {
                        cfg.setRelayDiscovery(false);
                    }
                    if (tcpEnabled.isSelected()) {
                        table = (JTable)swix.find("id_cfgtcptransporttable");
                        TcpTransportTableModel tmodel = (TcpTransportTableModel)table.getModel();
                        TcpTransport tcp = null;
                        each = tmodel.getRows().elements();
                        while (each.hasMoreElements()) {
                            tcp = new TcpTransport();
                            TcpTransportAddress tcpaddr = new TcpTransportAddress();
                            row = (Object[])each.nextElement();
                            addr = row[0].equals("Any/All Local Addresses") ? Util.getLocalHost() : (String)row[0];
                            port = (String)row[1];
                            hidePrivate = (Boolean)row[2];
                            enableOut = (Boolean)row[3];
                            enableIn = (Boolean)row[4];
                            publicAddr = !((String)row[5]).equals("./.") ? (String)row[5] : null;
                            publicPort = !((String)row[6]).equals("./.") ? (String)row[6] : null;
                            boolean enableMC = (Boolean)row[7];
                            tcpaddr.setAddress(new URI("tcp://" + addr + ":" + port));
                            tcpaddr.setPortRange(0);
                            MulticastAddress mc = new MulticastAddress();
                            mc.setMulticast(enableMC);
                            tcpaddr.setMulticastAddress(mc);
                            tcp.setAddress(tcpaddr);
                            tcp.setProxy(false);
                            tcp.setEnabled(true);
                            tcp.setIncoming(enableIn);
                            tcp.setOutgoing(enableOut);
                            if (null != publicAddr && null != publicPort) {
                                PublicAddress pubAddr = new PublicAddress();
                                pubAddr.setAddress(new URI("tcp://" + publicAddr + ":" + publicPort));
                                tcp.setPublicAddress(pubAddr);
                            }
                            cfg.addTransport(tcp);
                        }
                    }
                    if (httpEnabled.isSelected()) {
                        table = (JTable)swix.find("id_cfghttptransporttable");
                        HttpTransportTableModel hmodel = (HttpTransportTableModel)table.getModel();
                        HttpTransport http = null;
                        each = hmodel.getRows().elements();
                        while (each.hasMoreElements()) {
                            http = new HttpTransport();
                            Address httpaddr = new Address();
                            row = (Object[])each.nextElement();
                            addr = row[0].equals("Any/All Local Addresses") ? Util.getLocalHost() : (String)row[0];
                            port = (String)row[1];
                            hidePrivate = (Boolean)row[2];
                            enableOut = (Boolean)row[3];
                            enableIn = (Boolean)row[4];
                            publicAddr = !((String)row[5]).equals("./.") ? (String)row[5] : null;
                            publicPort = !((String)row[6]).equals("./.") ? (String)row[6] : null;
                            boolean enableProxy = (Boolean)row[7];
                            String proxyAddr = !((String)row[8]).equals("./.") ? (String)row[8] : null;
                            String proxyPort = !((String)row[9]).equals("./.") ? (String)row[9] : null;
                            httpaddr.setAddress(new URI("http://" + addr + ":" + port));
                            httpaddr.setPortRange(0);
                            http.setAddress(httpaddr);
                            http.setEnabled(true);
                            http.setIncoming(enableIn);
                            http.setOutgoing(enableOut);
                            if (null != publicAddr && null != publicPort) {
                                PublicAddress pubAddr = new PublicAddress();
                                pubAddr.setAddress(new URI("tcp://" + publicAddr + ":" + publicPort));
                                http.setPublicAddress(pubAddr);
                            }
                            if (enableProxy) {
                                ProxyAddress proxy = new ProxyAddress();
                                proxy.setAddress(new URI("http://" + proxyAddr + ":" + proxyPort));
                                http.setProxyAddress(proxy);
                            }
                            http.setProxy(enableProxy);
                            cfg.addTransport(http);
                        }
                    }
                    if (rdvSvcEnabled.isSelected()) {
                        JCheckBox rdvSvcAutostart = (JCheckBox)swix.find("id_rdvautostart");
                        JTextField rdvSvcAutoInterval = (JTextField)swix.find("id_rdvautostartinterval");
                        if (rdvSvcAutostart.isSelected()) {
                            cfg.setRendezVousAutoStart(new Integer(rdvSvcAutoInterval.getText()).longValue());
                        } else {
                            cfg.setRendezVous(true);
                        }
                    }
                    if (rlySvcEnabled.isSelected()) {
                        JTextField rlyQueueSize = (JTextField)swix.find("id_cfgrlyqueuesize");
                        JCheckBox rlyIncomingEnable = (JCheckBox)swix.find("id_cfgrlyincoming");
                        JTextField rlyIncomingMax = (JTextField)swix.find("id_rlyincomingmax");
                        JTextField rlyIncomingLease = (JTextField)swix.find("id_rlyincominglease");
                        JCheckBox rlyOutgoingEnable = (JCheckBox)swix.find("id_cfgrlyoutgoing");
                        JTextField rlyOutgoingMax = (JTextField)swix.find("id_rlyoutgoingmax");
                        JTextField rlyOutgoingLease = (JTextField)swix.find("id_rlyoutgoinglease");
                        cfg.setRelay(true);
                        cfg.setRelayQueueSize(new Integer(rlyQueueSize.getText()));
                        if (rlyIncomingEnable.isSelected()) {
                            cfg.setRelayIncoming(true);
                            cfg.setRelayIncomingMaximum(new Integer(rlyIncomingMax.getText()));
                            cfg.setRelayIncomingLease(new Integer(rlyIncomingLease.getText()).longValue());
                        }
                        if (rlyOutgoingEnable.isSelected()) {
                            cfg.setRelayOutgoing(true);
                            cfg.setRelayOutgoingMaximum(new Integer(rlyOutgoingMax.getText()));
                            cfg.setRelayOutgoingLease(new Integer(rlyOutgoingLease.getText()).longValue());
                        }
                    }
                    if (endpSvcEnabled.isSelected()) {
                        JTextField endpQueueSize = (JTextField)swix.find("id_cfgendpqueuesize");
                        cfg.setEndpointOutgoingQueueSize(new Integer(endpQueueSize.getText()));
                    }
                    if (proxySvcEnabled.isSelected()) {
                        JTextField peerProxyAddr = (JTextField)swix.find("id_prxsvcuri");
                        cfg.setPeerProxyAddress(new URI(peerProxyAddr.getText()));
                    }
                }
                cfg.setName(((JTextField)swix.find("id_peername")).getText());
                cfg.setSecurity(((JTextField)swix.find("id_securepeername")).getText(), new String(((JPasswordField)swix.find("id_peerpassword")).getPassword()));
                Trace trace = Trace.get(((JComboBox)swix.find("id_tracelevel")).getSelectedItem().toString());
                cfg.setTrace(trace);
                cfg.save();
                saved = true;
            }
            catch (ConfiguratorException e) {
                JOptionPane.showMessageDialog(swix.getRootComponent(), "Wrong configuration data, please check log.", "Input Error", 0);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.error((Object)"User entered invalid information", (Throwable)e);
                }
            }
            catch (URISyntaxException e) {
                JOptionPane.showMessageDialog(swix.getRootComponent(), "Invalid URI syntax, please check.", "Input Error", 0);
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block27;
                LOG.error((Object)"User entered invalid information", (Throwable)e);
            }
        }
        return saved;
    }

    private void setHttpProxy() {
        if (!httpProxyAddr.isEnabled()) {
            this.enable(httpProxyAddr);
            this.enable(httpProxyPort);
        } else {
            this.disable(httpProxyAddr);
            this.disable(httpProxyPort);
        }
    }

    private void setPublicHttp() {
        if (this.httpPublicEnabled.isSelected()) {
            this.enable(httpPublicAddr);
            this.enable(httpPublicPort);
        } else {
            this.disable(httpPublicAddr);
            this.disable(httpPublicPort);
        }
    }

    private void setPublicTcp() {
        if (this.tcpPublicEnabled.isSelected()) {
            this.enable(tcpPublicAddr);
            this.enable(tcpPublicPort);
        } else {
            this.disable(tcpPublicAddr);
            this.disable(tcpPublicPort);
        }
    }

    private void addTcpTransport() {
        JTable table = (JTable)swix.find("id_cfgtcptransporttable");
        boolean hasPublicAddr = ((JCheckBox)swix.find("id_tcphaspublicaddress")).isSelected();
        TcpTransportTableModel model = (TcpTransportTableModel)table.getModel();
        model.addRow(new Object[]{tcpManualEnabled.isSelected() ? ((JTextField)swix.find("id_tcpmanualentry")).getText() : ((JComboBox)swix.find("id_tcpautoentry")).getSelectedItem().toString(), ((JTextField)swix.find("id_cfgtcptranspport")).getText(), new Boolean(((JCheckBox)swix.find("id_tcphideprivate")).isSelected()), new Boolean(((JCheckBox)swix.find("id_tcpenableoutgoing")).isSelected()), new Boolean(((JCheckBox)swix.find("id_tcpenableincoming")).isSelected()), hasPublicAddr ? ((JTextField)swix.find("id_tcppublicaddress")).getText() : "./.", hasPublicAddr ? ((JTextField)swix.find("id_tcppublicport")).getText() : "./.", new Boolean(((JCheckBox)swix.find("id_tcpmulticast")).isSelected())});
        model.fireTableDataChanged();
    }

    private void addHttpTransport() {
        JTable table = (JTable)swix.find("id_cfghttptransporttable");
        boolean hasPublicAddr = ((JCheckBox)swix.find("id_httphaspublicaddress")).isSelected();
        boolean hasProxyAddr = ((JCheckBox)swix.find("id_httpuseproxy")).isSelected();
        HttpTransportTableModel model = (HttpTransportTableModel)table.getModel();
        model.addRow(new Object[]{httpManualEnabled.isSelected() ? ((JTextField)swix.find("id_httpmanualentry")).getText() : ((JComboBox)swix.find("id_httpautoentry")).getSelectedItem().toString(), ((JTextField)swix.find("id_cfghttptranspport")).getText(), new Boolean(((JCheckBox)swix.find("id_httphideprivate")).isSelected()), new Boolean(((JCheckBox)swix.find("id_httpenableoutgoing")).isSelected()), new Boolean(((JCheckBox)swix.find("id_httpenableincoming")).isSelected()), hasPublicAddr ? ((JTextField)swix.find("id_httppublicaddress")).getText() : "./.", hasPublicAddr ? ((JTextField)swix.find("id_httppublicport")).getText() : "./.", new Boolean(((JCheckBox)swix.find("id_httpuseproxy")).isSelected()), hasProxyAddr ? ((JTextField)swix.find("id_httpproxyaddress")).getText() : "./.", hasProxyAddr ? ((JTextField)swix.find("id_httpproxyport")).getText() : "./."});
        model.fireTableDataChanged();
    }

    private void deleteTcpTransport() {
        JTable table = (JTable)swix.find("id_cfgtcptransporttable");
        TcpTransportTableModel model = (TcpTransportTableModel)table.getModel();
        if (table.getSelectedRow() > -1) {
            model.deleteRow(table.getSelectedRow());
            model.fireTableDataChanged();
            if (model.getRowCount() == 0) {
                this.disable(((JPanel)tcpPanel.getComponents()[0]).getComponents());
                ((JCheckBox)swix.find("id_tcphaspublicaddress")).setSelected(false);
                tcpEnabled.setSelected(false);
                this.enable(tcpEnabled);
                this.requestFocus(tcpEnabled);
            }
        }
    }

    private void clearTcpTransports() {
        JTable table = (JTable)swix.find("id_cfgtcptransporttable");
        TcpTransportTableModel model = (TcpTransportTableModel)table.getModel();
        for (int i = model.getRowCount() - 1; i >= 0; --i) {
            model.deleteRow(i);
        }
        model.fireTableDataChanged();
        this.disable(((JPanel)tcpPanel.getComponents()[0]).getComponents());
        this.enable(tcpEnabled);
        this.requestFocus(tcpEnabled);
    }

    private void clearHttpTransports() {
        JTable table = (JTable)swix.find("id_cfghttptransporttable");
        HttpTransportTableModel model = (HttpTransportTableModel)table.getModel();
        for (int i = model.getRowCount() - 1; i >= 0; --i) {
            model.deleteRow(i);
        }
        model.fireTableDataChanged();
        this.disable(((JPanel)httpPanel.getComponents()[0]).getComponents());
        this.enable(httpEnabled);
        this.requestFocus(httpEnabled);
    }

    private void show(Component component) {
        component.setVisible(true);
    }

    private void hide(Component component) {
        component.setVisible(false);
    }

    private void removeAdvNodes() {
        JTree tree = (JTree)swix.find("id_cfgtree");
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        int i = root.getChildCount();
        while (i > 0) {
            DefaultMutableTreeNode node;
            if ((node = (DefaultMutableTreeNode)root.getChildAt(--i)).toString().equals("Network")) {
                model.removeNodeFromParent(node);
                continue;
            }
            if (node.toString().equals("Transport")) {
                model.removeNodeFromParent(node);
                continue;
            }
            if (!node.toString().equals("Services")) continue;
            model.removeNodeFromParent(node);
        }
    }

    private void insertAdvNodes() {
        JTree tree = (JTree)swix.find("id_cfgtree");
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode network = new DefaultMutableTreeNode("Network");
        network.add(new DefaultMutableTreeNode("Rendezvous"));
        network.add(new DefaultMutableTreeNode("Relays"));
        model.insertNodeInto(network, root, root.getChildCount());
        DefaultMutableTreeNode transport = new DefaultMutableTreeNode("Transport");
        transport.add(new DefaultMutableTreeNode("tcp"));
        transport.add(new DefaultMutableTreeNode("http"));
        model.insertNodeInto(transport, root, root.getChildCount());
        DefaultMutableTreeNode services = new DefaultMutableTreeNode("Services");
        services.add(new DefaultMutableTreeNode("Rendezvous Service"));
        services.add(new DefaultMutableTreeNode("Relay Service"));
        services.add(new DefaultMutableTreeNode("Endpoint Service"));
        services.add(new DefaultMutableTreeNode("Proxy Service"));
        model.insertNodeInto(services, root, root.getChildCount());
    }

    private void requestFocus(Component component) {
        component.requestFocus();
    }

    private void disable(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JPanel) {
                this.disable(((JPanel)components[i]).getComponents());
                continue;
            }
            this.disable(components[i]);
        }
    }

    private void disable(Component component) {
        component.setEnabled(false);
    }

    private void enable(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JPanel) {
                this.enable(((JPanel)components[i]).getComponents());
                continue;
            }
            this.enable(components[i]);
        }
    }

    private void enable(Component component) {
        component.setEnabled(true);
    }
}

