/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Iterator;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Default;
import net.jxta.ext.config.Env;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Util {
    private static final String MACRO_PREFIX = "${";
    private static final String MACRO_POSTFIX = "}";
    private static final String MACRO_ESCAPE = "\\";
    private static final String NEW_LINE = "\n";
    private static final String EMPTY_STRING = "";
    private static final Logger LOG = Logger.getLogger((String)Util.class.getName());

    public static String expand(String s) {
        StringBuffer sb = null;
        if (s != null) {
            sb = new StringBuffer(s);
            int i = -1;
            int j = -1;
            while ((i = sb.indexOf(MACRO_PREFIX)) > -1 && (i - MACRO_ESCAPE.length() < 0 || i - MACRO_ESCAPE.length() >= 0 && !sb.substring(i - MACRO_ESCAPE.length(), i).equals(MACRO_ESCAPE)) && (j = sb.indexOf(MACRO_POSTFIX, i + MACRO_PREFIX.length())) > -1) {
                String p = Util.expand(sb.substring(i + MACRO_PREFIX.length(), j));
                sb.replace(i, j + MACRO_POSTFIX.length(), System.getProperty(p, EMPTY_STRING));
            }
        }
        return sb != null ? sb.toString() : null;
    }

    public static String getLocalHost() {
        String s;
        block2: {
            s = null;
            try {
                s = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"can't resolve local host", (Throwable)uhe);
            }
        }
        return s;
    }

    public static String validateAddress(URI address) {
        return Util.validateAddress(address, true);
    }

    public static String validateAddress(URI address, int minimumPort) {
        return Util.validateAddress(address, (String)null, minimumPort);
    }

    public static String validateAddress(URI address, boolean requireHost) {
        return Util.validateAddress(address, (String)null, requireHost);
    }

    public static String validateAddress(URI address, String scheme) {
        return Util.validateAddress(address, scheme, false);
    }

    public static String validateAddress(URI address, String scheme, boolean requireHost) {
        return Util.validateAddress(address, scheme, requireHost, 0);
    }

    public static String validateAddress(URI address, String scheme, int minimumPort) {
        return Util.validateAddress(address, scheme, false, minimumPort);
    }

    public static String validateAddress(URI address, String scheme, boolean requireHost, int minimumPort) {
        StringBuffer b = new StringBuffer();
        if (address != null) {
            if (scheme != null && !address.getScheme().equalsIgnoreCase(scheme)) {
                b.append((b.length() > 0 ? NEW_LINE : EMPTY_STRING) + "invalid scheme: " + scheme);
            }
            if (requireHost) {
                String h = address.getHost();
                if (h == null || h.trim().length() == 0) {
                    b.append((b.length() > 0 ? NEW_LINE : EMPTY_STRING) + "invalid host: " + h);
                }
                if (address.getPort() < minimumPort || address.getPort() > 65535) {
                    b.append((b.length() > 0 ? NEW_LINE : EMPTY_STRING) + "invalid port: " + address.getPort());
                }
            }
        } else {
            b.append((b.length() > 0 ? NEW_LINE : EMPTY_STRING) + "null address");
        }
        return b.toString();
    }

    public static URI normalize(Address address) {
        return Util.normalize(address, true);
    }

    public static URI normalize(Address address, boolean portScan) {
        URI u = address != null ? address.getAddress() : null;
        return Util.normalize(address, portScan, Util.model(u != null ? u.getScheme() : null));
    }

    public static URI normalize(Address address, boolean portScan, URI model) {
        URI u;
        block7: {
            URI uRI = u = address != null ? address.getAddress() : null;
            if (u != null) {
                String s = u.getScheme();
                String h = u.getHost();
                int p = u.getPort();
                if (model != null) {
                    if (s == null || s.trim().length() == 0) {
                        s = model.getScheme();
                    }
                    if (h == null || h.trim().length() == 0) {
                        h = model.getHost();
                    }
                    if (p == -1) {
                        p = model.getPort();
                    }
                }
                try {
                    address.setAddress(new URI(u.getScheme(), u.getUserInfo(), h, p, u.getPath(), u.getQuery(), u.getFragment()));
                    u = new URI(u.getScheme(), u.getUserInfo(), h, portScan ? Util.getNextAvailablePort(address, p) : p, u.getPath(), u.getQuery(), u.getFragment());
                }
                catch (URISyntaxException use) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block7;
                    LOG.error((Object)"invalid transformation", (Throwable)use);
                }
            }
        }
        return u;
    }

    public static URI toURI(String scheme, String host, int port) {
        URI u;
        block2: {
            u = null;
            try {
                u = new URI(scheme, EMPTY_STRING, host == null || host.trim().length() == 0 ? Util.getLocalHost() : host, port, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
            }
            catch (URISyntaxException use) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"invalid transformation", (Throwable)use);
            }
        }
        return u;
    }

    public static URI model(String scheme) {
        return Util.model(scheme, -1);
    }

    public static URI model(String scheme, int port) {
        URI u = null;
        if ("tcp".equalsIgnoreCase(scheme)) {
            u = Util.toURI(Default.ANY_TCP_ADDRESS.getScheme(), null, port != -1 ? port : 9701);
        } else if ("http".equalsIgnoreCase(scheme)) {
            u = Util.toURI(Default.ANY_HTTP_ADDRESS.getScheme(), null, port != -1 ? port : 9700);
        } else if ("udp".equalsIgnoreCase(scheme)) {
            u = Util.toURI(Default.ANY_UDP_ADDRESS.getScheme(), Default.MULTICAST_ADDRESS.getHost(), port != -1 ? port : 1234);
        }
        return u;
    }

    public static boolean isPortAvailable(InetAddress address, int port) {
        boolean isAvailable;
        ServerSocket ss = Util.getServerSocket(address, port);
        boolean bl = isAvailable = ss != null;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        ss = null;
        return isAvailable;
    }

    public static ServerSocket getServerSocket(InetAddress address, int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port, 0, address != null && !address.getHostAddress().equals(Env.ALL_ADDRESSES.getHostAddress()) ? address : null);
        }
        catch (BindException be) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ss;
    }

    public static String getProxyFromUserAgent() {
        String p = null;
        return p;
    }

    public static boolean isNonRoutable(URI u) {
        String a;
        boolean isNonRoutable = false;
        String string = a = u != null ? u.getHost() : null;
        if (a != null) {
            Iterator r = Env.NON_ROUTABLE_ADDRESSES.iterator();
            while (!isNonRoutable && r.hasNext()) {
                if (!a.startsWith((String)r.next())) continue;
                isNonRoutable = true;
            }
        }
        return isNonRoutable;
    }

    public static boolean isMulticast(URI u) {
        InetAddress ia;
        block3: {
            String h = u != null ? u.getHost() : null;
            ia = null;
            if (h != null) {
                try {
                    ia = InetAddress.getByAddress(h, Util.inetAddressToBytes(h));
                }
                catch (UnknownHostException uhe) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                    LOG.error((Object)"invalid address", (Throwable)uhe);
                }
            }
        }
        return ia != null ? ia.isMulticastAddress() : false;
    }

    public static byte[] inetAddressToBytes(String ipAddr) {
        byte[] bytes = new byte[4];
        int bit = 0;
        block3: for (int i = 0; i < ipAddr.length(); ++i) {
            char c = ipAddr.charAt(i);
            switch (c) {
                case '.': {
                    ++bit;
                    continue block3;
                }
                default: {
                    bytes[bit] = (byte)(bytes[bit] * 10 + Character.digit(c, 10));
                }
            }
        }
        return bytes;
    }

    private static int getNextAvailablePort(Address a, int defaultPort) {
        URI u = a != null ? a.getAddress() : null;
        String h = u != null ? u.getHost() : null;
        int p = u != null ? u.getPort() : -1;
        int port = p != -1 ? p : defaultPort;
        int pr = a != null ? a.getPortRange() : 100;
        InetAddress ia = null;
        if (h != null) {
            block5: {
                try {
                    ia = InetAddress.getByAddress(h, Util.inetAddressToBytes(h));
                }
                catch (UnknownHostException uhe) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                    LOG.error((Object)"invalid address", (Throwable)uhe);
                }
            }
            if (ia != null && p != -1) {
                for (int i = p; i <= p + pr; ++i) {
                    if (!Util.isPortAvailable(ia, i)) continue;
                    port = i;
                    break;
                }
            }
        }
        return port;
    }
}

