/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.net.URI;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Default;

public class MulticastAddress
extends Address {
    private boolean isMulticast = true;
    private int size = 16384;

    public MulticastAddress() {
        this(null);
    }

    public MulticastAddress(MulticastAddress ma) {
        super(ma);
        this.setAddress(ma != null ? ma.getAddress() : Default.MULTICAST_ADDRESS);
        this.setMulticast(ma != null ? ma.isMulticast() : true);
        this.setSize(ma != null ? ma.getSize() : 16384);
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public void setMulticast(boolean isMulticast) {
        this.isMulticast = isMulticast;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setAddress(URI multicastAddress) {
        if (multicastAddress != null && !multicastAddress.getScheme().equals(Default.ANY_UDP_ADDRESS.getScheme())) {
            throw new IllegalArgumentException("invalid multicast address: " + multicastAddress);
        }
        super.setAddress(multicastAddress);
    }
}

