/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.exception.ConfiguratorException;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Conversion;
import net.jxta.ext.config.ConversionException;
import net.jxta.ext.config.Default;
import net.jxta.ext.config.Env;
import net.jxta.ext.config.HttpTransport;
import net.jxta.ext.config.ModuleId;
import net.jxta.ext.config.MulticastAddress;
import net.jxta.ext.config.Optimizer;
import net.jxta.ext.config.Profile;
import net.jxta.ext.config.ProxyAddress;
import net.jxta.ext.config.PublicAddress;
import net.jxta.ext.config.Resource;
import net.jxta.ext.config.Tag;
import net.jxta.ext.config.TcpTransport;
import net.jxta.ext.config.TcpTransportAddress;
import net.jxta.ext.config.Trace;
import net.jxta.ext.config.Transport;
import net.jxta.ext.config.Util;
import net.jxta.ext.http.Dispatcher;
import net.jxta.ext.http.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.peergroup.PlatformConfigurator;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Configurator
implements Externalizable,
PlatformConfigurator {
    private static final String COLON = ":";
    private static final String EMPTY_STRING = "";
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final char NULL_CHAR = '\u0000';
    private static final long MAX_WAIT = 7000L;
    private static final Logger LOG = Logger.getLogger((String)Configurator.class.getName());
    private static File HOME = Env.JXTA_HOME;
    private String descriptor;
    private String peerName;
    private String peerDescription;
    private Trace trace;
    private PeerID peerId;
    private boolean isSecurity;
    private String principal;
    private String password;
    private URI rootCertificateAddress;
    private PSEConfigAdv pse;
    private URI peerProxy;
    private URI rendezVousBootstrap;
    private URI relaysBootstrap;
    private boolean isRelaysDiscovery;
    private URI reflectionBootstrap;
    private List transports;
    private RelayConfigAdv relayConfig;
    private int endpointQueueSize;
    private boolean isProxyEnabled;
    private RdvConfigAdv rdvConfig;
    private List optimizers;
    private Map customParams;

    public static File getHome() {
        return HOME;
    }

    public static void setHome(File home) {
        if (home != null) {
            HOME = home;
        }
    }

    public static void setConfigurator(Class configurator) {
        IllegalArgumentException rc = null;
        if (configurator != null && PlatformConfigurator.class.isAssignableFrom(configurator)) {
            try {
                PeerGroupFactory.setConfiguratorClass((Class)configurator);
            }
            catch (Exception e) {
                rc = new IllegalArgumentException("invalid configurator: " + e.getMessage());
                rc.initCause(e);
            }
        } else {
            rc = new IllegalArgumentException("invalid configurator: " + (configurator != null ? configurator.getName() : null));
        }
        if (rc != null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"invalid configurator: ", (Throwable)rc);
            }
            throw rc;
        }
    }

    public static URI toAllAddresses(URI base) {
        URI u;
        block6: {
            u = null;
            URI b = base;
            String a = Env.ALL_ADDRESSES.getHostAddress();
            if (b != null) {
                try {
                    u = new URI(b.getScheme(), EMPTY_STRING, a, b.getPort(), b.getPath(), b.getPath(), b.getFragment());
                }
                catch (URISyntaxException use) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"invalid transformation", (Throwable)use);
                    }
                    break block6;
                }
            }
            try {
                u = new URI(Default.ANY_TCP_ADDRESS.getScheme(), EMPTY_STRING, a, 9701, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
            }
            catch (URISyntaxException use) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                LOG.error((Object)"invalid transformation", (Throwable)use);
            }
        }
        return u;
    }

    public Configurator() {
        this(null, null, null, null);
    }

    public Configurator(String name, String password) {
        this(name, null, name, password);
    }

    public Configurator(String name, String principal, String password) {
        this(name, null, principal, password);
    }

    public Configurator(String name, String description, String principal, String password) {
        Profile p;
        PlatformConfig pc;
        block10: {
            this.descriptor = "unspecified";
            this.peerName = null;
            this.peerDescription = null;
            this.trace = Trace.DEFAULT;
            this.peerId = null;
            this.isSecurity = true;
            this.principal = null;
            this.password = null;
            this.rootCertificateAddress = null;
            this.pse = null;
            this.peerProxy = null;
            this.rendezVousBootstrap = Default.RENDEZVOUS_BOOTSTRAP_ADDRESS;
            this.relaysBootstrap = Default.RELAYS_BOOTSTRAP_ADDRESS;
            this.isRelaysDiscovery = Default.RELAYS_DISCOVERY_IS_ENABLED;
            this.reflectionBootstrap = Default.REFLECTION_BOOTSTRAP_ADDRESS;
            this.transports = null;
            this.relayConfig = null;
            this.endpointQueueSize = 20;
            this.isProxyEnabled = false;
            this.rdvConfig = null;
            this.optimizers = null;
            this.customParams = null;
            this.customParams = new HashMap();
            this.process((PlatformConfig)AdvertisementFactory.newAdvertisement((String)PlatformConfig.getAdvertisementType()));
            this.process(Profile.SEED, true);
            Configurator.setHome(Env.JXTA_HOME);
            pc = null;
            try {
                pc = (PlatformConfig)this.load();
            }
            catch (ConfiguratorException ce) {
                LOG.error((Object)"bad existing configuration");
            }
            File cf = new File(Configurator.getHome(), "profile.xml");
            p = Profile.DEFAULT;
            if (pc == null && cf.exists()) {
                try {
                    p = new Profile(cf.toURL());
                }
                catch (MalformedURLException mue) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block10;
                    LOG.error((Object)"invalid config", (Throwable)mue);
                }
            }
        }
        if (pc != null) {
            this.process(pc);
        } else if (p != null) {
            this.process(p);
        }
        String string = description = description != null && description.trim().length() > 0 ? description.trim() : Default.PEER_DESCRIPTION;
        if (name != null && name.trim().length() > 0) {
            this.setName(name);
        }
        if (description.trim().length() > 0) {
            this.setDescription(description);
        }
        this.setSecurity(principal, password);
        this.setTrace(this.getTrace());
    }

    public Configurator(Profile profile) {
        this.descriptor = "unspecified";
        this.peerName = null;
        this.peerDescription = null;
        this.trace = Trace.DEFAULT;
        this.peerId = null;
        this.isSecurity = true;
        this.principal = null;
        this.password = null;
        this.rootCertificateAddress = null;
        this.pse = null;
        this.peerProxy = null;
        this.rendezVousBootstrap = Default.RENDEZVOUS_BOOTSTRAP_ADDRESS;
        this.relaysBootstrap = Default.RELAYS_BOOTSTRAP_ADDRESS;
        this.isRelaysDiscovery = Default.RELAYS_DISCOVERY_IS_ENABLED;
        this.reflectionBootstrap = Default.REFLECTION_BOOTSTRAP_ADDRESS;
        this.transports = null;
        this.relayConfig = null;
        this.endpointQueueSize = 20;
        this.isProxyEnabled = false;
        this.rdvConfig = null;
        this.optimizers = null;
        this.customParams = null;
        this.customParams = new HashMap();
        this.process((PlatformConfig)AdvertisementFactory.newAdvertisement((String)PlatformConfig.getAdvertisementType()));
        this.process(Profile.SEED, true);
        Configurator.setHome(Env.JXTA_HOME);
        this.process(profile);
    }

    public Configurator(PlatformConfig config) {
        this.descriptor = "unspecified";
        this.peerName = null;
        this.peerDescription = null;
        this.trace = Trace.DEFAULT;
        this.peerId = null;
        this.isSecurity = true;
        this.principal = null;
        this.password = null;
        this.rootCertificateAddress = null;
        this.pse = null;
        this.peerProxy = null;
        this.rendezVousBootstrap = Default.RENDEZVOUS_BOOTSTRAP_ADDRESS;
        this.relaysBootstrap = Default.RELAYS_BOOTSTRAP_ADDRESS;
        this.isRelaysDiscovery = Default.RELAYS_DISCOVERY_IS_ENABLED;
        this.reflectionBootstrap = Default.REFLECTION_BOOTSTRAP_ADDRESS;
        this.transports = null;
        this.relayConfig = null;
        this.endpointQueueSize = 20;
        this.isProxyEnabled = false;
        this.rdvConfig = null;
        this.optimizers = null;
        this.customParams = null;
        this.customParams = new HashMap();
        this.process((PlatformConfig)AdvertisementFactory.newAdvertisement((String)PlatformConfig.getAdvertisementType()));
        this.process(Profile.SEED, true);
        Configurator.setHome(Env.JXTA_HOME);
        this.process(config);
    }

    public ConfigParams load() throws ConfiguratorException {
        return this.load(new File(Configurator.getHome(), "PlatformConfig"));
    }

    /*
     * Loose catch block
     */
    public PlatformConfig load(File loadFile) throws ConfiguratorException {
        PlatformConfig pc;
        block18: {
            FileInputStream advStream;
            block17: {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Reading Platform Config from : " + loadFile.getAbsolutePath()));
                }
                pc = null;
                advStream = null;
                advStream = new FileInputStream(loadFile);
                InputStreamReader advReader = new InputStreamReader((InputStream)advStream, "UTF-8");
                pc = (PlatformConfig)AdvertisementFactory.newAdvertisement((MimeMediaType)MimeMediaType.XMLUTF8, (Reader)advReader);
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block17;
                LOG.debug((Object)("Recovered Platform Config from : " + loadFile.getAbsolutePath()));
            }
            Object var7_7 = null;
            try {
                if (advStream != null) {
                    advStream.close();
                }
                advStream = null;
            }
            catch (Exception ignored) {}
            break block18;
            {
                catch (FileNotFoundException e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Platform Config not found : " + loadFile.getAbsolutePath()));
                    }
                    Object var7_8 = null;
                    try {
                        if (advStream != null) {
                            advStream.close();
                        }
                        advStream = null;
                    }
                    catch (Exception ignored) {}
                    break block18;
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Failed to Recover '" + loadFile.getAbsolutePath() + "' due to : "), (Throwable)e);
                    }
                    try {
                        loadFile.delete();
                    }
                    catch (Exception ex1) {
                        LOG.fatal((Object)"Could not remove bad Configuration file", (Throwable)ex1);
                        throw new ConfiguratorException("Could not remove '" + loadFile.getAbsolutePath() + "'. Remove it by hand before retrying", (Throwable)ex1);
                    }
                    throw new ConfiguratorException("Failed to Recover PlatformConfig", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (advStream != null) {
                        advStream.close();
                    }
                    advStream = null;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return pc;
    }

    public URI getJXTAHome() {
        return Configurator.getHome().toURI();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.peerName;
    }

    public void setName(String name) {
        this.peerName = name != null && name.trim().length() > 0 ? name.trim() : null;
    }

    public String getDescription() {
        return this.peerDescription;
    }

    public void setDescription(String description) {
        this.peerDescription = description != null && description.trim().length() > 0 ? description.trim() : null;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setTrace(Trace trace) {
        if (trace != null) {
            this.trace = trace;
        }
    }

    public PeerID getPeerId() {
        return this.peerId;
    }

    public void setPeerId(PeerID peerId) {
        this.peerId = peerId;
    }

    public boolean isRendezVous() {
        return RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS == this.rdvConfig.getConfiguration();
    }

    public void setRendezVous(boolean isEnabled) {
        this.rdvConfig.setConfiguration(isEnabled ? RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS : RdvConfigAdv.RendezVousConfiguration.EDGE);
    }

    public List getRendezVous() {
        return new ArrayList<URI>(Arrays.asList(this.rdvConfig.getSeedRendezvous()));
    }

    public void setRendezVous(URI rendezVous) throws ConfiguratorException {
        this.setRendezVous(Collections.singletonList(rendezVous));
    }

    public void setRendezVous(List seed) throws ConfiguratorException {
        this.rdvConfig.clearSeedRendezvous();
        this.addRendezVous(seed);
    }

    public void addRendezVous(URI seed) throws ConfiguratorException {
        this.addRendezVous(Collections.singletonList(seed));
    }

    public void addRendezVous(List seed) throws ConfiguratorException {
        Iterator r = seed.iterator();
        while (r.hasNext()) {
            URI u = (URI)r.next();
            if (Util.validateAddress(u, false).trim().length() == 0) {
                this.rdvConfig.addSeedRendezvous(u);
                continue;
            }
            throw new ConfiguratorException("invalid address: " + u);
        }
    }

    public URI removeRendezVous(URI rendezVous) {
        return this.rdvConfig.removeSeedRendezvous(rendezVous) ? rendezVous : null;
    }

    public void clearRendezVous() {
        this.rdvConfig.clearSeedRendezvous();
    }

    public boolean isRendezVousAutoStart() {
        return this.rdvConfig.getAutoRendezvousCheckInterval() != 0L;
    }

    public void setRendezVousAutoStart(boolean isAutoStart) {
    }

    public long getRendezVousAutoStart() {
        return this.rdvConfig.getAutoRendezvousCheckInterval();
    }

    public void setRendezVousAutoStart(long autoStart) {
        this.rdvConfig.setAutoRendezvousCheckInterval(autoStart);
    }

    public boolean isRelay() {
        return this.relayConfig.isClientEnabled() || this.relayConfig.isServerEnabled();
    }

    public void setRelay(boolean isEnabled) {
    }

    public List getRelays() {
        List<EndpointAddress> allSeeds = Arrays.asList(this.relayConfig.getSeedRelays());
        ArrayList<URI> result = new ArrayList<URI>(allSeeds.size());
        Iterator<EndpointAddress> eachSeed = allSeeds.iterator();
        while (eachSeed.hasNext()) {
            try {
                result.add(new URI(eachSeed.next().toString()));
            }
            catch (URISyntaxException ignored) {}
        }
        return result;
    }

    public void setRelay(URI relay) throws ConfiguratorException {
        this.relayConfig.clearSeedRelays();
        this.relayConfig.addSeedRelay(relay.toString());
    }

    public void setRelays(List relays) throws ConfiguratorException {
        this.relayConfig.clearSeedRelays();
        this.addRelays(relays);
    }

    public void addRelay(URI relay) throws ConfiguratorException {
        try {
            this.relayConfig.addSeedRelay(relay.toString());
        }
        catch (Exception all) {
            throw new ConfiguratorException("Bad relay", (Throwable)all);
        }
    }

    public void addRelays(List relays) throws ConfiguratorException {
        Iterator eachRelay = relays.iterator();
        while (eachRelay.hasNext()) {
            this.addRelay((URI)eachRelay.next());
        }
    }

    public URI removeRelay(URI relay) {
        throw new UnsupportedOperationException("this doesn't work");
    }

    public void clearRelays() {
        this.relayConfig.clearSeedRelays();
    }

    public boolean isRelayIncoming() {
        return this.relayConfig.isServerEnabled();
    }

    public void setRelayIncoming(boolean isEnabled) {
        this.relayConfig.setServerEnabled(isEnabled);
    }

    public int getRelayIncomingMaximum() {
        return this.relayConfig.getMaxClients();
    }

    public void setRelayIncomingMaximum(int maximumIncoming) {
        this.relayConfig.setMaxClients(maximumIncoming);
    }

    public long getRelayIncomingLease() {
        return this.relayConfig.getServerLeaseDuration();
    }

    public void setRelayIncomingLease(long incomingLease) {
        this.relayConfig.setServerLeaseDuration(incomingLease);
    }

    public boolean isRelayOutgoing() {
        return this.relayConfig.isClientEnabled();
    }

    public void setRelayOutgoing(boolean isEnabled) {
        this.relayConfig.setClientEnabled(isEnabled);
    }

    public int getRelayOutgoingMaximum() {
        return this.relayConfig.getMaxRelays();
    }

    public void setRelayOutgoingMaximum(int maximumOutgoing) {
        this.relayConfig.setMaxRelays(maximumOutgoing);
    }

    public long getRelayOutgoingLease() {
        return this.relayConfig.getClientLeaseDuration();
    }

    public void setRelayOutgoingLease(long outgoingLease) {
        this.relayConfig.setClientLeaseDuration(outgoingLease);
    }

    public int getRelayQueueSize() {
        return this.relayConfig.getClientMessageQueueSize();
    }

    public void setRelayQueueSize(int queueSize) {
        this.relayConfig.setClientMessageQueueSize(queueSize);
    }

    public List getTransports() {
        return this.transports != null ? (List)((ArrayList)this.transports).clone() : Collections.EMPTY_LIST;
    }

    public void setTransport(Transport transport) {
        ArrayList<Transport> t = new ArrayList<Transport>();
        t.add(transport);
        this.setTransports(t);
    }

    public void setTransports(List transports) {
        if (this.transports != null) {
            this.transports.clear();
        }
        this.addTransports(transports);
    }

    public void addTransport(Transport transport) {
        ArrayList<Transport> t = new ArrayList<Transport>();
        t.add(transport);
        this.addTransports(t);
    }

    public void addTransports(List transports) {
        Iterator i;
        Iterator iterator = i = transports != null ? transports.iterator() : Collections.EMPTY_LIST.iterator();
        while (i.hasNext()) {
            Transport t = (Transport)i.next();
            if (t == null || this.transports != null && this.transports.contains(t)) continue;
            if (this.transports == null) {
                this.transports = new ArrayList();
            }
            this.transports.add(t);
        }
    }

    public Transport removeTransport(Transport transport) {
        int i;
        Object o = null;
        if (this.transports != null && (i = this.transports.indexOf(transport)) > -1) {
            o = this.transports.remove(i);
            if (this.transports.size() == 0) {
                this.transports = null;
            }
        }
        return o;
    }

    public void clearTransports() {
        if (this.transports != null) {
            this.transports.clear();
            this.transports = null;
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isSecurity() {
        return this.isSecurity;
    }

    public void setSecurity(boolean isEnabled) {
        this.isSecurity = isEnabled;
    }

    public void setSecurity(String principal, String password) {
        this.principal = principal != null && principal.trim().length() > 0 ? principal.trim() : null;
        this.password = password != null && password.trim().length() > 0 ? password.trim() : null;
    }

    public URI getRootCertificateAddress() {
        return this.rootCertificateAddress;
    }

    public void setRootCertificateAddress(URI rootCertificateAddress) {
        this.rootCertificateAddress = rootCertificateAddress;
    }

    public Certificate getRootCertificate() {
        return this.pse.getCertificate();
    }

    public String getRootCertificateBase64() {
        String s;
        block2: {
            s = null;
            try {
                s = this.pse.getCert();
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block2;
                LOG.debug((Object)"can't get root cert");
            }
        }
        return s;
    }

    public void setRootCertificate(Certificate rootCertificate) {
        this.pse.setCertificate((X509Certificate)rootCertificate);
    }

    public void setRootCertificateBase64(String rootCertificate) {
        if (rootCertificate != null) {
            this.pse.setCert(rootCertificate);
        }
    }

    public URI getPeerProxyAddress() {
        return this.peerProxy;
    }

    public void setPeerProxyAddress(URI peerProxyAddress) throws ConfiguratorException {
        if (Util.validateAddress(peerProxyAddress, true).trim().length() != 0) {
            throw new ConfiguratorException("invalid proxy", (Throwable)new IllegalArgumentException("invalid proxy uri: " + peerProxyAddress));
        }
        this.peerProxy = peerProxyAddress;
    }

    public int getEndpointOutgoingQueueSize() {
        return this.endpointQueueSize;
    }

    public void setEndpointOutgoingQueueSize(int size) {
        this.endpointQueueSize = size;
    }

    public boolean isProxy() {
        return this.isProxyEnabled;
    }

    public void setProxy(boolean isEnabled) {
        this.isProxyEnabled = isEnabled;
    }

    public URI getRendezVousBootstrapAddress() {
        URI[] u = this.rdvConfig.getSeedingURIs();
        return u.length > 0 ? u[0] : null;
    }

    public void setRendezVousBootstrapAddress(URI rendezVousBootstrapAddress) throws ConfiguratorException {
        if (rendezVousBootstrapAddress != null && Util.validateAddress(rendezVousBootstrapAddress, -1).trim().length() > 0) {
            throw new ConfiguratorException("invalid address: " + rendezVousBootstrapAddress);
        }
        this.rdvConfig.clearSeedingURIs();
        if (rendezVousBootstrapAddress != null) {
            this.rdvConfig.addSeedingURI(rendezVousBootstrapAddress);
        }
    }

    public boolean isRendezVousDiscovery() {
        return !this.rdvConfig.getUseOnlySeeds();
    }

    public void setRendezVousDiscovery(boolean discover) {
        this.rdvConfig.setUseOnlySeeds(!discover);
    }

    public URI getRelaysBootstrapAddress() {
        URI[] u = this.relayConfig.getSeedingURIs();
        return u.length > 0 ? u[0] : null;
    }

    public void setRelaysBootstrapAddress(URI relaysBootstrapAddress) throws ConfiguratorException {
        if (relaysBootstrapAddress != null && Util.validateAddress(relaysBootstrapAddress, -1).trim().length() > 0) {
            throw new ConfiguratorException("invalid address: " + relaysBootstrapAddress);
        }
        this.relayConfig.clearSeedingURIs();
        if (relaysBootstrapAddress != null) {
            this.relayConfig.addSeedingURI(relaysBootstrapAddress);
        }
    }

    public boolean isRelaysDiscovery() {
        return this.isRelaysDiscovery;
    }

    public void setRelayDiscovery(boolean isEnabled) {
        this.isRelaysDiscovery = isEnabled;
    }

    public boolean getRelaysDiscovery() {
        return this.isRelaysDiscovery;
    }

    public void setRelaysDiscovery(boolean isEnabled) {
        this.isRelaysDiscovery = isEnabled;
    }

    public URI getReflectionBootstrapAddress() {
        return this.reflectionBootstrap;
    }

    public void setReflectionBootstrapAddress(URI reflectionBootstrapAddress) throws ConfiguratorException {
        if (reflectionBootstrapAddress != null && Util.validateAddress(reflectionBootstrapAddress, -1).trim().length() > 0) {
            throw new ConfiguratorException("invalid address: " + reflectionBootstrapAddress);
        }
        this.reflectionBootstrap = reflectionBootstrapAddress;
    }

    public PlatformConfig getPlatformConfig() throws ConfiguratorException {
        this.normalize();
        this.optimize();
        this.validate();
        return this.constructPlatformConfig();
    }

    public ConfigParams getConfigParams() throws ConfiguratorException {
        return this.getPlatformConfig();
    }

    public void setPlatformConfig(PlatformConfig pc) {
        this.process(pc);
    }

    public void setConfigParams(ConfigParams pc) {
        this.setPlatformConfig((PlatformConfig)pc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List fetchBootstrapAddresses(URI u) throws IOException {
        ArrayList<URI> arrayList;
        ArrayList<URI> r;
        block17: {
            URL url;
            block16: {
                r = null;
                url = null;
                if (u != null) {
                    try {
                        url = u.toURL();
                    }
                    catch (MalformedURLException mue) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block16;
                        LOG.error((Object)"invalid location", (Throwable)mue);
                    }
                }
            }
            if (url != null) {
                String s;
                Message results = null;
                try {
                    results = new Dispatcher(url, 7000L).dispatch();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                String string = s = results != null ? results.getBody() : null;
                if (s != null) {
                    r = new ArrayList<URI>();
                    StreamTokenizer st = new StreamTokenizer(new StringReader(s));
                    st.wordChars(32, 126);
                    st.eolIsSignificant(true);
                    try {
                        block11: while (st.nextToken() != -1) {
                            switch (st.ttype) {
                                case -3: {
                                    try {
                                        r.add(new URI(st.sval.trim()));
                                    }
                                    catch (URISyntaxException use) {
                                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue block11;
                                        LOG.error((Object)"invalid uri", (Throwable)use);
                                    }
                                    continue block11;
                                }
                            }
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block17;
                        LOG.error((Object)"invalid uri tokenizer", (Throwable)ioe);
                    }
                }
            }
        }
        if (r != null) {
            arrayList = r;
            return arrayList;
        }
        arrayList = Collections.EMPTY_LIST;
        return arrayList;
    }

    public Iterator getOptimizers() {
        return this.optimizers != null ? this.optimizers.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public void addOptimizer(Optimizer optimizer) {
        if (optimizer != null) {
            if (this.optimizers == null) {
                this.optimizers = new ArrayList();
            }
            this.optimizers.add(optimizer);
        }
    }

    public void addOptimizers(List optimizers) {
        Iterator o;
        Iterator iterator = o = optimizers != null ? optimizers.iterator() : Collections.EMPTY_LIST.iterator();
        while (o.hasNext()) {
            this.addOptimizer((Optimizer)o.next());
        }
    }

    public Class removeOptimizer(Optimizer optimizer) {
        int i;
        Object o = null;
        if (this.optimizers != null && (i = this.optimizers.indexOf(optimizer)) > -1) {
            o = this.optimizers.remove(i);
        }
        return o;
    }

    public void clearOptimizers() {
        if (this.optimizers != null) {
            this.optimizers.clear();
        }
    }

    public void setReconfigure(boolean reconfigure) {
        File f = new File(Configurator.getHome(), "reconf");
        try {
            if (reconfigure) {
                new FileOutputStream(f).close();
            } else {
                f.delete();
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.info((Object)("can't access reconfigure file: " + f));
        }
        catch (IOException ioe) {
            LOG.info((Object)("can't access reconfigure file: " + f));
        }
    }

    public boolean isReconfigure() {
        File f = new File(Configurator.getHome(), "reconf");
        return f.exists();
    }

    public boolean save() throws ConfiguratorException {
        return this.save(new File(Configurator.getHome(), "PlatformConfig"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean save(File platformConfig) throws ConfiguratorException {
        IOException e;
        String s;
        boolean isSaved;
        block22: {
            PlatformConfig pc = this.getPlatformConfig();
            isSaved = false;
            if (platformConfig.getParent() == null) {
                platformConfig = new File(Configurator.getHome(), platformConfig.getName());
            }
            if (platformConfig.isDirectory()) {
                platformConfig = new File(platformConfig, "PlatformConfig");
            }
            platformConfig.getParentFile().mkdirs();
            FileOutputStream os = null;
            s = null;
            e = null;
            os = new FileOutputStream(platformConfig);
            pc.getDocument(MimeMediaType.XMLUTF8).sendToStream((OutputStream)os);
            isSaved = true;
            Object var9_7 = null;
            try {
                if (os != null) {
                    os.close();
                }
                break block22;
            }
            catch (IOException ioe2) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"can't close config file", (Throwable)ioe2);
                }
                break block22;
            }
            {
                catch (FileNotFoundException fnfe) {
                    s = "can't open config file";
                    e = fnfe;
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"can't open config file", (Throwable)fnfe);
                    }
                    Object var9_8 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block22;
                    }
                    catch (IOException ioe2) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"can't close config file", (Throwable)ioe2);
                        }
                        break block22;
                    }
                }
                catch (IOException ioe) {
                    s = "can't write config file";
                    e = ioe;
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"can't write config file", (Throwable)ioe);
                    }
                    Object var9_9 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block22;
                    }
                    catch (IOException ioe2) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"can't close config file", (Throwable)ioe2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Object var9_10 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block23;
                        LOG.error((Object)"can't close config file", (Throwable)ioe2);
                    }
                }
                throw throwable;
            }
        }
        if (s != null || e != null) {
            throw new ConfiguratorException(s, (Throwable)e);
        }
        return isSaved;
    }

    public void writeExternal(ObjectOutput out) {
    }

    public void readExternal(ObjectInput in) {
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getLocalHost() {
        return Util.getLocalHost();
    }

    protected boolean transportsContainsScheme(String scheme) {
        boolean contains = false;
        if (scheme != null) {
            Iterator i = this.getTransports().iterator();
            while (i.hasNext() && !contains) {
                if (!((Transport)i.next()).getScheme().equalsIgnoreCase(scheme)) continue;
                contains = true;
            }
        }
        return contains;
    }

    private void process(PlatformConfig platformConfig) {
        this.setName(platformConfig != null ? platformConfig.getName() : null);
        this.setDescription(platformConfig != null ? platformConfig.getDescription() : null);
        this.setPeerId(platformConfig != null ? platformConfig.getPeerID() : null);
        this.setTrace(platformConfig != null ? Trace.get(platformConfig.getDebugLevel()) : Trace.DEFAULT);
        this.setPse((ConfigParams)platformConfig);
        this.setRdv((ConfigParams)platformConfig);
        this.setRelay((ConfigParams)platformConfig);
        this.setTcp((ConfigParams)platformConfig);
        this.setHttp((ConfigParams)platformConfig);
        this.setEndpoint((ConfigParams)platformConfig);
        this.setProxy((ConfigParams)platformConfig);
        this.setCustomParams(platformConfig);
    }

    private void setPse(ConfigParams pc) {
        StructuredDocument d = pc != null ? pc.getServiceParam((ID)ModuleId.MEMBERSHIP.getId()) : null;
        this.pse = (PSEConfigAdv)(d != null ? AdvertisementFactory.newAdvertisement((TextElement)((TextElement)d)) : AdvertisementFactory.newAdvertisement((String)PSEConfigAdv.getAdvertisementType()));
    }

    private void setRdv(ConfigParams pc) {
        XMLDocument d = (XMLDocument)(pc != null ? pc.getServiceParam((ID)ModuleId.RENDEZVOUS.getId()) : null);
        try {
            if (null != d) {
                d.addAttribute("type", RdvConfigAdv.getAdvertisementType());
                this.rdvConfig = (RdvConfigAdv)AdvertisementFactory.newAdvertisement((TextElement)d);
                d = null;
            }
        }
        catch (NoSuchElementException notRdvConfigAdv) {
            // empty catch block
        }
        if (null == this.rdvConfig) {
            this.rdvConfig = (RdvConfigAdv)AdvertisementFactory.newAdvertisement((String)RdvConfigAdv.getAdvertisementType());
            this.rdvConfig.setConfiguration(RdvConfigAdv.RendezVousConfiguration.EDGE);
            this.rdvConfig.setUseOnlySeeds(!Default.RENDEZVOUS_DISCOVERY_IS_ENABLED);
        }
        if (null != d) {
            Attribute a = d.getAttribute(Tag.FLAGS.toString());
            String v = a != null ? a.getValue() : null;
            this.rdvConfig.setUseOnlySeeds(v != null && v.indexOf(Tag.NO_DISCOVERY.toString()) != -1);
            Enumeration e = null;
            e = d.getChildren(Tag.ADDRESS.toString());
            while (e.hasMoreElements()) {
                String s = ((TextElement)e.nextElement()).getTextValue().trim();
                if (s.length() <= 0) continue;
                this.rdvConfig.addSeedRendezvous(s);
            }
            e = d.getChildren(Tag.RENDEZVOUS.toString());
            this.rdvConfig.setConfiguration(e.hasMoreElements() && Boolean.valueOf(((TextElement)e.nextElement()).getTextValue().trim()) != false ? RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS : RdvConfigAdv.RendezVousConfiguration.EDGE);
        }
    }

    private void setRelay(ConfigParams pc) {
        XMLDocument d = (XMLDocument)(pc != null ? pc.getServiceParam((ID)ModuleId.RELAY.getId()) : null);
        try {
            if (null != d) {
                d.addAttribute("type", RelayConfigAdv.getAdvertisementType());
                this.relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement((TextElement)d);
                d = null;
            }
        }
        catch (NoSuchElementException notRelayConfigAdv) {
            // empty catch block
        }
        if (null == this.relayConfig) {
            this.relayConfig = (RelayConfigAdv)AdvertisementFactory.newAdvertisement((String)RelayConfigAdv.getAdvertisementType());
            this.relayConfig.setClientEnabled(false);
            this.relayConfig.setServerEnabled(false);
        }
        if (d != null) {
            String val;
            long l;
            int i;
            Enumeration e;
            block36: {
                block35: {
                    String s;
                    e = null;
                    e = d.getChildren(Tag.TCP_ADDRESS.toString());
                    while (e.hasMoreElements()) {
                        s = ((TextElement)e.nextElement()).getTextValue().trim();
                        if (s.length() <= 0) continue;
                        try {
                            this.addRelay(new URI("tcp://" + s));
                        }
                        catch (URISyntaxException use) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                            LOG.error((Object)"invalid tcp relay address", (Throwable)use);
                        }
                        catch (ConfiguratorException ce) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                            LOG.error((Object)"invalid relay address", (Throwable)ce);
                        }
                    }
                    e = d.getChildren(Tag.HTTP_ADDRESS.toString());
                    while (e.hasMoreElements()) {
                        s = ((TextElement)e.nextElement()).getTextValue().trim();
                        if (s.length() <= 0) continue;
                        try {
                            this.addRelay(new URI("http://" + s));
                        }
                        catch (URISyntaxException use) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                            LOG.error((Object)"invalid http relay address", (Throwable)use);
                        }
                        catch (ConfiguratorException ce) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                            LOG.error((Object)"invalid rdv address", (Throwable)ce);
                        }
                    }
                    e = d.getChildren(Tag.IS_SERVER.toString());
                    this.setRelayIncoming(e.hasMoreElements() && Boolean.valueOf(((TextElement)e.nextElement()).getTextValue().trim()) != false);
                    e = d.getChildren(Tag.IS_CLIENT.toString());
                    this.setRelayOutgoing(e.hasMoreElements() && Boolean.valueOf(((TextElement)e.nextElement()).getTextValue().trim()) != false);
                    e = d.getChildren(Tag.MAXIMUM_INCOMING.toString());
                    i = 100;
                    if (e.hasMoreElements()) {
                        try {
                            String val2 = ((TextElement)e.nextElement()).getTextValue();
                            if (val2 != null) {
                                i = Integer.parseInt(val2.trim());
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block35;
                            LOG.error((Object)"invalid maximum incoming", (Throwable)nfe);
                        }
                    }
                }
                this.setRelayIncomingMaximum(i);
                e = d.getChildren(Tag.INCOMING_LEASE.toString());
                l = 0x6DDD00L;
                if (e.hasMoreElements()) {
                    try {
                        val = ((TextElement)e.nextElement()).getTextValue();
                        if (val != null) {
                            l = Long.parseLong(val.trim()) * 1000L;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block36;
                        LOG.error((Object)"invalid incoming lease", (Throwable)nfe);
                    }
                }
            }
            this.setRelayIncomingLease(l);
            e = d.getChildren(Tag.MAXIMUM_OUTGOING.toString());
            i = 1;
            if (e.hasMoreElements()) {
                try {
                    val = ((TextElement)e.nextElement()).getTextValue();
                    if (val != null) {
                        i = Integer.parseInt(val.trim());
                    }
                }
                catch (NumberFormatException nfe) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"invalid lease", (Throwable)nfe);
                    }
                    i = 0;
                }
            }
            this.setRelayOutgoingMaximum(i);
            e = d.getChildren(Tag.QUEUE_SIZE.toString());
            i = 20;
            if (e.hasMoreElements()) {
                try {
                    i = Integer.parseInt(((TextElement)e.nextElement()).getTextValue().trim());
                }
                catch (NumberFormatException nfe) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"invalid queue size", (Throwable)nfe);
                    }
                    i = 0;
                }
            }
            this.setRelayQueueSize(i);
            e = d.getChildren(Tag.OUTGOING_LEASE.toString());
            l = 0x6DDD00L;
            if (e.hasMoreElements()) {
                try {
                    val = ((TextElement)e.nextElement()).getTextValue();
                    if (val != null) {
                        l = Long.parseLong(val.trim()) * 1000L;
                    }
                }
                catch (NumberFormatException nfe) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"invalid outgoing lease", (Throwable)nfe);
                    }
                    l = 0L;
                }
            }
            this.setRelayOutgoingLease(l);
        }
    }

    private void setTcp(ConfigParams pc) {
        Enumeration c;
        StructuredDocument d = pc != null ? pc.getServiceParam((ID)ModuleId.TCP.getId()) : null;
        Enumeration enumeration = c = d != null ? d.getChildren((Object)TransportAdvertisement.getAdvertisementType()) : null;
        if (c != null) {
            URI u;
            TcpTransport transport;
            TCPAdv tcp;
            block5: {
                tcp = (TCPAdv)(c != null && c.hasMoreElements() ? AdvertisementFactory.newAdvertisement((TextElement)((TextElement)c.nextElement())) : AdvertisementFactory.newAdvertisement((String)TCPAdv.getAdvertisementType()));
                tcp.setProtocol(Default.ANY_TCP_ADDRESS.getScheme());
                tcp.setConfigMode("auto");
                transport = new TcpTransport();
                Enumeration e = d != null ? d.getChildren((Object)Tag.IS_ENABLED.toString()) : null;
                transport.setEnabled(e != null && !e.hasMoreElements());
                transport.setIncoming(tcp.isServerEnabled());
                transport.setOutgoing(tcp.isClientEnabled());
                TcpTransportAddress address = new TcpTransportAddress();
                String a = tcp.getInterfaceAddress();
                int p = tcp.getStartPort();
                int ep = tcp.getEndPort();
                int r = (ep >= p ? ep : p) - p;
                u = this.makeAddress("tcp://", a, p);
                address.setAddress(u);
                address.setPortRange(r);
                MulticastAddress multicast = new MulticastAddress();
                u = null;
                a = tcp.getMulticastAddr();
                p = tcp.getMulticastPort();
                u = this.makeAddress("udp://", a, p);
                multicast.setMulticast(tcp.getMulticastState());
                multicast.setSize(tcp.getMulticastSize());
                multicast.setAddress(u);
                address.setMulticastAddress(multicast);
                transport.setAddress(address);
                u = null;
                a = tcp.getServer();
                if (a != null && a.trim().length() > 0) {
                    try {
                        u = new URI("tcp://" + a.trim());
                    }
                    catch (URISyntaxException use) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                        LOG.error((Object)"invalid tcp public address", (Throwable)use);
                    }
                }
            }
            if (u != null) {
                PublicAddress pa = new PublicAddress();
                pa.setExclusive(tcp.getPublicAddressOnly());
                pa.setAddress(u);
                transport.setPublicAddress(pa);
            }
            this.addTransport(transport);
        }
    }

    private void setHttp(ConfigParams pc) {
        Enumeration c;
        StructuredDocument d = pc != null ? pc.getServiceParam((ID)ModuleId.HTTP.getId()) : null;
        Enumeration enumeration = c = d != null ? d.getChildren((Object)TransportAdvertisement.getAdvertisementType()) : null;
        if (c != null) {
            URI u;
            HttpTransport transport;
            HTTPAdv http;
            block5: {
                http = (HTTPAdv)(d != null && c != null && c.hasMoreElements() ? AdvertisementFactory.newAdvertisement((TextElement)((TextElement)c.nextElement())) : AdvertisementFactory.newAdvertisement((String)HTTPAdv.getAdvertisementType()));
                http.setProtocol(Default.ANY_HTTP_ADDRESS.getScheme());
                http.setConfigMode("auto");
                transport = new HttpTransport();
                Enumeration e = d != null ? d.getChildren((Object)Tag.IS_ENABLED.toString()) : null;
                transport.setEnabled(e != null && !e.hasMoreElements());
                transport.setIncoming(http.isServerEnabled());
                transport.setOutgoing(http.isClientEnabled());
                Address address = new Address();
                u = null;
                String a = http.getInterfaceAddress();
                int p = http.getPort();
                u = this.makeAddress("http://", a, p);
                address.setAddress(u);
                address.setPortRange(100);
                transport.setAddress(address);
                u = null;
                a = http.getServer();
                if (a != null && a.trim().length() > 0) {
                    try {
                        u = new URI("http://" + a.trim());
                    }
                    catch (URISyntaxException use) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                        LOG.error((Object)"invalid http public address", (Throwable)use);
                    }
                }
            }
            if (u != null) {
                PublicAddress pa = new PublicAddress();
                pa.setExclusive(http.getPublicAddressOnly());
                pa.setAddress(u);
                transport.setPublicAddress(pa);
            }
            this.addTransport(transport);
        }
    }

    private void setEndpoint(ConfigParams pc) {
        StructuredDocument d;
        StructuredDocument structuredDocument = d = pc != null ? pc.getServiceParam((ID)ModuleId.ENDPOINT.getId()) : null;
        if (d != null) {
            int i;
            block5: {
                Enumeration e = d.getChildren((Object)Tag.ENDPOINT_QUEUE_SIZE.toString());
                i = 20;
                if (e.hasMoreElements()) {
                    try {
                        i = Integer.parseInt(((TextElement)e.nextElement()).getTextValue().trim());
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                        LOG.error((Object)"invalid messenger queue size", (Throwable)nfe);
                    }
                }
            }
            this.setEndpointOutgoingQueueSize(i);
        } else {
            this.setEndpointOutgoingQueueSize(20);
        }
    }

    private void setProxy(ConfigParams pc) {
        StructuredDocument d;
        StructuredDocument structuredDocument = d = pc != null ? pc.getServiceParam((ID)ModuleId.PROXY.getId()) : null;
        if (d != null) {
            Enumeration e = d.getChildren((Object)Tag.IS_ENABLED.toString());
            this.setProxy(!e.hasMoreElements());
        } else {
            this.setProxy(false);
        }
    }

    private void process(Profile profile) {
        this.process(profile, false);
    }

    private void process(Profile profile, boolean overlay) {
        if (profile != null) {
            String rs;
            Iterator r;
            boolean b;
            URI a;
            Resource p;
            block125: {
                block124: {
                    block123: {
                        String s;
                        block122: {
                            block121: {
                                block120: {
                                    block119: {
                                        block116: {
                                            block115: {
                                                p = profile.getProfile();
                                                this.setName(p.get("/jxta/peer/@name", overlay ? Default.PEER_NAME : this.getName()));
                                                s = p.get("/jxta/peer/@id", EMPTY_STRING).trim();
                                                if (s.trim().length() > 0) {
                                                    try {
                                                        this.setPeerId((PeerID)IDFactory.fromURI((URI)new URI(s)));
                                                    }
                                                    catch (URISyntaxException use) {
                                                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block115;
                                                        LOG.error((Object)"invalid peer id", (Throwable)use);
                                                    }
                                                }
                                            }
                                            this.setDescriptor(p.get("/jxta/peer/@descriptor", overlay ? Default.PEER_NAME : this.getDescriptor()));
                                            a = null;
                                            try {
                                                a = p.getURI("/jxta/peer/@home", overlay ? Default.HOME_ADDRESS : (HOME != null ? HOME.toURI() : null));
                                            }
                                            catch (ConversionException ce) {
                                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block116;
                                                LOG.error((Object)"invalid home address", (Throwable)ce);
                                            }
                                        }
                                        if (a != null) {
                                            File f;
                                            block118: {
                                                block117: {
                                                    f = null;
                                                    try {
                                                        f = new File(a);
                                                    }
                                                    catch (IllegalArgumentException iae) {
                                                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block117;
                                                        LOG.error((Object)"invalid home address", (Throwable)iae);
                                                    }
                                                }
                                                if (f == null) {
                                                    try {
                                                        f = Conversion.toFile(a);
                                                    }
                                                    catch (ConversionException ce) {
                                                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block118;
                                                        LOG.error((Object)"invalid home address", (Throwable)ce);
                                                    }
                                                }
                                            }
                                            if (f != null) {
                                                Configurator.setHome(f);
                                            }
                                        }
                                        this.setTrace(Trace.get(p.get("/jxta/peer/@trace", overlay ? Trace.DEFAULT.toString() : this.getTrace().toString())));
                                        this.setDescription(p.get("/jxta/peer/description", overlay ? Default.PEER_DESCRIPTION : this.getDescription()));
                                        b = p.contains("/jxta/peer/security/@enabled");
                                        this.setSecurity(b ? p.getBoolean("/jxta/peer/security/@enabled") : (overlay ? true : this.isSecurity()));
                                        this.setSecurity(p.get("/jxta/peer/security/@principal", overlay ? Default.PRINCIPAL : this.getPrincipal()), Default.PASSWORD);
                                        try {
                                            this.setRootCertificateAddress(p.getURI("/jxta/peer/rootCert/@address", overlay ? null : this.getRootCertificateAddress()));
                                        }
                                        catch (ConversionException ce) {
                                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block119;
                                            LOG.warn((Object)"root certificate address", (Throwable)ce);
                                        }
                                    }
                                    this.setRootCertificateBase64(p.get("/jxta/peer/rootCert", overlay ? Default.ROOT_CERTIFICATE : this.getRootCertificateBase64()));
                                    a = null;
                                    try {
                                        a = p.getURI("/jxta/peer/proxy", this.getPeerProxyAddress());
                                    }
                                    catch (ConversionException cve) {
                                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block120;
                                        LOG.error((Object)"invalid peer proxy address conversion", (Throwable)cve);
                                    }
                                }
                                if (a != null) {
                                    try {
                                        this.setPeerProxyAddress(a);
                                    }
                                    catch (ConfiguratorException cfe) {
                                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block121;
                                        LOG.error((Object)"invalid peer proxy address", (Throwable)cfe);
                                    }
                                }
                            }
                            s = p.get("/jxta/network/rendezVous/@bootstrap");
                            try {
                                this.setRendezVousBootstrapAddress(p.getURI("/jxta/network/rendezVous/@bootstrap", overlay ? Default.RENDEZVOUS_BOOTSTRAP_ADDRESS : (s == null ? this.getRendezVousBootstrapAddress() : null)));
                            }
                            catch (ConversionException ce) {
                                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                    LOG.info((Object)"invalid rendezVous bootstrap", (Throwable)ce);
                                }
                            }
                            catch (ConfiguratorException ce) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block122;
                                LOG.error((Object)"invalid rdv bootstrap address", (Throwable)ce);
                            }
                        }
                        b = p.contains("/jxta/network/rendezVous/@discovery");
                        this.setRendezVousDiscovery(b ? p.getBoolean("/jxta/network/rendezVous/@discovery") : (overlay ? Default.RENDEZVOUS_DISCOVERY_IS_ENABLED : this.isRendezVousDiscovery()));
                        if (p.contains("/jxta/network/rendezVous/address") && !overlay) {
                            this.clearRendezVous();
                        }
                        r = p.getAll("/jxta/network/rendezVous/address").iterator();
                        while (r.hasNext()) {
                            rs = ((String)r.next()).trim();
                            if (rs.length() <= 0) continue;
                            try {
                                this.addRendezVous(new URI(rs));
                            }
                            catch (URISyntaxException use) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                                LOG.error((Object)"invalid rendezVous address", (Throwable)use);
                            }
                            catch (ConfiguratorException ce) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                                LOG.error((Object)"invalid rdv address", (Throwable)ce);
                            }
                        }
                        s = p.get("/jxta/network/relays/@bootstrap");
                        try {
                            this.setRelaysBootstrapAddress(p.getURI("/jxta/network/relays/@bootstrap", overlay ? Default.RELAYS_BOOTSTRAP_ADDRESS : (s == null ? this.getRelaysBootstrapAddress() : null)));
                        }
                        catch (ConversionException ce) {
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"invalid relay bootstrap", (Throwable)ce);
                            }
                        }
                        catch (ConfiguratorException ce) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block123;
                            LOG.error((Object)"invalid rly bootstrap address", (Throwable)ce);
                        }
                    }
                    b = p.contains("/jxta/network/relays/@discovery");
                    this.setRelaysDiscovery(b ? p.getBoolean("/jxta/network/relays/@discovery") : (overlay ? Default.RELAYS_DISCOVERY_IS_ENABLED : this.isRelaysDiscovery()));
                    if (p.contains("/jxta/network/relays/address") && !overlay) {
                        this.clearRelays();
                    }
                    try {
                        this.setReflectionBootstrapAddress(p.getURI("/jxta/network/reflection/@bootstrap", overlay ? Default.REFLECTION_BOOTSTRAP_ADDRESS : this.getReflectionBootstrapAddress()));
                    }
                    catch (ConversionException ce) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)"invalid reflection bootstrap", (Throwable)ce);
                        }
                    }
                    catch (ConfiguratorException ce) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block124;
                        LOG.error((Object)"invalid reflection bootstrap address", (Throwable)ce);
                    }
                }
                try {
                    this.setReflectionBootstrapAddress(p.getURI("/jxta/network/reflection/@bootstrap", overlay ? Default.REFLECTION_BOOTSTRAP_ADDRESS : this.getReflectionBootstrapAddress()));
                }
                catch (ConversionException ce) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)"invalid reflection bootstrap", (Throwable)ce);
                    }
                }
                catch (ConfiguratorException ce) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block125;
                    LOG.error((Object)"invalid reflection bootstrap address", (Throwable)ce);
                }
            }
            r = p.getAll("/jxta/network/relays/address").iterator();
            while (r.hasNext()) {
                rs = ((String)r.next()).trim();
                if (rs.length() <= 0) continue;
                try {
                    this.addRelay(new URI(rs));
                }
                catch (URISyntaxException use) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                    LOG.error((Object)"invalid relay address", (Throwable)use);
                }
                catch (ConfiguratorException ce) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                    LOG.error((Object)"invalid relay address", (Throwable)ce);
                }
            }
            if (!overlay) {
                this.clearTransports();
            }
            if (p.contains("/jxta/transport/tcp")) {
                TcpTransport tcp;
                block130: {
                    block129: {
                        TcpTransportAddress tcpAddress;
                        block128: {
                            MulticastAddress multicast;
                            block127: {
                                tcp = new TcpTransport();
                                tcp.setEnabled(p.getBoolean("/jxta/transport/tcp/@enabled", true));
                                tcp.setIncoming(p.getBoolean("/jxta/transport/tcp/incoming/@enabled", true));
                                tcp.setOutgoing(p.getBoolean("/jxta/transport/tcp/@enabled", true));
                                tcpAddress = new TcpTransportAddress();
                                a = null;
                                try {
                                    a = p.getURI("/jxta/transport/tcp/address");
                                }
                                catch (ConversionException cve) {
                                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                                        LOG.error((Object)"invalid tcp address conversion", (Throwable)cve);
                                    }
                                    a = Default.TCP_ADDRESS;
                                }
                                if (a != null && a.toString().trim().length() > 0 && a.getScheme().equals("tcp")) {
                                    block126: {
                                        if (a.getPort() == -1) {
                                            try {
                                                a = new URI(a.getScheme(), a.getUserInfo(), a.getHost(), 9701, a.getPath(), a.getQuery(), a.getFragment());
                                            }
                                            catch (URISyntaxException use) {
                                                a = null;
                                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block126;
                                                LOG.error((Object)"invalid tcp address transformation", (Throwable)use);
                                            }
                                        }
                                    }
                                    tcpAddress.setAddress(a);
                                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)"address scheme incompatibility");
                                }
                                tcpAddress.setPortRange(p.getInt("/jxta/transport/tcp/address/@range", 100));
                                multicast = new MulticastAddress();
                                multicast.setMulticast(p.getBoolean("/jxta/transport/tcp/address/multicast/@enabled", true));
                                multicast.setSize(p.getInt("/jxta/transport/tcp/address/multicast/@size", 16384));
                                try {
                                    multicast.setAddress(p.getURI("/jxta/transport/tcp/address/multicast", Default.MULTICAST_ADDRESS));
                                }
                                catch (ConversionException cve) {
                                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                                        LOG.error((Object)"invalid multicast address conversion", (Throwable)cve);
                                    }
                                }
                                catch (IllegalArgumentException iae) {
                                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block127;
                                    LOG.error((Object)"invalid multicast address", (Throwable)iae);
                                }
                            }
                            tcpAddress.setMulticastAddress(multicast);
                            tcp.setAddress(tcpAddress);
                            PublicAddress publicAddress = new PublicAddress();
                            publicAddress.setExclusive(p.getBoolean("/jxta/transport/tcp/publicAddress/@exclusive", false));
                            a = null;
                            try {
                                a = p.getURI("/jxta/transport/tcp/publicAddress");
                            }
                            catch (ConversionException cve) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block128;
                                LOG.error((Object)"invalid public tcp address conversion", (Throwable)cve);
                            }
                        }
                        if (a != null && a.toString().trim().length() > 0 && tcpAddress != null && tcpAddress.getAddress() != null && a.getScheme().equals(tcpAddress.getAddress().getScheme())) {
                            PublicAddress pa = new PublicAddress();
                            pa.setExclusive(p.getBoolean("/jxta/transport/tcp/publicAddress/@exclusive", false));
                            pa.setAddress(a);
                            tcp.setPublicAddress(pa);
                        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"address and public address scheme incompatibility");
                        }
                        a = null;
                        try {
                            a = p.getURI("/jxta/transport/tcp/proxy");
                        }
                        catch (ConversionException ce) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block129;
                            LOG.error((Object)"invalid tcp proxy address", (Throwable)ce);
                        }
                    }
                    if (a != null) {
                        if (a.getScheme() == null) {
                            a = Default.ANY_TCP_ADDRESS.resolve(a);
                        }
                        if (!a.getScheme().equalsIgnoreCase(Default.ANY_TCP_ADDRESS.getScheme())) {
                            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                                LOG.error((Object)("invalid tcp address: " + a.toString()));
                            }
                            a = null;
                        }
                        if (a != null) {
                            if (a.getHost() == null) {
                                a = null;
                            }
                            if (a != null && a.getPort() == -1) {
                                try {
                                    a = new URI(a.getScheme(), a.getUserInfo(), a.getHost(), 8081, a.getPath(), a.getQuery(), a.getFragment());
                                }
                                catch (URISyntaxException use) {
                                    a = null;
                                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block130;
                                    LOG.error((Object)"invalid tcp proxy transformation", (Throwable)use);
                                }
                            }
                        }
                    }
                }
                if (a != null) {
                    ProxyAddress proxy = new ProxyAddress();
                    proxy.setEnabled(p.getBoolean("/jxta/transport/tcp/proxy/@enabled", false));
                    proxy.setAddress(a);
                    tcp.setProxyAddress(proxy);
                }
                this.addTransport(tcp);
            }
            if (p.contains("/jxta/transport/http")) {
                HttpTransport http;
                block134: {
                    block133: {
                        Address httpAddress;
                        block132: {
                            http = new HttpTransport();
                            http.setEnabled(p.getBoolean("/jxta/transport/http/@enabled", true));
                            http.setIncoming(p.getBoolean("/jxta/transport/http/incoming/@enabled", false));
                            http.setOutgoing(p.getBoolean("/jxta/transport/http/outgoing/@enabled", true));
                            httpAddress = new Address();
                            a = null;
                            try {
                                a = p.getURI("/jxta/transport/http/address");
                            }
                            catch (ConversionException cve) {
                                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                                    LOG.error((Object)"invalid http address conversion", (Throwable)cve);
                                }
                                a = Default.HTTP_ADDRESS;
                            }
                            if (a != null && a.toString().trim().length() > 0 && a.getScheme() != null && a.getScheme().equals("http")) {
                                block131: {
                                    if (a.getPort() == -1) {
                                        try {
                                            a = new URI(a.getScheme(), a.getUserInfo(), a.getHost(), 9700, a.getPath(), a.getQuery(), a.getFragment());
                                        }
                                        catch (URISyntaxException use) {
                                            a = null;
                                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block131;
                                            LOG.error((Object)"invalid http address transformation", (Throwable)use);
                                        }
                                    }
                                }
                                httpAddress.setAddress(a);
                            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)"address scheme incompatibility");
                            }
                            httpAddress.setPortRange(p.getInt("/jxta/transport/http/address/@range", 100));
                            http.setAddress(httpAddress);
                            a = null;
                            try {
                                a = p.getURI("/jxta/transport/http/publicAddress");
                            }
                            catch (ConversionException cve) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block132;
                                LOG.error((Object)"invalid public http address conversion", (Throwable)cve);
                            }
                        }
                        if (a != null && a.toString().trim().length() > 0 && httpAddress != null && httpAddress.getAddress() != null && a.getScheme() != null && a.getScheme().equals(httpAddress.getAddress().getScheme())) {
                            PublicAddress pa = new PublicAddress();
                            pa.setExclusive(p.getBoolean("/jxta/transport/http/publicAddress/@exclusive", false));
                            pa.setAddress(a);
                            http.setPublicAddress(pa);
                        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"address and public address scheme incompatibility");
                        }
                        a = null;
                        try {
                            a = p.getURI("/jxta/transport/http/proxy");
                        }
                        catch (ConversionException ce) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block133;
                            LOG.error((Object)"invalid http proxy address", (Throwable)ce);
                        }
                    }
                    if (a != null) {
                        if (a.getScheme() == null) {
                            a = Default.ANY_HTTP_ADDRESS.resolve(a);
                        }
                        if (!a.getScheme().equalsIgnoreCase(Default.ANY_HTTP_ADDRESS.getScheme())) {
                            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                                LOG.error((Object)("invalid http address: " + a.toString()));
                            }
                            a = null;
                        }
                        if (a != null) {
                            if (a.getHost() == null) {
                                a = null;
                            }
                            if (a != null && a.getPort() == -1) {
                                try {
                                    a = new URI(a.getScheme(), a.getUserInfo(), a.getHost(), 8080, a.getPath(), a.getQuery(), a.getFragment());
                                }
                                catch (URISyntaxException use) {
                                    a = null;
                                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block134;
                                    LOG.error((Object)"invalid http proxy transformation", (Throwable)use);
                                }
                            }
                        }
                    }
                }
                if (a != null) {
                    ProxyAddress proxy = new ProxyAddress();
                    proxy.setEnabled(p.getBoolean("/jxta/transport/http/@enabled", false));
                    proxy.setAddress(a);
                    http.setProxyAddress(proxy);
                }
                this.addTransport(http);
            }
            this.setRendezVous((b = p.contains("/jxta/service/rendezVous/@enabled")) ? p.getBoolean("/jxta/service/rendezVous/@enabled") : (overlay ? false : this.isRendezVous()));
            b = p.contains("/jxta/service/rendezVous/@enabled");
            this.setRendezVousAutoStart(b ? p.getBoolean("/jxta/service/rendezVous/@enabled") : (overlay ? false : this.isRendezVousAutoStart()));
            this.setRendezVousAutoStart(p.getLong("/jxta/service/rendezVous/autoStart", overlay ? 30000L : this.getRendezVousAutoStart()));
            b = p.contains("/jxta/service/relay/@enabled");
            this.setRelayQueueSize(p.getInt("/jxta/service/relay/@queueSize", overlay ? 20 : this.getRelayQueueSize()));
            b = p.contains("/jxta/service/relay/incoming/@enabled");
            this.setRelayIncoming(b ? p.getBoolean("/jxta/service/relay/incoming/@enabled") : (overlay ? false : this.isRelayIncoming()));
            this.setRelayIncomingMaximum(p.getInt("/jxta/service/relay/incoming/@maximum", overlay ? 100 : this.getRelayIncomingMaximum()));
            this.setRelayIncomingLease(p.getLong("/jxta/service/relay/incoming/@lease", overlay ? 0x6DDD00L : this.getRelayIncomingLease()));
            b = p.contains("/jxta/service/relay/outgoing/@enabled");
            this.setRelayOutgoing(b ? p.getBoolean("/jxta/service/relay/outgoing/@enabled") : (overlay ? true : this.isRelayOutgoing()));
            this.setRelayOutgoingMaximum(p.getInt("/jxta/service/relay/outgoing/@maximum", overlay ? 1 : this.getRelayOutgoingMaximum()));
            this.setRelayOutgoingLease(p.getLong("/jxta/service/relay/outgoing/@lease", overlay ? 0x6DDD00L : this.getRelayOutgoingLease()));
            this.setEndpointOutgoingQueueSize(p.getInt("/jxta/service/endpoint/@queueSize", overlay ? 20 : this.getEndpointOutgoingQueueSize()));
            b = p.contains("/jxta/service/proxy/@enabled");
            this.setProxy(b ? p.getBoolean("/jxta/service/proxy/@enabled") : (overlay ? false : this.isProxy()));
            Iterator o = p.getAll("/jxta/configuration/optimizer/@class").iterator();
            while (o.hasNext()) {
                Optimizer op;
                String cn;
                block135: {
                    cn = (String)o.next();
                    op = null;
                    try {
                        Class<?> c = Class.forName(cn);
                        op = (Optimizer)c.newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("optimizer not found: " + cn), (Throwable)cnfe);
                        }
                    }
                    catch (InstantiationException ie) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)("can't instantiate optimizer: " + cn), (Throwable)ie);
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block135;
                        LOG.error((Object)("can't access optimizer: " + cn), (Throwable)iae);
                    }
                }
                if (op == null) continue;
                String pnq = MessageFormat.format("/jxta/configuration/optimizer[@class=''{0}'']/property/@name", cn);
                ArrayList<String> pnc = new ArrayList<String>();
                Iterator opn = p.getAll(pnq).iterator();
                while (opn.hasNext()) {
                    String pn = (String)opn.next();
                    String pvq = MessageFormat.format("/jxta/configuration/optimizer[@class=''{0}'']/property[@name=''{1}'']", cn, pn);
                    if (!pnc.contains(pn)) {
                        Iterator opv = p.getAll(pvq).iterator();
                        while (opv.hasNext()) {
                            String pv = (String)opv.next();
                            if (pv == null) continue;
                            op.addProperty(pn, pv);
                        }
                    }
                    pnc.add(pn);
                }
                this.addOptimizer(op);
            }
        }
    }

    private void validate() throws ConfiguratorException {
        List transports;
        ArrayList<IllegalStateException> state = new ArrayList<IllegalStateException>();
        String rc = this.getRootCertificateBase64();
        String usr = this.getPrincipal();
        String pwd = this.getPassword();
        if (rc == null) {
            if (usr == null || usr.trim().length() == 0 || pwd == null || pwd.trim().length() == 0) {
                state.add(new IllegalStateException("invalid security[principal, password]: " + usr + " " + pwd));
            } else {
                state.add(new IllegalStateException("null root certificate"));
            }
        }
        if ((transports = this.getTransports()).size() == 0) {
            state.add(new IllegalStateException("unspecified transport"));
        }
        Iterator ti = transports.iterator();
        while (ti.hasNext()) {
            Transport t = (Transport)ti.next();
            List as = t.getAddresses();
            List ps = t.getPublicAddresses();
            if (!t.isIncoming()) continue;
            if (as.isEmpty() && ps.isEmpty()) {
                state.add(new IllegalStateException("unspecified transport address"));
            }
            Iterator ai = as.iterator();
            while (ai.hasNext()) {
                Address a = (Address)ai.next();
                URI aa = a != null ? a.getAddress() : null;
                Iterator pi = ps.iterator();
                while (pi.hasNext()) {
                    URI pa;
                    PublicAddress p = (PublicAddress)pi.next();
                    URI uRI = pa = p != null ? p.getAddress() : null;
                    if (pa != null && pa.getHost() != null && pa.getHost().length() > 0) {
                        if (aa == null || aa.getPort() >= 1 && aa.getPort() <= 65535 || pa.getPort() >= 1 && pa.getPort() <= 65535) continue;
                        state.add(new IllegalStateException("invalid port: " + aa.getPort() + " " + pa.getPort()));
                        continue;
                    }
                    if (aa == null || aa.getPort() >= 0 && aa.getPort() <= 65535) continue;
                    state.add(new IllegalStateException("invalid port: " + aa.getPort()));
                }
                if (!(a instanceof TcpTransportAddress)) continue;
                Iterator mi = ((TcpTransportAddress)a).getMulticastAddresses().iterator();
                while (mi.hasNext()) {
                    URI ma;
                    MulticastAddress m = (MulticastAddress)mi.next();
                    URI uRI = ma = m != null ? m.getAddress() : null;
                    if (ma != null && (ma.getPort() < 1 || ma.getPort() > 65535)) {
                        state.add(new IllegalStateException("invalid multicast port: " + ma.getPort()));
                    }
                    if (m == null || m.getSize() >= 0 && m.getSize() <= 1048575) continue;
                    state.add(new IllegalStateException("invalid multicast size: " + m.getSize()));
                }
            }
            ProxyAddress px = t.getProxyAddress();
            URI pxa = px != null ? px.getAddress() : null;
            if (pxa == null || pxa.getPort() >= 1 && pxa.getPort() <= 65535) continue;
            state.add(new IllegalStateException("invalid proxy port " + pxa.getPort()));
        }
        if (this.isRelayOutgoing()) {
            int trc = 0;
            int hrc = 0;
            Iterator r = this.getRelays().iterator();
            while (r.hasNext()) {
                URI uri = (URI)r.next();
                String s = uri.getScheme();
                if (s == null) continue;
                if (s.equalsIgnoreCase(Default.ANY_TCP_ADDRESS.getScheme())) {
                    ++trc;
                    continue;
                }
                if (!s.equalsIgnoreCase(Default.ANY_HTTP_ADDRESS.getScheme())) continue;
                ++hrc;
            }
            if (this.getRelaysBootstrapAddress() == null) {
                if (this.transportsContainsScheme("tcp") && this.transportsContainsScheme("http")) {
                    if (trc + hrc == 0) {
                        state.add(new IllegalStateException("unspecified relay: tcp[" + this.transportsContainsScheme("tcp") + "] http[" + this.transportsContainsScheme("http") + "] relays[" + this.getRelays().iterator().hasNext() + "]"));
                    }
                } else if (this.transportsContainsScheme("tcp") && trc == 0) {
                    state.add(new IllegalStateException("unspecified " + Default.ANY_TCP_ADDRESS.getScheme() + " relay"));
                } else if (this.transportsContainsScheme("http") && hrc == 0) {
                    state.add(new IllegalStateException("unspecified " + Default.ANY_HTTP_ADDRESS.getScheme() + " relay"));
                }
            }
        }
        if (state.size() > 0) {
            ConfiguratorException ce = new ConfiguratorException("invalid configuration", state);
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"configuration is not valid", (Throwable)ce);
            }
            throw ce;
        }
    }

    private void normalize() {
        URI t;
        Iterator i;
        URI b;
        URI u;
        String ph = System.getProperty("http.proxyHost");
        String pp = System.getProperty("http.proxyPort");
        String pu = System.getProperty("jxta.proxy.user");
        String pa = System.getProperty("jxta.proxy.password");
        String jp = System.getProperty("jxta.proxy");
        URI proxy = this.getPeerProxyAddress();
        Iterator r = this.getRendezVous().iterator();
        while (r.hasNext()) {
            u = (URI)r.next();
            if (!Default.BOOTSTRAP_ADDRESSES.contains(u)) continue;
            this.removeRendezVous(u);
            b = this.getRendezVousBootstrapAddress();
            try {
                i = this.fetchBootstrapAddresses(b).iterator();
                while (i.hasNext()) {
                    t = (URI)i.next();
                    if (u.getScheme() != null && (u.getScheme() == null || !u.getScheme().equalsIgnoreCase(t.getScheme()))) continue;
                    this.addRendezVous(t);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("inaccessible url: " + b.toString()));
            }
            catch (ConfiguratorException ce) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("invalid rendezVou address: " + b.toString()));
            }
        }
        r = this.getRelays().iterator();
        while (r.hasNext()) {
            u = (URI)r.next();
            if (!Default.BOOTSTRAP_ADDRESSES.contains(u)) continue;
            this.removeRelay(u);
            b = this.getRelaysBootstrapAddress();
            try {
                i = this.fetchBootstrapAddresses(b).iterator();
                while (i.hasNext()) {
                    t = (URI)i.next();
                    if (u.getScheme() != null && (u.getScheme() == null || !u.getScheme().equalsIgnoreCase(t.getScheme()))) continue;
                    this.addRelay(t);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("inaccessible url: " + b.toString()));
            }
            catch (ConfiguratorException ce) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("invalid relay address: " + b.toString()));
            }
        }
        String principal = this.getPrincipal();
        String password = this.getPassword();
        if (principal != null && principal.trim().length() > 0 && password != null && password.trim().length() > 0) {
            PSEUtils.IssuerInfo ii;
            block24: {
                System.setProperty("net.jxta.tls.principal", principal);
                System.setProperty("net.jxta.tls.password", password);
                ii = null;
                try {
                    ii = PSEUtils.genCert((String)principal, null);
                }
                catch (SecurityException ioe) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block24;
                    LOG.error((Object)"can't create root certificate", (Throwable)ioe);
                }
            }
            if (ii != null) {
                this.setRootCertificate(ii.cert);
                char[] pwd = password.toCharArray();
                this.pse.setPrivateKey(ii.subjectPkey, pwd);
                for (int i2 = pwd.length - 1; i2 >= 0; --i2) {
                    pwd[i2] = '\u0000';
                }
            }
        }
        ArrayList<Address> n = new ArrayList<Address>();
        ArrayList<MulticastAddress> m = new ArrayList<MulticastAddress>();
        Iterator ti = this.getTransports().iterator();
        while (ti.hasNext()) {
            Address b2;
            Address a;
            Transport t2 = (Transport)ti.next();
            Iterator tai = t2.getAddresses().iterator();
            while (tai.hasNext()) {
                a = (Address)tai.next();
                b2 = null;
                if (a instanceof TcpTransportAddress) {
                    if (a.getAddress() == null) {
                        a.setAddress(this.makeAddress("tcp://", Env.ALL_ADDRESSES.getHostAddress(), 9701));
                    }
                    b2 = new TcpTransportAddress((TcpTransportAddress)a);
                } else if (a instanceof Address) {
                    if (a.getAddress() == null) {
                        a.setAddress(this.makeAddress("http://", Env.ALL_ADDRESSES.getHostAddress(), 9700));
                    }
                    b2 = new Address(a);
                }
                b2.setAddress(Util.normalize(a));
                n.add(b2);
                if (!(a instanceof TcpTransportAddress)) continue;
                Iterator mai = ((TcpTransportAddress)a).getMulticastAddresses().iterator();
                while (mai.hasNext()) {
                    MulticastAddress c = (MulticastAddress)mai.next();
                    MulticastAddress d = new MulticastAddress(c);
                    ((Address)d).setAddress(Util.normalize(c, false));
                    m.add(d);
                }
                ((TcpTransportAddress)a).setMulticastAddresses(m);
                m.clear();
            }
            t2.setAddresses(n);
            n.clear();
            Iterator pai = t2.getPublicAddresses().iterator();
            while (pai.hasNext()) {
                a = (PublicAddress)pai.next();
                b2 = new PublicAddress((PublicAddress)a);
                b2.setAddress(Util.normalize(a, false));
                n.add(b2);
            }
            t2.setPublicAddresses(n);
            n.clear();
        }
    }

    private void optimize() {
        Iterator o = this.getOptimizers();
        while (o.hasNext()) {
            ((Optimizer)o.next()).optimize(this);
        }
    }

    private PlatformConfig constructPlatformConfig() {
        PlatformConfig pc = (PlatformConfig)AdvertisementFactory.newAdvertisement((String)PlatformConfig.getAdvertisementType());
        pc.setName(this.getName());
        pc.setDescription(this.getDescription());
        pc.setPeerID(this.getPeerId());
        pc.setDebugLevel(this.getTrace() != null ? this.getTrace().toString() : Trace.DEFAULT.toString());
        XMLDocument d = (XMLDocument)this.rdvConfig.getDocument(MimeMediaType.XMLUTF8);
        pc.putServiceParam((ID)ModuleId.RENDEZVOUS.getId(), (Element)d);
        d = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (String)Tag.PARM.toString());
        if (!this.isProxy()) {
            d.appendChild(d.createElement(Tag.IS_ENABLED.toString()));
        }
        pc.putServiceParam((ID)ModuleId.PROXY.getId(), (Element)d);
        d = (XMLDocument)this.relayConfig.getDocument(MimeMediaType.XMLUTF8);
        pc.putServiceParam((ID)ModuleId.RELAY.getId(), (Element)d);
        d = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (String)Tag.PARM.toString());
        d.appendChild(d.createElement(Tag.ENDPOINT_QUEUE_SIZE.toString(), Integer.toString(20)));
        pc.putServiceParam((ID)ModuleId.ENDPOINT.getId(), (Element)d);
        Iterator ti = this.getTransports().iterator();
        while (ti.hasNext()) {
            PublicAddress pa;
            Iterator pi;
            Iterator ai;
            Transport t = (Transport)ti.next();
            ArrayList ports = new ArrayList();
            URI u = null;
            if (t instanceof TcpTransport) {
                TcpTransport tt = (TcpTransport)t;
                TCPAdv tcp = (TCPAdv)AdvertisementFactory.newAdvertisement((String)TCPAdv.getAdvertisementType());
                tcp.setProtocol(tt != null ? tt.getScheme() : "tcp");
                tcp.setConfigMode("auto");
                tcp.setServerEnabled(tt != null ? tt.isIncoming() : true);
                tcp.setClientEnabled(tt != null ? tt.isOutgoing() : true);
                ai = tt.getAddresses().iterator();
                while (ai.hasNext()) {
                    TcpTransportAddress ta = (TcpTransportAddress)ai.next();
                    URI uRI = u = ta != null ? ta.getAddress() : null;
                    if (u != null && u.getHost() != null && !u.getHost().equals(Util.getLocalHost()) && !u.getHost().equals(Env.ALL_ADDRESSES.getHostAddress())) {
                        tcp.setInterfaceAddress(u.getHost());
                    }
                    tcp.setPort(u != null ? u.getPort() : 9701);
                    tcp.setStartPort(tcp.getPort());
                    tcp.setEndPort(tcp.getStartPort() + ta.getPortRange());
                    Iterator mi = ta.getMulticastAddresses().iterator();
                    while (mi.hasNext()) {
                        MulticastAddress ma = (MulticastAddress)mi.next();
                        u = ma != null ? ma.getAddress() : null;
                        tcp.setMulticastState(ma != null ? ma.isMulticast() : true);
                        tcp.setMulticastAddr(u != null ? u.getHost() : null);
                        tcp.setMulticastPort(u != null ? u.getPort() : 1234);
                        tcp.setMulticastSize(ma != null ? ma.getSize() : 16384);
                    }
                }
                pi = tt.getPublicAddresses().iterator();
                while (pi.hasNext()) {
                    pa = (PublicAddress)pi.next();
                    URI uRI = u = pa != null ? pa.getAddress() : null;
                    if (u != null && u.getHost() != null && u.getHost().equals(Util.getLocalHost())) {
                        u = null;
                    }
                    tcp.setServer(u != null ? u.getHost() + COLON + u.getPort() : null);
                    tcp.setPublicAddressOnly(pa != null ? pa.isExclusive() : false);
                }
                StructuredTextDocument td = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (String)Tag.PARM.toString());
                StructuredDocumentUtils.copyElements((StructuredDocument)td, (Element)td, (Element)((StructuredDocument)tcp.getDocument(MimeMediaType.XMLUTF8)));
                if (!tt.isEnabled()) {
                    td.appendChild(td.createElement(Tag.IS_ENABLED.toString()));
                }
                pc.putServiceParam((ID)ModuleId.TCP.getId(), (Element)td);
                continue;
            }
            if (!(t instanceof HttpTransport)) continue;
            HttpTransport ht = (HttpTransport)t;
            HTTPAdv http = (HTTPAdv)AdvertisementFactory.newAdvertisement((String)HTTPAdv.getAdvertisementType());
            http.setProtocol(ht != null ? ht.getScheme() : "http");
            http.setConfigMode("auto");
            http.setServerEnabled(ht != null ? ht.isIncoming() : false);
            http.setClientEnabled(ht != null ? ht.isOutgoing() : true);
            ai = ht.getAddresses().iterator();
            while (ai.hasNext()) {
                Address ha = (Address)ai.next();
                URI uRI = u = ha != null ? ha.getAddress() : null;
                if (u != null && u.getHost() != null && !u.getHost().equals(Util.getLocalHost()) && !u.getHost().equals(Env.ALL_ADDRESSES.getHostAddress())) {
                    http.setInterfaceAddress(u.getHost());
                }
                http.setPort(u != null ? u.getPort() : 9700);
            }
            pi = ht.getPublicAddresses().iterator();
            while (pi.hasNext()) {
                pa = (PublicAddress)pi.next();
                u = pa != null ? pa.getAddress() : null;
                http.setServer(u != null ? u.getHost() + COLON + u.getPort() : null);
                http.setPublicAddressOnly(pa != null ? pa.isExclusive() : false);
            }
            ProxyAddress px = ht.getProxyAddress();
            u = px != null ? px.getAddress() : null;
            http.setProxyEnabled(ht.isProxy());
            http.setProxy(u != null ? u.getHost() + COLON + u.getPort() : null);
            StructuredTextDocument td = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (String)Tag.PARM.toString());
            StructuredDocumentUtils.copyElements((StructuredDocument)td, (Element)td, (Element)((StructuredDocument)http.getDocument(MimeMediaType.XMLUTF8)));
            if (!ht.isEnabled()) {
                td.appendChild(td.createElement(Tag.IS_ENABLED.toString()));
            }
            if (u != null) {
                String ui;
                int i;
                int p;
                System.setProperty("jxta.proxy", u.toString());
                if (u.getHost() != null) {
                    System.setProperty("http.proxyHost", u.getHost());
                }
                if ((p = u.getPort()) >= 1 && p <= 65535) {
                    System.setProperty("http.proxyPort", Integer.toString(p));
                }
                int n = i = (ui = u.getUserInfo()) != null ? ui.indexOf(COLON) : -1;
                if (ui != null && i > -1) {
                    System.setProperty("jxta.proxy.user", ui.substring(0, i));
                    System.setProperty("jxta.proxy.password", ui.substring(i + 1));
                }
            }
            pc.putServiceParam((ID)ModuleId.HTTP.getId(), (Element)td);
        }
        XMLDocument xd = (XMLDocument)this.pse.getDocument(MimeMediaType.XMLUTF8);
        xd.addAttribute(Tag.TYPE_ATTRIBUTE.toString(), xd.getName());
        pc.putServiceParam((ID)ModuleId.MEMBERSHIP.getId(), (Element)xd);
        Iterator ci = this.customParams.keySet().iterator();
        while (ci.hasNext()) {
            ID key = (ID)ci.next();
            if (ModuleId.isNormalService(key)) continue;
            pc.putServiceParam(key, (Element)this.customParams.get(key));
        }
        return pc;
    }

    private List orderAddresses(List a) {
        ArrayList<URI> prefix = new ArrayList<URI>();
        ArrayList<URI> postfix = new ArrayList<URI>();
        URI u = null;
        Iterator i = a.iterator();
        while (i.hasNext()) {
            u = (URI)i.next();
            if (this.transportsContainsScheme("http") && !this.transportsContainsScheme("tcp") && u.getScheme() != null && u.getScheme().equalsIgnoreCase(Default.ANY_HTTP_ADDRESS.getScheme())) {
                prefix.add(u);
                continue;
            }
            postfix.add(u);
        }
        ArrayList<URI> o = new ArrayList<URI>(prefix);
        o.addAll(postfix);
        return o;
    }

    private URI makeAddress(String protocol, String addr, int port) {
        URI u;
        block6: {
            u = null;
            if (addr != null && addr.trim().length() > 0) {
                try {
                    u = new URI(protocol + addr.trim() + COLON + port);
                }
                catch (URISyntaxException use) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"invalid tcp address", (Throwable)use);
                    }
                    break block6;
                }
            }
            try {
                u = new URI(protocol + Util.getLocalHost() + COLON + port);
            }
            catch (URISyntaxException use) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                LOG.error((Object)"invalid tcp address", (Throwable)use);
            }
        }
        return u;
    }

    private void setCustomParams(PlatformConfig pc) {
        Iterator si = pc.getServiceParamsEntrySet().iterator();
        while (si.hasNext()) {
            Map.Entry entry = (Map.Entry)si.next();
            ID key = (ID)entry.getKey();
            if (ModuleId.isNormalService(key)) continue;
            this.customParams.put(key, pc.getServiceParam(key));
        }
    }
}

