/*
 * Decompiled with CFR 0.152.
 */
package jsynedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsynedit.JSynEditAgent;
import madkit.kernel.Kernel;

class EditorGroupDialog
extends JDialog
implements ActionListener {
    JComboBox commChooser;
    JComboBox groupChooser;
    JComboBox roleChooser;
    JTextField passwdField;
    JSynEditAgent ag;
    String community = Kernel.DEFAULT_COMMUNITY;

    public EditorGroupDialog(JSynEditAgent jSynEditAgent, Frame frame) {
        super(frame, true);
        this.setTitle("Entering a new group");
        this.setLocationRelativeTo(frame);
        this.ag = jSynEditAgent;
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jPanel.add(jButton2);
        jButton2.addActionListener(this);
        this.getContentPane().add((Component)new JLabel("Choose among existing groups and roles, or enter new role"), "North");
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1));
        jPanel2.add((Component)jPanel3, "West");
        JPanel jPanel4 = new JPanel(new GridLayout(4, 1));
        jPanel2.add((Component)jPanel4, "Center");
        JLabel jLabel = new JLabel("communities : ");
        jPanel3.add(jLabel);
        JLabel jLabel2 = new JLabel("group : ");
        jPanel3.add(jLabel2);
        JLabel jLabel3 = new JLabel("role : ");
        jPanel3.add(jLabel3);
        JLabel jLabel4 = new JLabel("password : ");
        jPanel3.add(jLabel4);
        this.commChooser = new JComboBox();
        this.commChooser.setEditable(true);
        String[] stringArray = this.ag.getAvailableCommunities();
        for (int i = 0; i < stringArray.length; ++i) {
            this.commChooser.addItem(stringArray[i]);
        }
        this.commChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                EditorGroupDialog.this.community = (String)jComboBox.getSelectedItem();
                EditorGroupDialog.this.showAllGroups();
            }
        });
        jPanel4.add(this.commChooser);
        this.groupChooser = new JComboBox();
        this.groupChooser.setEditable(true);
        this.showAllGroups();
        this.groupChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                EditorGroupDialog.this.showRoles(string);
            }
        });
        jPanel4.add(this.groupChooser);
        this.roleChooser = new JComboBox();
        this.roleChooser.setEditable(true);
        this.showRoles((String)this.groupChooser.getSelectedItem());
        jPanel4.add(this.roleChooser);
        this.passwdField = new JTextField();
        jPanel4.add(this.passwdField);
        this.pack();
        this.show();
    }

    void showAllGroups() {
        String[] stringArray = this.ag.getExistingGroups(this.community);
        this.groupChooser.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            this.groupChooser.addItem(stringArray[i]);
        }
    }

    void showRoles(String string) {
        if (this.community != null && string != null && !string.equals("")) {
            String[] stringArray = this.ag.getExistingRoles(this.community, string);
            this.roleChooser.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.roleChooser.addItem(stringArray[i]);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.ag.enterGroupRole(this.community, (String)this.groupChooser.getSelectedItem(), (String)this.roleChooser.getSelectedItem(), this.passwdField.getText());
            this.dispose();
        } else {
            this.dispose();
        }
    }
}

