/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.jbrowser.Options;
import gnu.jbrowser.RWModifier;
import java.util.Vector;
import javax.swing.ImageIcon;

public class UML {

    static class Attribute
    extends Element {
        private String type;
        static final String PRIMITIVE_TYPES = ":boolean:char:byte:short:int:long:float:double:";

        Attribute(String string, String string2, int n, Element element, int n2) {
            super(string, Type.ATTRIBUTE, n, element, n2);
            this.type = string2;
        }

        public final boolean isAbstract() {
            return false;
        }

        public final boolean isPrimitive() {
            return this.name.indexOf("[") == -1 && PRIMITIVE_TYPES.indexOf(":" + this.type + ":") != -1;
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            boolean bl = false;
            if (RWModifier.getMemberVisIndex(this.mod) >= filterIro.getMemberVisIndex() && filterIro.getShowAttributes() && (filterIro.getShowPrimitives() || !this.isPrimitive())) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return "" + (this.line + 1) + ":" + this.name + " : " + this.type;
        }

        public String toString(Options.DisplayIro displayIro) {
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + RWModifier.toString(this.mod, displayIro) + (displayIro.getTypeIsSuffixed() ? this.name + " : " + this.type : this.type + " " + this.name);
        }
    }

    static class Throws
    extends Element {
        Throws(String string, Element element, int n) {
            super(string, Type.THROWS, 0, element, n);
        }

        public String toString(Options.DisplayIro displayIro) {
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + (displayIro.getShowIconKeywords() ? this.type.toString() + " " : "") + this.name;
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            boolean bl = false;
            if (filterIro.getShowThrows()) {
                bl = true;
            }
            return bl;
        }
    }

    static class Operation
    extends Element {
        private String returnType;
        private Vector argList = null;
        private boolean isConstructor = false;

        Operation(String string, String string2, int n, Element element, int n2) {
            super(string, Type.METHOD, n, element, n2);
            this.returnType = string2;
        }

        public final void addArgument(String string, String string2) {
            if (this.argList == null) {
                this.argList = new Vector();
            }
            this.argList.addElement(new Argument(string, string2));
        }

        public boolean isConstructor() {
            return this.isConstructor;
        }

        public void setConstructor(boolean bl) {
            this.isConstructor = bl;
        }

        public final boolean isAbstract() {
            return RWModifier.isAbstract(this.mod) || this.getParentElementType() == Type.INTERFACE;
        }

        public final boolean isBodyRequired() {
            return !RWModifier.isNative(this.mod) && !this.isAbstract();
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            boolean bl = false;
            if (RWModifier.getMemberVisIndex(this.mod) >= filterIro.getMemberVisIndex()) {
                bl = true;
            }
            return bl;
        }

        public final String listArgs(Options.DisplayIro displayIro) {
            String string = "";
            if (this.argList != null && displayIro.getShowArguments()) {
                for (int i = 0; i < this.argList.size(); ++i) {
                    string = i > 0 ? string + ", " + ((Argument)this.argList.elementAt(i)).toString(displayIro) : string + ((Argument)this.argList.elementAt(i)).toString(displayIro);
                }
            }
            return string;
        }

        public String toString(Options.DisplayIro displayIro) {
            if (displayIro.getTypeIsSuffixed()) {
                return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + RWModifier.toString(this.mod, displayIro) + this.name + "(" + this.listArgs(displayIro) + ")" + (this.isConstructor ? ": <init>" : " : " + this.returnType);
            }
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + RWModifier.toString(this.mod, displayIro) + (this.isConstructor ? "/*constructor*/ " : this.returnType + " ") + this.name + "(" + this.listArgs(displayIro) + ")";
        }

        static class Argument {
            private String type;
            private String name;

            public Argument(String string, String string2) {
                this.type = string;
                this.name = string2;
            }

            public final String toString(Options.DisplayIro displayIro) {
                if (displayIro.getTypeIsSuffixed()) {
                    return (displayIro.getShowArgumentNames() ? this.name + " : " : " : ") + this.type;
                }
                return this.type + (displayIro.getShowArgumentNames() ? " " + this.name : "");
            }

            public final String getType() {
                return this.type;
            }
        }
    }

    static class Message
    extends Element {
        Message(String string, Type type, Element element, int n) {
            super(string, type, 0, element, n);
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            return true;
        }

        public String toString(Options.DisplayIro displayIro) {
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + (displayIro.getShowIconKeywords() ? this.type + ": " + this.name : this.name);
        }
    }

    static class Generalization
    extends Element {
        Generalization(String string, Type type, Element element, int n) {
            super(string, type, 0, element, n);
        }

        public String toString(Options.DisplayIro displayIro) {
            String string = "interface";
            if (this.parent.isClass() && this.type == Type.EXTENDS) {
                string = "class";
            }
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + (displayIro.getShowIconKeywords() ? this.type.toString() + " " : "") + string + " " + this.name;
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            boolean bl = false;
            if (filterIro.getShowGeneralizations()) {
                bl = true;
            }
            return bl;
        }
    }

    static class NestedMember
    extends Element {
        NestedMember(String string, Type type, int n, Element element, int n2) {
            super(string, type, n, element, n2);
        }

        public String toString(Options.DisplayIro displayIro) {
            String string = "";
            for (Element element = this.getParentElement(); element != null; element = element.getParentElement()) {
                string = element.getName() + " ." + string;
            }
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + RWModifier.toString(this.mod, displayIro) + (displayIro.getShowNestedName() ? string + this.name : this.name);
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            boolean bl = false;
            if (RWModifier.getVisLevelIndex(this.mod) >= filterIro.getMemberVisIndex()) {
                bl = true;
            }
            return bl;
        }
    }

    static class PackageMember
    extends Element {
        PackageMember(String string, Type type, int n, int n2) {
            super(string, type, n, null, n2);
        }

        public String toString(Options.DisplayIro displayIro) {
            return (displayIro.getShowLineNum() ? this.line + 1 + ":" : "") + RWModifier.toString(this.mod, displayIro) + this.name;
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            boolean bl = false;
            if (RWModifier.getTopLevelVisIndex(this.mod) >= filterIro.getTopLevelVisIndex()) {
                bl = true;
            }
            return bl;
        }
    }

    static class Element {
        protected String name = null;
        protected Type type = null;
        protected int mod = 0;
        protected Element parent = null;
        protected int line = -1;

        Element(String string, Type type, int n, Element element, int n2) {
            this.name = string;
            this.type = type;
            this.mod = n;
            this.parent = element;
            this.line = n2;
        }

        Element(String string) {
            this.name = string;
        }

        public final Type getElementType() {
            return this.type;
        }

        public final void setElementType(Type type) {
            this.type = type;
        }

        public final Element getParentElement() {
            return this.parent;
        }

        public final void setParentElement(Element element) {
            this.parent = this.parent;
        }

        public final Type getParentElementType() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getElementType();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String toString(Options.DisplayIro displayIro) {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean isVisible(Options.FilterIro filterIro) {
            return true;
        }

        public boolean isAbstract() {
            return RWModifier.isAbstract(this.mod) || RWModifier.isInterface(this.mod);
        }

        public final boolean isStatic() {
            return RWModifier.isStatic(this.mod);
        }

        public final boolean isInterface() {
            return RWModifier.isInterface(this.mod);
        }

        public final boolean isClass() {
            return RWModifier.isClass(this.mod);
        }
    }

    public static class Type {
        public static final Type CLASS = new Type("class", new ImageIcon(UML.class.getResource("/images/class.gif")));
        public static final Type INTERFACE = new Type("interface", new ImageIcon(UML.class.getResource("/images/interface.gif")));
        public static final Type INNER_CLASS = new Type("inner-class", new ImageIcon(UML.class.getResource("/images/innerClass.gif")));
        public static final Type METHOD = new Type("", new ImageIcon(UML.class.getResource("/images/operation.gif")));
        public static final Type ATTRIBUTE = new Type("", new ImageIcon(UML.class.getResource("/images/attribute.gif")));
        public static final Type EXTENDS = new Type("extends", new ImageIcon(UML.class.getResource("/images/extends.gif")));
        public static final Type IMPLEMENTS = new Type("implements", new ImageIcon(UML.class.getResource("/images/implements.gif")));
        public static final Type THROWS = new Type("throws", new ImageIcon(UML.class.getResource("/images/throws.gif")));
        public static final Type ERROR = new Type("ERROR", new ImageIcon(UML.class.getResource("/images/error.gif")));
        public static final Type[] POSSIBLE_VALUES = new Type[]{CLASS, INTERFACE, INNER_CLASS, METHOD, ATTRIBUTE, ERROR};
        protected String label = null;
        protected ImageIcon icon = null;

        private Type(String string, ImageIcon imageIcon) {
            this.label = string;
            this.icon = imageIcon;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label.toString();
        }
    }
}

