/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.jbrowser.JBrowseParser;
import java.util.StringTokenizer;

public class TokenSource {
    private JBrowseParser.LineSource ls;
    private static final String DELIM = "\t\n\r\f \"'*/{}()[],&|!~+-;:=\\";
    private int currentLineNum = -1;
    private int currentPos = 0;
    private int tokenizerOffset = 0;
    private String lineString;
    private String currentToken;
    private StringTokenizer st;
    private int debugLevel;

    public final int getCurrentLineNum() {
        return this.currentLineNum;
    }

    public final int getCurrentPos() {
        return this.currentPos + this.tokenizerOffset;
    }

    public final String getCurrentLine() {
        return this.lineString;
    }

    TokenSource(JBrowseParser.LineSource lineSource) {
        this(lineSource, 0);
    }

    TokenSource(JBrowseParser.LineSource lineSource, int n) {
        this.ls = lineSource;
        this.debugLevel = n;
        this.st = new StringTokenizer(this.getNextLine(), DELIM, true);
    }

    private final String getNextLine() {
        this.lineString = this.ls.getLine(++this.currentLineNum);
        return this.lineString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNextToken() throws Exception {
        block12: while (true) {
            if (this.currentToken != null) {
                this.currentPos += this.currentToken.length();
            }
            while (!this.st.hasMoreTokens() && !this.ls.isExhausted()) {
                this.currentPos = 0;
                this.tokenizerOffset = 0;
                try {
                    this.st = new StringTokenizer(this.getNextLine(), DELIM, true);
                }
                catch (java.lang.Exception exception) {
                    System.out.println("Exception caught in TokenSource.getNextToken\n\tWhile trying to create a non-null StringTokenizer\n\t" + exception.getMessage());
                    exception.printStackTrace(System.out);
                    return null;
                }
            }
            if (!this.st.hasMoreTokens()) {
                return null;
            }
            try {
                this.currentToken = this.st.nextToken();
            }
            catch (java.lang.Exception exception) {
                System.out.println("Exception caught in TokenSource.getNextToken\n\tWhile calling st.nextToken() immediately after verifying st.hasMoreTokens()!\n\t" + exception.getMessage());
                exception.printStackTrace(System.out);
                return null;
            }
            int n = this.currentPos + this.tokenizerOffset;
            if (this.currentToken.length() != 1) return this.currentToken;
            char c = this.currentToken.charAt(0);
            boolean bl = false;
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    continue block12;
                }
                case '\'': {
                    while (true) {
                        if (!this.st.hasMoreTokens()) {
                            throw new Exception("Unterminated char expression.");
                        }
                        this.currentToken = this.currentToken + this.st.nextToken();
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        if (this.currentToken.charAt(this.currentToken.length() - 1) == '\'') continue block12;
                        if (this.currentToken.charAt(this.currentToken.length() - 1) != '\\') continue;
                        bl = true;
                    }
                }
                case '\"': {
                    while (true) {
                        if (!this.st.hasMoreTokens()) {
                            throw new Exception("Unterminated String expression.");
                        }
                        this.currentToken = this.currentToken + this.st.nextToken();
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        if (this.currentToken.charAt(this.currentToken.length() - 1) == '\"') continue block12;
                        if (this.currentToken.charAt(this.currentToken.length() - 1) != '\\') continue;
                        bl = true;
                    }
                }
                case '/': {
                    if (this.lineString.length() <= n + 1) return this.currentToken;
                    if ('/' == this.lineString.charAt(n + 1)) {
                        this.skipRestOfLine();
                        this.currentToken = null;
                        continue block12;
                    }
                    if ('*' != this.lineString.charAt(n + 1)) return this.currentToken;
                    this.tokenizerOffset = this.lineString.indexOf("*/", n + 2);
                    if (this.tokenizerOffset == -1) {
                        do {
                            this.lineString = this.getNextLine();
                            if (this.lineString == null) {
                                throw new Exception("Unterminated multi-line comment.");
                            }
                            this.tokenizerOffset = this.lineString.indexOf("*/");
                        } while (this.tokenizerOffset == -1);
                    }
                    this.tokenizerOffset += 2;
                    if (this.tokenizerOffset >= this.lineString.length()) {
                        this.lineString = this.getNextLine();
                        if (this.lineString == null) {
                            return null;
                        }
                        this.tokenizerOffset = 0;
                    }
                    this.currentPos = 0;
                    try {
                        this.st = new StringTokenizer(this.lineString.substring(this.tokenizerOffset), DELIM, true);
                        this.currentToken = null;
                    }
                    catch (java.lang.Exception exception) {
                        System.out.println("Exception caught in TokenSource.getNextToken\n\tWhile trying to re-configure the Tokenizer\n\t" + exception.getMessage());
                        exception.printStackTrace(System.out);
                        return null;
                    }
                }
                continue block12;
            }
            break;
        }
        return this.currentToken;
    }

    public void skipRestOfLine() {
        this.currentPos = 0;
        this.tokenizerOffset = 0;
        do {
            if (this.ls.isExhausted()) {
                while (this.st.hasMoreTokens()) {
                    this.st.nextToken();
                }
                return;
            }
            this.st = new StringTokenizer(this.getNextLine(), DELIM, true);
        } while (!this.st.hasMoreTokens());
    }

    public final boolean skipUntil(String string) throws Exception {
        String string2 = this.getNextToken();
        int n = 0;
        int n2 = 0;
        while (string2 != null) {
            if (string.equals(string2) && n == 0 && n2 == 0) {
                return true;
            }
            if ("{".equals(string2)) {
                ++n;
            } else if ("(".equals(string2)) {
                ++n2;
            } else if ("}".equals(string2)) {
                --n;
            } else if (")".equals(string2)) {
                --n2;
            }
            if (n < 0 || n2 < 0) break;
            string2 = this.getNextToken();
        }
        return false;
    }

    public final String skipUntil(char[] cArray) throws Exception {
        String string = new String(cArray);
        String string2 = this.getNextToken();
        int n = 0;
        int n2 = 0;
        while (string2 != null) {
            if (string2.length() == 1 && string.indexOf(string2) != -1 && n == 0 && n2 == 0) {
                return string2;
            }
            if ("{".equals(string2)) {
                ++n;
            } else if ("(".equals(string2)) {
                ++n2;
            } else if ("}".equals(string2)) {
                --n;
            } else if (")".equals(string2)) {
                --n2;
            }
            if (n < 0 || n2 < 0) break;
            string2 = this.getNextToken();
        }
        return null;
    }

    static class Exception
    extends java.lang.Exception {
        static final String MESSAGE_UNTERM_COMMENT = "Unterminated multi-line comment.";
        static final String MESSAGE_STRING_EXPR = "Unterminated String expression.";
        static final String MESSAGE_CHAR_EXPR = "Unterminated char expression.";

        Exception(String string) {
            super(string);
        }
    }
}

