/*
 * Decompiled with CFR 0.152.
 */
package gnu.java;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import java.util.Vector;

public class JSBeautifier {
    private static String[] headers = new String[]{"if", "else", "for", "while", "do", "try", "catch", "synchronized", "switch", "case", "default", "static"};
    private static String[] nonParenHeaders = new String[]{"else", "do", "try", "static"};
    private static String[] preBlockStatements = new String[]{"class", "interface", "throws"};
    private static String[] assignmentOperators = new String[]{"<<", ">>", "=", "+=", "-=", "*=", "/=", "%=", "|=", "&=", "return"};
    private static String[] nonAssignmentOperators = new String[]{"==", "++", "--", "!="};
    private Stack headerStack;
    private Stack tempStacks;
    private Stack blockParenDepthStack;
    private Stack blockStatementStack;
    private Stack parenStatementStack;
    private Stack inStatementIndentStack;
    private Stack inStatementIndentStackSizeStack;
    private Stack parenIndentStack;
    private Stack bracketBlockStateStack;
    private boolean isSpecialChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isInCase;
    private boolean isInQuestion;
    private boolean isInStatement;
    private boolean isInClassHeader;
    private boolean isInClassHeaderTab;
    private boolean switchIndent;
    private boolean bracketIndent;
    private char quoteChar;
    private int commentIndent = 1;
    private int parenDepth;
    private String indentString;
    private int indentLength;
    private int blockTabCount;
    private int statementTabCount;
    private int leadingWhiteSpaces;
    private int maxInStatementIndent;
    private char prevNonSpaceCh;
    private char currentNonSpaceCh;
    private String currentHeader;
    private boolean isInHeader;
    private String immediatelyPreviousAssignmentOp;

    public static void main(String[] stringArray) {
        String string;
        int n;
        JSBeautifier jSBeautifier = new JSBeautifier();
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            string = stringArray[n];
            if ("-t".equals(string)) {
                jSBeautifier.setTabIndentation();
                continue;
            }
            if (string.startsWith("-s")) {
                n2 = 4;
                try {
                    n2 = Integer.valueOf(string.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                jSBeautifier.setSpaceIndentation(n2);
                continue;
            }
            if (string.startsWith("-m")) {
                n2 = 4;
                try {
                    n2 = Integer.valueOf(string.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                jSBeautifier.setMaxInStatementIndetation(n2);
                continue;
            }
            if ("-ib".equals(string)) {
                jSBeautifier.setBracketIndent(true);
                continue;
            }
            if ("-fs".equals(string)) {
                jSBeautifier.setSwitchIndent(false);
                continue;
            }
            if (string.startsWith("-") && !bl) {
                bl = true;
                System.err.println("");
                System.err.println("JSBeautifier 1.1.0   (created by Tal Davidson, davidsont@bigfoot.com)");
                System.err.println("");
                System.err.println("Usage  : java jstyle.JSBeautifier [options] < Original.java > Beautified.java");
                System.err.println("         java jstyle.JSBeautifier [options] Foo.java Bar.java  [...]");
                System.err.println("");
                System.err.println("When given a specific file, JSBeautifier will create an output file with a");
                System.err.println("suffix of \".js\" added to the original filename, i.e: Foo.java --> Foo.java.js");
                System.err.println("");
                System.err.println("Options: -t   Indent using tab characters");
                System.err.println("         -s#  Indent using # spaces per indent (i.e. -s4)");
                System.err.println("         -m#  Indent a maximal # spaces in a continuous statement,");
                System.err.println("              relatively to the previous line(i.e. -m40)");
                System.err.println("         -ib  add extra indentation to brackets");
                System.err.println("         -fs  flush (i.e. don't indent) 'switch' blocks");
                System.err.println("         -h   Print this help message");
                System.exit(0);
                continue;
            }
            vector.addElement(string);
        }
        if (vector.isEmpty()) {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            printWriter = new PrintWriter(System.out);
            try {
                jSBeautifier.beautifyReader(bufferedReader, printWriter);
            }
            catch (IOException iOException) {
                System.err.println("Error: " + iOException);
            }
            printWriter.close();
        } else {
            for (n = 0; n < vector.size(); ++n) {
                jSBeautifier.init();
                try {
                    string = (String)vector.elementAt(n);
                    bufferedReader = new BufferedReader(new FileReader(string));
                    printWriter = new PrintWriter((Writer)new FileWriter(string + ".js"), true);
                    jSBeautifier.beautifyReader(bufferedReader, printWriter);
                }
                catch (IOException iOException) {
                    System.err.println("Error: " + iOException);
                }
                printWriter.close();
                try {
                    bufferedReader.close();
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Error: " + iOException);
                }
            }
        }
    }

    public void beautifyReader(BufferedReader bufferedReader, PrintWriter printWriter) throws IOException {
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(this.beautify(string));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JSBeautifier() {
        this.init();
        this.setSpaceIndentation(4);
        this.setMaxInStatementIndetation(40);
        this.setBracketIndent(false);
        this.setSwitchIndent(true);
    }

    public void init() {
        this.headerStack = new Stack();
        this.tempStacks = new Stack();
        this.tempStacks.push(new Stack());
        this.blockParenDepthStack = new Stack();
        this.blockStatementStack = new Stack();
        this.parenStatementStack = new Stack();
        this.bracketBlockStateStack = new Stack();
        this.bracketBlockStateStack.push(new Boolean(true));
        this.inStatementIndentStack = new Stack();
        this.inStatementIndentStackSizeStack = new Stack();
        this.inStatementIndentStackSizeStack.push(new Integer(0));
        this.parenIndentStack = new Stack();
        this.isSpecialChar = false;
        this.isInQuote = false;
        this.isInComment = false;
        this.isInStatement = false;
        this.isInCase = false;
        this.isInQuestion = false;
        this.isInClassHeader = false;
        this.isInClassHeaderTab = false;
        this.isInHeader = false;
        this.immediatelyPreviousAssignmentOp = null;
        this.parenDepth = 0;
        this.blockTabCount = 0;
        this.statementTabCount = -1;
        this.leadingWhiteSpaces = 0;
        this.prevNonSpaceCh = (char)123;
        this.currentNonSpaceCh = (char)123;
    }

    public void setTabIndentation() {
        this.indentString = "\t";
        this.indentLength = 4;
    }

    public void setSpaceIndentation(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        this.indentString = new String(cArray);
        this.indentLength = n;
    }

    public void setMaxInStatementIndetation(int n) {
        this.maxInStatementIndent = n;
    }

    public void setBracketIndent(boolean bl) {
        this.bracketIndent = bl;
    }

    public void setSwitchIndent(boolean bl) {
        this.switchIndent = bl;
    }

    public String beautify(String string) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        String string2 = null;
        boolean bl3 = false;
        int n3 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = this.headerStack.size();
        boolean bl6 = this.isInStatement;
        boolean bl7 = true;
        this.currentHeader = null;
        if (!this.isInComment) {
            this.leadingWhiteSpaces = 0;
            while (this.leadingWhiteSpaces < string.length() && (string.charAt(this.leadingWhiteSpaces) == ' ' || string.charAt(this.leadingWhiteSpaces) == '\t')) {
                ++this.leadingWhiteSpaces;
            }
            string = string.trim();
        } else {
            for (n = 0; n < string.length() && n < this.leadingWhiteSpaces && (string.charAt(n) == ' ' || string.charAt(n) == '\t'); ++n) {
            }
            string = string.substring(n);
        }
        if (string.length() == 0) {
            return string;
        }
        if (!this.inStatementIndentStack.isEmpty()) {
            n3 = (Integer)this.inStatementIndentStack.peek();
        }
        for (n = 0; n < n4; ++n) {
            if (n <= 0 || "{".equals(this.headerStack.elementAt(n - 1)) || !"{".equals(this.headerStack.elementAt(n))) {
                ++n2;
            }
            if (!this.switchIndent || n <= 1 || !"switch".equals(this.headerStack.elementAt(n - 1)) || !"{".equals(this.headerStack.elementAt(n))) continue;
            ++n2;
            bl2 = true;
        }
        if (bl2 && this.switchIndent && n4 >= 2 && "switch".equals(this.headerStack.elementAt(n4 - 2)) && "{".equals(this.headerStack.elementAt(n4 - 1)) && string.charAt(0) == '}') {
            --n2;
        }
        if (this.isInClassHeader) {
            this.isInClassHeaderTab = true;
            n2 += 2;
        }
        for (n = 0; n < string.length(); ++n) {
            int n5;
            int n6;
            char c2 = c;
            c = string.charAt(n);
            if (c == '\n' || c == '\r') continue;
            stringBuffer.append(c);
            if (c == 32 || c == '\t') continue;
            if (this.isSpecialChar) {
                this.isSpecialChar = false;
                continue;
            }
            if (!this.isInComment && !bl && string.regionMatches(false, n, "\\\\", 0, 2)) {
                stringBuffer.append('\\');
                ++n;
                continue;
            }
            if (!this.isInComment && !bl && c == '\\') {
                this.isSpecialChar = true;
                continue;
            }
            if (!(this.isInComment || bl || c != '\"' && c != '\'')) {
                if (!this.isInQuote) {
                    this.quoteChar = c;
                    this.isInQuote = true;
                } else if (this.quoteChar == c) {
                    this.isInQuote = false;
                    this.isInStatement = true;
                    continue;
                }
            }
            if (this.isInQuote) continue;
            if (!this.isInComment && !bl && string.regionMatches(false, n, "//", 0, 2)) {
                bl = true;
                stringBuffer.append("/");
                ++n;
                continue;
            }
            if (!this.isInComment && !bl && string.regionMatches(false, n, "/*", 0, 2)) {
                this.isInComment = true;
                stringBuffer.append("*");
                ++n;
                continue;
            }
            if ((this.isInComment || bl) && string.regionMatches(false, n, "*/", 0, 2)) {
                this.isInComment = false;
                stringBuffer.append("/");
                ++n;
                continue;
            }
            if (this.isInComment || bl) continue;
            this.prevNonSpaceCh = this.currentNonSpaceCh;
            this.currentNonSpaceCh = c;
            if (this.isInHeader) {
                this.isInHeader = false;
                this.currentHeader = (String)this.headerStack.peek();
            } else {
                this.currentHeader = null;
            }
            if (c == '(' || c == '[' || c == ')' || c == ']') {
                if (c == '(' || c == '[') {
                    if (this.parenDepth == 0) {
                        this.parenStatementStack.push(new Boolean(this.isInStatement));
                        this.isInStatement = true;
                    }
                    ++this.parenDepth;
                    this.inStatementIndentStackSizeStack.push(new Integer(this.inStatementIndentStack.size()));
                    if (this.currentHeader != null) {
                        this.inStatementIndentStack.push(new Integer(this.indentLength * 2 + n3));
                        this.parenIndentStack.push(new Integer(this.indentLength * 2 + n3));
                        continue;
                    }
                    this.registerInStatementIndent(string, n, n3, bl6, true);
                    continue;
                }
                if (c != ')' && c != ']') continue;
                --this.parenDepth;
                if (this.parenDepth == 0) {
                    this.isInStatement = (Boolean)this.parenStatementStack.pop();
                    c = ' ';
                }
                if (this.inStatementIndentStackSizeStack.isEmpty()) continue;
                n6 = (Integer)this.inStatementIndentStackSizeStack.pop();
                while (n6 < this.inStatementIndentStack.size()) {
                    this.inStatementIndentStack.pop();
                }
                if (this.parenIndentStack.isEmpty()) continue;
                Object e = this.parenIndentStack.pop();
                if (n != 0) continue;
                n3 = (Integer)e;
                continue;
            }
            if (c == '{') {
                n6 = 0;
                n6 |= this.prevNonSpaceCh == '{' && (Boolean)this.bracketBlockStateStack.peek() != false ? 1 : 0;
                n6 |= this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ';' ? 1 : 0;
                this.isInClassHeader = false;
                if ((n6 |= this.isInClassHeader) == 0 && this.currentHeader != null) {
                    for (int i = 0; i < nonParenHeaders.length; ++i) {
                        if (!this.currentHeader.equals(nonParenHeaders[i])) continue;
                        n6 = 1;
                        break;
                    }
                }
                this.bracketBlockStateStack.push(new Boolean(n6 != 0));
                if (n6 == 0) {
                    if (string.length() - n == this.getNextProgramCharDistance(string, n) && this.immediatelyPreviousAssignmentOp != null) {
                        this.inStatementIndentStack.pop();
                    }
                    this.inStatementIndentStackSizeStack.push(new Integer(this.inStatementIndentStack.size()));
                    this.registerInStatementIndent(string, n, n3, bl6, true);
                    ++this.parenDepth;
                    if (n != 0) continue;
                    bl7 = false;
                    continue;
                }
                if (this.isInClassHeader) {
                    this.isInClassHeader = false;
                }
                if (this.isInClassHeaderTab) {
                    this.isInClassHeaderTab = false;
                    n2 -= 2;
                }
                this.blockParenDepthStack.push(new Integer(this.parenDepth));
                this.blockStatementStack.push(new Boolean(this.isInStatement));
                this.inStatementIndentStackSizeStack.push(new Integer(this.inStatementIndentStack.size()));
                this.blockTabCount += this.isInStatement ? 1 : 0;
                this.parenDepth = 0;
                this.isInStatement = false;
                this.tempStacks.push(new Stack());
                this.headerStack.push("{");
                string2 = "{";
                continue;
            }
            if (c2 == ' ') {
                n6 = 0;
                int n7 = this.findLegalHeader(string, n, headers);
                if (n7 > -1) {
                    int n8;
                    int n9;
                    int n10;
                    this.isInHeader = true;
                    Stack stack = (Stack)this.tempStacks.peek();
                    if ("if".equals(headers[n7]) && "else".equals(string2)) {
                        this.headerStack.pop();
                    } else if ("else".equals(headers[n7])) {
                        if (stack != null && (n10 = stack.indexOf("if")) != -1) {
                            n9 = stack.size() - n10 - 1;
                            for (n8 = 0; n8 < n9; ++n8) {
                                this.headerStack.push(stack.pop());
                            }
                            if (!bl3) {
                                n2 += n9;
                            }
                        }
                    } else if ("while".equals(headers[n7])) {
                        if (stack != null && (n10 = stack.indexOf("do")) != -1) {
                            n9 = stack.size() - n10 - 1;
                            for (n8 = 0; n8 < n9; ++n8) {
                                this.headerStack.push(stack.pop());
                            }
                            if (!bl3) {
                                n2 += n9;
                            }
                        }
                    } else if ("catch".equals(headers[n7])) {
                        if (stack != null) {
                            n10 = stack.indexOf("try");
                            if (n10 == -1) {
                                n10 = stack.indexOf("catch");
                            }
                            if (n10 != -1) {
                                n9 = stack.size() - n10 - 1;
                                for (n8 = 0; n8 < n9; ++n8) {
                                    this.headerStack.push(stack.pop());
                                }
                                if (!bl3) {
                                    n2 += n9;
                                }
                            }
                        }
                    } else if ("case".equals(headers[n7]) || "default".equals(headers[n7])) {
                        this.isInCase = true;
                        --n2;
                    } else if (("static".equals(headers[n7]) || "synchronized".equals(headers[n7])) && !this.headerStack.isEmpty() && ("static".equals(this.headerStack.lastElement()) || "synchronized".equals(this.headerStack.lastElement()))) {
                        n6 = 1;
                    }
                    if (n6 == 0) {
                        n3 -= this.indentLength;
                        this.headerStack.push(headers[n7]);
                    }
                    string2 = headers[n7];
                    stringBuffer.append(headers[n7].substring(1));
                    n += headers[n7].length() - 1;
                    this.isInStatement = false;
                }
            }
            if (c == '?') {
                this.isInQuestion = true;
            }
            if (c == ':') {
                if (this.isInQuestion) {
                    this.isInQuestion = false;
                } else {
                    this.currentNonSpaceCh = (char)59;
                    if (this.isInCase) {
                        this.isInCase = false;
                        c = ';';
                    }
                }
            }
            if (!(c != ';' && c != ',' || this.inStatementIndentStackSizeStack.isEmpty())) {
                while ((Integer)this.inStatementIndentStackSizeStack.peek() + (this.parenDepth > 0 ? 1 : 0) < this.inStatementIndentStack.size()) {
                    this.inStatementIndentStack.pop();
                }
            }
            if (c == ';' && this.parenDepth == 0 || c == '}' || c == ',' && this.parenDepth == 0) {
                if (c == '}') {
                    if (!this.bracketBlockStateStack.isEmpty() && !((Boolean)this.bracketBlockStateStack.pop()).booleanValue()) {
                        if (this.inStatementIndentStackSizeStack.isEmpty()) continue;
                        n6 = (Integer)this.inStatementIndentStackSizeStack.pop();
                        while (n6 < this.inStatementIndentStack.size()) {
                            this.inStatementIndentStack.pop();
                        }
                        --this.parenDepth;
                        if (n == 0) {
                            bl7 = false;
                        }
                        if (this.parenIndentStack.isEmpty()) continue;
                        Object e = this.parenIndentStack.pop();
                        if (n != 0) continue;
                        n3 = (Integer)e;
                        continue;
                    }
                    if (!this.inStatementIndentStackSizeStack.isEmpty()) {
                        this.inStatementIndentStackSizeStack.pop();
                    }
                    if (!this.blockParenDepthStack.isEmpty()) {
                        this.parenDepth = (Integer)this.blockParenDepthStack.pop();
                        this.isInStatement = (Boolean)this.blockStatementStack.pop();
                        if (this.isInStatement) {
                            --this.blockTabCount;
                        }
                    }
                    bl3 = true;
                    n6 = this.headerStack.search("{");
                    if (n6 != -1) {
                        while (!"{".equals(this.headerStack.pop())) {
                        }
                        if (!this.tempStacks.isEmpty()) {
                            this.tempStacks.pop();
                        }
                    }
                    c = ' ';
                }
                if (!((Stack)this.tempStacks.peek()).isEmpty()) {
                    ((Stack)this.tempStacks.peek()).removeAllElements();
                }
                while (!this.headerStack.isEmpty() && !"{".equals(this.headerStack.peek())) {
                    ((Stack)this.tempStacks.peek()).push(this.headerStack.pop());
                }
                if (this.parenDepth != 0 || c != 59) continue;
                this.isInStatement = false;
                continue;
            }
            if (c2 == ' ' && (n6 = this.findLegalHeader(string, n, preBlockStatements)) > -1) {
                this.isInClassHeader = true;
                stringBuffer.append(preBlockStatements[n6].substring(1));
                n += preBlockStatements[n6].length() - 1;
            }
            this.immediatelyPreviousAssignmentOp = null;
            n6 = 0;
            for (n5 = 0; n5 < nonAssignmentOperators.length; ++n5) {
                if (!string.regionMatches(false, n, nonAssignmentOperators[n5], 0, nonAssignmentOperators[n5].length())) continue;
                stringBuffer.append(nonAssignmentOperators[n5].substring(1));
                ++n;
                n6 = 1;
                break;
            }
            if (n6 == 0) {
                for (n5 = 0; n5 < assignmentOperators.length; ++n5) {
                    if (!string.regionMatches(false, n, assignmentOperators[n5], 0, assignmentOperators[n5].length())) continue;
                    if (assignmentOperators[n5].length() > 1) {
                        stringBuffer.append(assignmentOperators[n5].substring(1));
                        n += assignmentOperators[n5].length() - 1;
                    }
                    this.registerInStatementIndent(string, n, n3, bl6, false);
                    this.immediatelyPreviousAssignmentOp = assignmentOperators[n5];
                    break;
                }
            }
            if (this.parenDepth <= 0 && (this.isLegalNameChar(c) || c == 58)) continue;
            this.isInStatement = true;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '{' && (this.headerStack.size() <= 1 || !"{".equals(this.headerStack.elementAt(this.headerStack.size() - 2))) && bl7) {
            --n2;
        } else if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '}' && bl7) {
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.bracketIndent && stringBuffer.length() > 0 && bl7 && (stringBuffer.charAt(0) == '{' || stringBuffer.charAt(0) == '}')) {
            ++n2;
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.insert(0, this.indentString);
        }
        while (n3-- > 0) {
            stringBuffer.insert(0, ' ');
        }
        if (!this.inStatementIndentStack.isEmpty()) {
            if (this.statementTabCount < 0) {
                this.statementTabCount = n2;
            }
        } else {
            this.statementTabCount = -1;
        }
        return stringBuffer.toString();
    }

    private void registerInStatementIndent(String string, int n, int n2, boolean bl, boolean bl2) {
        int n3 = string.length() - n;
        int n4 = 1;
        n4 = this.getNextProgramCharDistance(string, n);
        if (n4 == n3) {
            int n5 = n2;
            if (!this.inStatementIndentStack.isEmpty()) {
                n5 = (Integer)this.inStatementIndentStack.peek();
            }
            this.inStatementIndentStack.push(new Integer(2 + n5));
            if (bl2) {
                this.parenIndentStack.push(new Integer(n5));
            }
            return;
        }
        if (bl2) {
            this.parenIndentStack.push(new Integer(n + n2));
        }
        int n6 = n + n4 + n2;
        if (n + n4 > this.maxInStatementIndent) {
            n6 = this.indentLength * 2 + n2;
        }
        if (!this.inStatementIndentStack.isEmpty() && n6 < (Integer)this.inStatementIndentStack.peek()) {
            n6 = (Integer)this.inStatementIndentStack.peek();
        }
        this.inStatementIndentStack.push(new Integer(n6));
    }

    private int getNextProgramCharDistance(String string, int n) {
        boolean bl = false;
        int n2 = string.length() - n;
        int n3 = 1;
        for (n3 = 1; n3 < n2; ++n3) {
            char c = string.charAt(n + n3);
            if (bl) {
                if (!string.regionMatches(false, n + n3, "*/", 0, 2)) continue;
                ++n3;
                bl = false;
                continue;
            }
            if (c == ' ' || c == '\t') continue;
            if (c == '/') {
                if (string.regionMatches(false, n + n3, "//", 0, 2)) {
                    return n2;
                }
                if (!string.regionMatches(false, n + n3, "/*", 0, 2)) continue;
                ++n3;
                bl = true;
                continue;
            }
            return n3;
        }
        return n3;
    }

    private boolean isLegalNameChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '$';
    }

    private int findLegalHeader(String string, int n, String[] stringArray) {
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!string.regionMatches(false, n, stringArray[i], 0, stringArray[i].length())) continue;
            int n3 = string.length();
            int n4 = n + stringArray[i].length();
            char c = '\u0000';
            if (n4 < n3) {
                c = string.charAt(n4);
            }
            if (n4 >= n3 || !this.isLegalNameChar(c)) {
                return i;
            }
            return -1;
        }
        return -1;
    }
}

