/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection.notifymap;

import java.util.ArrayList;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.SingleValueMap;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.notifymap.ChangeNotifyMapListener;
import net.infonode.util.collection.notifymap.ConstChangeNotifyMap;

public abstract class AbstractConstChangeNotifyMap
implements ConstChangeNotifyMap {
    private ArrayList listeners;

    public void addListener(ChangeNotifyMapListener changeNotifyMapListener) {
        this.removeListener(changeNotifyMapListener);
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(changeNotifyMapListener);
    }

    public boolean removeListener(ChangeNotifyMapListener changeNotifyMapListener) {
        if (this.listeners != null && this.listeners.remove(changeNotifyMapListener)) {
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
            return true;
        }
        return false;
    }

    protected void fireEntryRemoved(Object object, Object object2) {
        this.fireEntryChanged(object, object2, null);
    }

    protected void fireEntryChanged(Object object, Object object2, Object object3) {
        this.fireEntriesChanged(new SingleValueMap(object, new ValueChange(object2, object3)));
    }

    protected void fireEntriesChanged(ConstMap constMap) {
        if (constMap.isEmpty()) {
            return;
        }
        if (this.listeners != null) {
            ChangeNotifyMapListener[] changeNotifyMapListenerArray = this.listeners.toArray(new ChangeNotifyMapListener[this.listeners.size()]);
            for (int i = 0; i < changeNotifyMapListenerArray.length; ++i) {
                changeNotifyMapListenerArray[i].entriesChanged(constMap);
            }
        }
    }

    protected boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }
}

