/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.titledtab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RotatableLabel;
import net.infonode.gui.TranslatingShape;
import net.infonode.gui.border.FocusBorder;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.gui.hover.hoverable.Hoverable;
import net.infonode.gui.icon.IconProvider;
import net.infonode.gui.layout.StackableLayout;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;
import net.infonode.util.Alignment;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TitledTab
extends Tab
implements IconProvider {
    private TitledTabProperties properties = TitledTabProperties.getDefaultProperties();
    private HoverListener hoverListener = this.properties.getHoverListener();
    private HoverablePanel eventPanel = new HoverablePanel(new BorderLayout()){

        public boolean contains(int n, int n2) {
            return this.getComponentCount() > 0 && this.getComponent(0).contains(n, n2);
        }

        public boolean inside(int n, int n2) {
            return this.getComponentCount() > 0 && this.getComponent(0).inside(n, n2);
        }
    };
    private StatePanel normalStatePanel = new StatePanel();
    private StatePanel highlightedStatePanel = new StatePanel();
    private StatePanel disabledStatePanel = new StatePanel();
    private ArrayList mouseListeners;
    private ArrayList mouseMotionListeners;
    private StackableLayout layout;
    private StatePanel currentStatePanel;
    private static TitledTab pressedTab;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            TitledTab.this.updateTab();
            Map map2 = (Map)map.get(TitledTab.this.properties.getMap());
            if (map2 != null && map2.keySet().contains(TitledTabProperties.HOVER_LISTENER)) {
                HoverListener hoverListener = TitledTab.this.hoverListener;
                TitledTab.this.hoverListener = (HoverListener)((ValueChange)map2.get(TitledTabProperties.HOVER_LISTENER)).getNewValue();
                HoverListener hoverListener2 = (HoverListener)((ValueChange)map2.get(TitledTabProperties.HOVER_LISTENER)).getOldValue();
                if (HoverManager.getInstance().isHovered(TitledTab.this.eventPanel)) {
                    if (hoverListener != null) {
                        hoverListener.mouseExited(new HoverEvent(TitledTab.this));
                    }
                    if (TitledTab.this.hoverListener != null) {
                        TitledTab.this.hoverListener.mouseEntered(new HoverEvent(TitledTab.this));
                    }
                }
            }
        }
    };
    private PropertyMapTreeListener tabbedPanelPropertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            TitledTab.this.updateTab();
        }
    };

    public boolean contains(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this, new Point(n, n2), this.eventPanel);
        return this.eventPanel.contains(point.x, point.y);
    }

    public boolean inside(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this, new Point(n, n2), this.eventPanel);
        return this.eventPanel.inside(point.x, point.y);
    }

    public TitledTab(String string, Icon icon, JComponent jComponent, JComponent jComponent2) {
        super(jComponent);
        this.eventPanel.setOpaque(false);
        this.layout = new StackableLayout(this){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                StatePanel statePanel = (StatePanel)this.getVisibleComponent();
                statePanel.activateTitleComponent();
                TitledTab.this.setFocusableComponent(TitledTab.this.properties.getFocusable() ? statePanel.getFocusableComponent() : null);
            }
        };
        this.setLayout(this.layout);
        this.add(this.normalStatePanel);
        this.add(this.highlightedStatePanel);
        this.add(this.disabledStatePanel);
        this.setText(string);
        this.setIcon(icon);
        this.setTitleComponent(jComponent2);
        this.setEventComponent(this.eventPanel);
        this.updateCurrentStatePanel();
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseClicked(mouseEvent2);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mousePressed(mouseEvent2);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseReleased(mouseEvent2);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseEntered(mouseEvent2);
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseExited(mouseEvent2);
                    }
                }
            }
        };
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseMotionListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseMotionListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseMotionListener)objectArray[i]).mouseDragged(mouseEvent2);
                    }
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseMotionListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseMotionListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseMotionListener)objectArray[i]).mouseMoved(mouseEvent2);
                    }
                }
            }
        };
        this.eventPanel.addMouseListener(mouseListener);
        this.eventPanel.addMouseMotionListener(mouseMotionListener);
        PropertyMapWeakListenerManager.addWeakTreeListener(this.properties.getMap(), this.propertiesListener);
        this.addTabListener(new TabAdapter(){

            public void tabAdded(TabEvent tabEvent) {
                PropertyMapWeakListenerManager.addWeakTreeListener(TitledTab.this.getTabbedPanel().getProperties().getMap(), TitledTab.this.tabbedPanelPropertiesListener);
                TitledTab.this.updateTab();
            }

            public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
                PropertyMapWeakListenerManager.removeWeakTreeListener(tabRemovedEvent.getTabbedPanel().getProperties().getMap(), TitledTab.this.tabbedPanelPropertiesListener);
                TitledTab.this.updateTab();
            }
        });
    }

    public JComponent getNormalStateTitleComponent() {
        return this.normalStatePanel.getTitleComponent();
    }

    public JComponent getHighlightedStateTitleComponent() {
        return this.highlightedStatePanel.getTitleComponent();
    }

    public JComponent getDisabledStateTitleComponent() {
        return this.disabledStatePanel.getTitleComponent();
    }

    public void setTitleComponent(JComponent jComponent) {
        this.normalStatePanel.setTitleComponent(jComponent);
        this.highlightedStatePanel.setTitleComponent(jComponent);
        this.disabledStatePanel.setTitleComponent(jComponent);
        this.updateTab();
    }

    public void setNormalStateTitleComponent(JComponent jComponent) {
        this.normalStatePanel.setTitleComponent(jComponent);
        this.updateTab();
    }

    public void setHighlightedStateTitleComponent(JComponent jComponent) {
        this.highlightedStatePanel.setTitleComponent(jComponent);
        this.updateTab();
    }

    public void setDisabledStateTitleComponent(JComponent jComponent) {
        this.disabledStatePanel.setTitleComponent(jComponent);
        this.updateTab();
    }

    public void setHighlighted(boolean bl) {
        super.setHighlighted(bl);
        this.updateCurrentStatePanel();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateCurrentStatePanel();
    }

    public String getText() {
        return this.properties.getNormalProperties().getText();
    }

    public void setText(String string) {
        this.properties.getNormalProperties().setText(string);
    }

    public Icon getIcon() {
        return this.properties.getNormalProperties().getIcon();
    }

    public void setIcon(Icon icon) {
        this.properties.getNormalProperties().setIcon(icon);
    }

    public TitledTabProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getText();
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new ArrayList(2);
        }
        this.mouseListeners.add(mouseListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(mouseListener);
            if (this.mouseListeners.size() == 0) {
                this.mouseListeners = null;
            }
        }
    }

    public synchronized MouseListener[] getMouseListeners() {
        MouseListener[] mouseListenerArray = new MouseListener[]{};
        if (this.mouseListeners != null) {
            Object[] objectArray = this.mouseListeners.toArray();
            mouseListenerArray = new MouseListener[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                mouseListenerArray[i] = (MouseListener)objectArray[i];
            }
        }
        return mouseListenerArray;
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.mouseMotionListeners == null) {
            this.mouseMotionListeners = new ArrayList(2);
        }
        this.mouseMotionListeners.add(mouseMotionListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.mouseMotionListeners != null) {
            this.mouseMotionListeners.remove(mouseMotionListener);
            if (this.mouseMotionListeners.size() == 0) {
                this.mouseMotionListeners = null;
            }
        }
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        MouseMotionListener[] mouseMotionListenerArray = new MouseMotionListener[]{};
        if (this.mouseMotionListeners != null) {
            Object[] objectArray = this.mouseMotionListeners.toArray();
            mouseMotionListenerArray = new MouseMotionListener[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                mouseMotionListenerArray[i] = (MouseMotionListener)objectArray[i];
            }
        }
        return mouseMotionListenerArray;
    }

    public Shape getShape() {
        Shape shape = this.currentStatePanel.getShape();
        if (shape == null) {
            return null;
        }
        Point point = SwingUtilities.convertPoint(this.currentStatePanel, 0, 0, this);
        return new TranslatingShape(shape, point.x, point.y);
    }

    protected void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (tabbedPanel == null) {
            HoverManager.getInstance().removeHoverable(this.eventPanel);
        }
        super.setTabbedPanel(tabbedPanel);
        if (tabbedPanel != null) {
            HoverManager.getInstance().addHoverable(this.eventPanel);
        }
    }

    private Insets getBorderInsets(Border border) {
        return border == null ? InsetsUtil.EMPTY_INSETS : border.getBorderInsets(this);
    }

    private void updateTab() {
        if (this.getTabbedPanel() != null) {
            this.layout.setUseSelectedComponentSize(this.getProperties().getSizePolicy() == TitledTabSizePolicy.INDIVIDUAL_SIZE);
            Direction direction = this.getTabbedPanel().getProperties().getTabAreaOrientation();
            int n = this.properties.getHighlightedRaised();
            Insets insets = InsetsUtil.setInset(InsetsUtil.EMPTY_INSETS, direction, n);
            EmptyBorder emptyBorder = new EmptyBorder(insets);
            Insets insets2 = this.properties.getBorderSizePolicy() == TitledTabBorderSizePolicy.INDIVIDUAL_SIZE ? null : InsetsUtil.max(this.getBorderInsets(this.properties.getNormalProperties().getComponentProperties().getBorder()), InsetsUtil.max(this.getBorderInsets(this.properties.getHighlightedProperties().getComponentProperties().getBorder()), this.getBorderInsets(this.properties.getDisabledProperties().getComponentProperties().getBorder())));
            Insets insets3 = InsetsUtil.rotate(this.properties.getNormalProperties().getDirection(), this.properties.getNormalProperties().getComponentProperties().getInsets());
            Insets insets4 = InsetsUtil.rotate(this.properties.getDisabledProperties().getDirection(), this.properties.getDisabledProperties().getComponentProperties().getInsets());
            int n2 = Math.min(InsetsUtil.getInset(insets3, direction.getOpposite()), InsetsUtil.getInset(insets4, direction.getOpposite()));
            int n3 = Math.min(n2, n);
            Border border = this.getInnerBorder(this.properties.getNormalProperties(), direction, -n3, insets2);
            Border border2 = this.getInnerBorder(this.properties.getHighlightedProperties(), direction, n - n3, insets2);
            Border border3 = this.getInnerBorder(this.properties.getDisabledProperties(), direction, -n3, insets2);
            this.normalStatePanel.updateStatePanel(this.properties.getNormalProperties(), emptyBorder, border);
            this.highlightedStatePanel.updateStatePanel(this.properties.getHighlightedProperties(), null, border2);
            this.disabledStatePanel.updateStatePanel(this.properties.getDisabledProperties(), emptyBorder, border3);
            this.updateCurrentStatePanel();
        }
    }

    private Border getInnerBorder(TitledTabStateProperties titledTabStateProperties, Direction direction, int n, Insets insets) {
        Direction direction2 = titledTabStateProperties.getDirection();
        Insets insets2 = InsetsUtil.rotate(direction2, titledTabStateProperties.getComponentProperties().getInsets());
        if (insets != null) {
            insets2 = InsetsUtil.add(insets2, InsetsUtil.sub(insets, this.getBorderInsets(titledTabStateProperties.getComponentProperties().getBorder())));
        }
        Border border = titledTabStateProperties.getComponentProperties().getBorder();
        EmptyBorder emptyBorder = new EmptyBorder(InsetsUtil.add(insets2, InsetsUtil.setInset(InsetsUtil.EMPTY_INSETS, direction.getOpposite(), n)));
        return border == null ? emptyBorder : new CompoundBorder(border, emptyBorder);
    }

    private void updateCurrentStatePanel() {
        StatePanel statePanel = this.normalStatePanel;
        if (!this.isEnabled()) {
            statePanel = this.disabledStatePanel;
        } else if (this.isHighlighted()) {
            statePanel = this.highlightedStatePanel;
        }
        this.eventPanel.setToolTipText(statePanel.getToolTipText());
        if (this.currentStatePanel != statePanel) {
            if (this.currentStatePanel != null) {
                this.currentStatePanel.deactivate();
            }
            this.currentStatePanel = statePanel;
            this.currentStatePanel.activate();
        }
        this.layout.showComponent(this.currentStatePanel);
    }

    private MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((JComponent)mouseEvent.getSource(), mouseEvent.getPoint(), this);
        return new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)point.getX(), (int)point.getY(), mouseEvent.getClickCount(), !mouseEvent.isConsumed() && mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    private class HoverablePanel
    extends JPanel
    implements Hoverable {
        public HoverablePanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public void hoverEnter() {
            if (TitledTab.this.hoverListener != null && TitledTab.this.getTabbedPanel() != null) {
                TitledTab.this.hoverListener.mouseEntered(new HoverEvent(TitledTab.this));
            }
        }

        public void hoverExit() {
            if (TitledTab.this.hoverListener != null) {
                TitledTab.this.hoverListener.mouseExited(new HoverEvent(TitledTab.this));
            }
        }

        public boolean acceptHover(ArrayList arrayList) {
            return true;
        }
    }

    private class StatePanel
    extends JPanel {
        private ShapedPanel panel = new ShapedPanel();
        private JPanel titleComponentPanel = new JPanel(new BorderLayout());
        private RotatableLabel label = new RotatableLabel(this, null, null){
            private final /* synthetic */ StatePanel this$1;
            {
                this.this$1 = statePanel;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                String string = this.getText();
                Icon icon = this.getIcon();
                if (string == null || icon == null) {
                    this.setText(" ");
                    this.setIcon(StatePanel.access$000(this.this$1));
                    dimension = this.getDirection().isHorizontal() ? new Dimension(dimension.width, super.getPreferredSize().height) : new Dimension(super.getPreferredSize().width, dimension.height);
                    this.setText(string);
                    this.setIcon(icon);
                }
                return dimension;
            }
        };
        private JComponent titleComponent;
        private boolean titleComponentChanged = true;
        private Direction currentLayoutDirection;
        private int currentLayoutGap = -1;
        private Alignment currentLayoutAlignment;
        private String toolTipText;
        private Icon icon;

        public StatePanel() {
            super(new BorderLayout());
            this.panel.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.titleComponentPanel.setOpaque(false);
            this.label.setBorder(new FocusBorder(this.label));
            this.label.setMinimumSize(new Dimension(0, 0));
            this.panel.add((Component)this.label, "Center");
            this.add((Component)this.panel, "Center");
        }

        public void updateStatePanel(TitledTabStateProperties titledTabStateProperties, Border border, Border border2) {
            this.titleComponentChanged = true;
            String string = this.toolTipText = titledTabStateProperties.getToolTipEnabled() ? titledTabStateProperties.getToolTipText() : null;
            if (this.toolTipText != null && this.toolTipText.length() == 0) {
                this.toolTipText = null;
            }
            this.setBorder(border);
            this.updateLayout(titledTabStateProperties);
            this.updateLabel(titledTabStateProperties);
            this.updatePanel(border2, titledTabStateProperties);
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public JComponent getTitleComponent() {
            return this.titleComponent;
        }

        public Shape getShape() {
            return this.panel.getShape();
        }

        public void setTitleComponent(JComponent jComponent) {
            JComponent jComponent2 = this.titleComponent;
            this.titleComponent = null;
            if (jComponent2 != null && jComponent2.getParent() == this.titleComponentPanel) {
                this.titleComponentPanel.remove(jComponent2);
            }
            this.titleComponent = jComponent;
            this.titleComponentChanged = true;
        }

        public void activateTitleComponent() {
            if (this.titleComponent != null) {
                if (this.titleComponent.getParent() != this.titleComponentPanel) {
                    if (this.titleComponent.getParent() != null) {
                        this.titleComponent.getParent().remove(this.titleComponent);
                    }
                    this.titleComponentPanel.add((Component)this.titleComponent, "Center");
                }
            } else {
                this.titleComponentPanel.removeAll();
            }
        }

        public void activate() {
            this.remove(this.panel);
            TitledTab.this.eventPanel.add((Component)this.panel, "Center");
            this.add((Component)TitledTab.this.eventPanel, "Center");
        }

        public void deactivate() {
            this.remove(TitledTab.this.eventPanel);
            TitledTab.this.eventPanel.remove(this.panel);
            this.add((Component)this.panel, "Center");
        }

        public Dimension getPreferredSize() {
            this.activateTitleComponent();
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            this.activateTitleComponent();
            return super.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            this.activateTitleComponent();
            return super.getMaximumSize();
        }

        public JComponent getFocusableComponent() {
            return this.label;
        }

        private void updateLayout(TitledTabStateProperties titledTabStateProperties) {
            if (this.titleComponent != null && titledTabStateProperties.getTitleComponentVisible()) {
                Direction direction = titledTabStateProperties.getDirection();
                int n = titledTabStateProperties.getIconVisible() || titledTabStateProperties.getTextVisible() ? titledTabStateProperties.getTextTitleComponentGap() : 0;
                Alignment alignment = titledTabStateProperties.getTitleComponentTextRelativeAlignment();
                if (this.titleComponentPanel.getComponentCount() == 0 || this.titleComponentPanel.getComponentCount() > 0 && this.titleComponentPanel.getComponent(0) != this.titleComponent || this.titleComponentChanged || n != this.currentLayoutGap || alignment != this.currentLayoutAlignment || direction != this.currentLayoutDirection) {
                    this.titleComponentChanged = false;
                    this.currentLayoutDirection = direction;
                    this.currentLayoutGap = n;
                    this.currentLayoutAlignment = alignment;
                    this.panel.remove(this.titleComponentPanel);
                    if (direction == Direction.UP) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "South" : "North");
                        this.titleComponentPanel.setBorder(new EmptyBorder(alignment == Alignment.LEFT ? n : 0, 0, alignment == Alignment.LEFT ? 0 : n, 0));
                    } else if (direction == Direction.LEFT) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "East" : "West");
                        this.titleComponentPanel.setBorder(new EmptyBorder(0, alignment == Alignment.LEFT ? n : 0, 0, alignment == Alignment.LEFT ? 0 : n));
                    } else if (direction == Direction.DOWN) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "North" : "South");
                        this.titleComponentPanel.setBorder(new EmptyBorder(alignment == Alignment.LEFT ? 0 : n, 0, alignment == Alignment.LEFT ? n : 0, 0));
                    } else {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "West" : "East");
                        this.titleComponentPanel.setBorder(new EmptyBorder(0, alignment == Alignment.LEFT ? 0 : n, 0, alignment == Alignment.LEFT ? n : 0));
                    }
                }
            } else {
                this.panel.remove(this.titleComponentPanel);
                this.titleComponentPanel.removeAll();
            }
        }

        private void updateLabel(TitledTabStateProperties titledTabStateProperties) {
            this.icon = titledTabStateProperties.getIcon();
            if (titledTabStateProperties.getIconVisible()) {
                this.label.setIcon(this.icon);
            } else {
                this.label.setIcon(null);
            }
            if (titledTabStateProperties.getTextVisible()) {
                this.label.setText(titledTabStateProperties.getText());
            } else {
                this.label.setText(null);
            }
            this.label.setFont(titledTabStateProperties.getComponentProperties().getFont());
            this.label.setForeground(titledTabStateProperties.getComponentProperties().getForegroundColor());
            if (titledTabStateProperties.getIconVisible() && titledTabStateProperties.getTextVisible()) {
                this.label.setIconTextGap(titledTabStateProperties.getIconTextGap());
            } else {
                this.label.setIconTextGap(0);
            }
            this.label.setDirection(titledTabStateProperties.getDirection());
            Alignment alignment = titledTabStateProperties.getHorizontalAlignment();
            this.label.setHorizontalAlignment(alignment == Alignment.LEFT ? 2 : (alignment == Alignment.CENTER ? 0 : 4));
            alignment = titledTabStateProperties.getVerticalAlignment();
            this.label.setVerticalAlignment(alignment == Alignment.TOP ? 1 : (alignment == Alignment.CENTER ? 0 : 3));
            alignment = titledTabStateProperties.getIconTextRelativeAlignment();
            this.label.setHorizontalTextPosition(alignment == Alignment.LEFT ? 4 : 2);
        }

        private void updatePanel(Border border, TitledTabStateProperties titledTabStateProperties) {
            ComponentProperties componentProperties = titledTabStateProperties.getComponentProperties();
            ShapedPanelProperties shapedPanelProperties = titledTabStateProperties.getShapedPanelProperties();
            Direction direction = TitledTab.this.getTabbedPanel().getProperties().getTabAreaOrientation();
            this.panel.setDirection(direction.getNextCW());
            this.panel.setBorder(border);
            this.panel.setForeground(componentProperties.getForegroundColor());
            this.panel.setBackground(componentProperties.getBackgroundColor());
            ComponentPainter componentPainter = shapedPanelProperties.getComponentPainter();
            Color color = componentProperties.getBackgroundColor();
            if (componentPainter != null) {
                this.panel.setComponentPainter(componentPainter);
            } else if (color != null) {
                this.panel.setComponentPainter(SolidColorComponentPainter.BACKGROUND_COLOR_PAINTER);
            } else {
                this.panel.setComponentPainter(null);
            }
            this.panel.setHorizontalFlip(direction == Direction.DOWN || direction == Direction.LEFT ? !shapedPanelProperties.getHorizontalFlip() : shapedPanelProperties.getHorizontalFlip());
            this.panel.setVerticalFlip(shapedPanelProperties.getVerticalFlip());
            this.panel.setClipChildren(shapedPanelProperties.getClipChildren());
        }

        static /* synthetic */ Icon access$000(StatePanel statePanel) {
            return statePanel.icon;
        }
    }
}

