/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelHoverPolicy;

public class TabbedHoverUtil {
    public static boolean isDeepestHoverableTabbedPanel(ArrayList arrayList, TabbedPanel tabbedPanel) {
        for (Component component = (Component)arrayList.get(0); component != null; component = component.getParent()) {
            if (component instanceof TabbedPanel) {
                return component == tabbedPanel;
            }
            if (!(component instanceof TabbedPanelContentPanel)) continue;
            return ((TabbedPanelContentPanel)component).getTabbedPanel() == tabbedPanel;
        }
        return true;
    }

    public static boolean hasVisibleTabbedPanelChild(Component component) {
        if (component instanceof TabbedPanel) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!container.getComponent(i).isVisible() || !TabbedHoverUtil.hasVisibleTabbedPanelChild(container.getComponent(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean acceptTabbedPanelHover(TabbedPanelHoverPolicy tabbedPanelHoverPolicy, ArrayList arrayList, TabbedPanel tabbedPanel, Component component) {
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.NO_HOVERED_CHILD) {
            return TabbedHoverUtil.isDeepestHoverableTabbedPanel(arrayList, tabbedPanel);
        }
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.NEVER) {
            return false;
        }
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.ALWAYS) {
            return true;
        }
        if (tabbedPanelHoverPolicy == TabbedPanelHoverPolicy.ONLY_WHEN_DEEPEST && component != null) {
            return !TabbedHoverUtil.hasVisibleTabbedPanelChild(component);
        }
        return false;
    }
}

