/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.infonode.properties.propertymap.PropertyMapImpl;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.util.Utils;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;

public class PropertyMapManager {
    private static final PropertyMapManager INSTANCE = new PropertyMapManager();
    private HashMap changes;
    private int batchCounter;

    public static PropertyMapManager getInstance() {
        return INSTANCE;
    }

    void addMapChanges(PropertyMapImpl propertyMapImpl, ConstMap constMap) {
        HashMap<Object, ValueChange> hashMap = (HashMap<Object, ValueChange>)this.changes.get(propertyMapImpl);
        if (hashMap == null) {
            hashMap = new HashMap<Object, ValueChange>();
            this.changes.put(propertyMapImpl, hashMap);
        }
        ConstMapIterator constMapIterator = constMap.constIterator();
        while (constMapIterator.atEntry()) {
            Object object;
            ValueChange valueChange = (ValueChange)constMapIterator.getValue();
            Object object2 = constMapIterator.getKey();
            Object object3 = valueChange.getNewValue() == null ? null : ((PropertyValue)valueChange.getNewValue()).get(propertyMapImpl);
            Object v = hashMap.get(object2);
            Object object4 = v == null ? (valueChange.getOldValue() == null ? null : ((PropertyValue)valueChange.getOldValue()).get(propertyMapImpl)) : (object = ((ValueChange)v).getOldValue());
            if (!Utils.equals(object, object3)) {
                hashMap.put(constMapIterator.getKey(), new ValueChange(object, object3));
            } else if (v != null) {
                hashMap.remove(object2);
            }
            constMapIterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBatch(Runnable runnable) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            runnable.run();
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public void beginBatch() {
        if (this.batchCounter++ == 0) {
            this.changes = new HashMap();
        }
    }

    private void addTreeChanges(PropertyMapImpl propertyMapImpl, PropertyMapImpl propertyMapImpl2, HashMap hashMap, HashMap hashMap2) {
        HashMap<PropertyMapImpl, HashMap> hashMap3 = (HashMap<PropertyMapImpl, HashMap>)hashMap2.get(propertyMapImpl);
        if (hashMap3 == null) {
            hashMap3 = new HashMap<PropertyMapImpl, HashMap>();
            hashMap2.put(propertyMapImpl, hashMap3);
        }
        hashMap3.put(propertyMapImpl2, hashMap);
        if (propertyMapImpl.getParent() != null) {
            this.addTreeChanges(propertyMapImpl.getParent(), propertyMapImpl2, hashMap, hashMap2);
        }
    }

    public void endBatch() {
        if (--this.batchCounter == 0) {
            HashMap hashMap;
            PropertyMapImpl propertyMapImpl;
            Map.Entry entry;
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = this.changes;
            this.changes = null;
            Iterator iterator = hashMap3.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                propertyMapImpl = (PropertyMapImpl)entry.getKey();
                hashMap = (HashMap)entry.getValue();
                propertyMapImpl.firePropertyValuesChanged(Collections.unmodifiableMap(hashMap));
                this.addTreeChanges(propertyMapImpl, propertyMapImpl, hashMap, hashMap2);
            }
            iterator = hashMap2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                propertyMapImpl = (PropertyMapImpl)entry.getKey();
                hashMap = (HashMap)entry.getValue();
                propertyMapImpl.firePropertyTreeValuesChanged(Collections.unmodifiableMap(hashMap));
            }
        }
    }
}

