/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import net.infonode.gui.HighlightPainter;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundPainterColorProvider;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.shaped.ShapedUtil;
import net.infonode.gui.shaped.border.AbstractShapedBorder;
import net.infonode.gui.shaped.panel.ShapedPanel;

public abstract class AbstractPolygonBorder
extends AbstractShapedBorder {
    private static final long serialVersionUID = 1L;
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 0, 0);
    private ColorProvider lineColor;
    private ColorProvider highlightColor = new FixedColorProvider(new Color(255, 255, 255));
    private ColorProvider middleColor;
    private ColorProvider shadowColor;

    protected AbstractPolygonBorder(ColorProvider colorProvider) {
        this(colorProvider, FixedColorProvider.WHITE);
    }

    protected AbstractPolygonBorder(ColorProvider colorProvider, ColorProvider colorProvider2) {
        this(colorProvider, colorProvider2, BackgroundPainterColorProvider.INSTANCE, null);
    }

    protected AbstractPolygonBorder(ColorProvider colorProvider, ColorProvider colorProvider2, ColorProvider colorProvider3, ColorProvider colorProvider4) {
        this.lineColor = colorProvider;
        this.highlightColor = colorProvider2;
        this.middleColor = colorProvider3;
        this.shadowColor = colorProvider4;
    }

    public Shape getShape(Component component, int n, int n2, int n3, int n4) {
        int n5 = ShapedUtil.getWidth(component, n3, n4);
        int n6 = ShapedUtil.getHeight(component, n3, n4);
        Polygon polygon = this.getPolygon(component, n, n2, n5, n6);
        return polygon;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Shape shape = graphics.getClip();
        graphics.clipRect(n, n2, n3, n4);
        try {
            int n5 = ShapedUtil.getWidth(component, n3, n4);
            n4 = ShapedUtil.getHeight(component, n3, n4);
            n3 = n5;
            Polygon polygon = this.getPolygon(component, n, n2, n3, n4);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.highlightColor != null) {
                this.paintHighlight(component, graphics2D, polygon, n3, n4);
            }
            if (this.lineColor != null) {
                graphics.setColor(this.lineColor.getColor());
                this.paintPolygon(component, graphics2D, polygon, n3, n4);
            }
        }
        finally {
            graphics.setClip(shape);
        }
    }

    public Insets getBorderInsets(Component component) {
        Insets insets = this.getShapedBorderInsets(component);
        insets = ShapedUtil.transformInsets(component, insets);
        return this.highlightColor != null ? InsetsUtil.add(this.getShapedBorderHighlightInsets(component), insets) : insets;
    }

    protected Insets getShapedBorderInsets(Component component) {
        return new Insets(0, 0, 0, 0);
    }

    protected Insets getShapedBorderHighlightInsets(Component component) {
        return HIGHLIGHT_INSETS;
    }

    protected Polygon createPolygon(Component component, int n, int n2) {
        return new Polygon();
    }

    protected void paintPolygon(Component component, Graphics2D graphics2D, Polygon polygon, int n, int n2) {
        for (int i = 0; i < polygon.npoints; ++i) {
            if (!this.lineIsDrawn(i, polygon)) continue;
            int n3 = (i + 1) % polygon.npoints;
            graphics2D.drawLine(polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[n3], polygon.ypoints[n3]);
        }
    }

    protected void paintHighlight(Component component, Graphics2D graphics2D, Polygon polygon, int n, int n2) {
        Color color = this.highlightColor == null ? null : this.highlightColor.getColor(component);
        Color color2 = this.middleColor.getColor(component);
        Color color3 = this.shadowColor == null ? null : this.shadowColor.getColor(component);
        boolean bl = this.isPointsClockwise(component);
        for (int i = 0; i < polygon.npoints; ++i) {
            int n3 = (i + 1) % polygon.npoints;
            if (!this.lineIsDrawn(i, polygon)) continue;
            HighlightPainter.drawLine(graphics2D, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[n3], polygon.ypoints[n3], bl, true, color, color2, color3);
        }
    }

    protected boolean lineIsDrawn(int n, Polygon polygon) {
        return true;
    }

    protected boolean isHighlightable(int n, int n2) {
        return n > n2;
    }

    protected boolean isPointsClockwise(Component component) {
        if (component instanceof ShapedPanel) {
            return !(((ShapedPanel)component).isHorizontalFlip() ^ ((ShapedPanel)component).isVerticalFlip());
        }
        return true;
    }

    protected int getHighlightOffsetX(int n, int n2) {
        return n2 - n > 0 ? (n + n2 > 0 ? -1 : 0) : (n + n2 > 0 ? 0 : 1);
    }

    protected int getHighlightOffsetY(int n, int n2) {
        return n2 - n > 0 ? (n + n2 > 0 ? 0 : -1) : (n + n2 > 0 ? 1 : 0);
    }

    protected void setPoint(Polygon polygon, int n, int n2) {
        polygon.xpoints[polygon.npoints] = n;
        polygon.ypoints[polygon.npoints] = n2;
        ++polygon.npoints;
    }

    private Polygon getPolygon(Component component, int n, int n2, int n3, int n4) {
        Polygon polygon = this.createPolygon(component, n3, n4);
        this.flipPolygon(component, polygon, n3, n4);
        this.rotatePolygon(component, polygon, n3, n4);
        this.fixGraphicsOffset(component, polygon, n, n2);
        return polygon;
    }

    private void flipPolygon(Component component, Polygon polygon, int n, int n2) {
        if (component instanceof ShapedPanel) {
            int n3;
            if (((ShapedPanel)component).isHorizontalFlip()) {
                for (n3 = 0; n3 < polygon.npoints; ++n3) {
                    polygon.xpoints[n3] = Math.abs(n - polygon.xpoints[n3]) - 1;
                }
            }
            if (((ShapedPanel)component).isVerticalFlip()) {
                for (n3 = 0; n3 < polygon.npoints; ++n3) {
                    polygon.ypoints[n3] = Math.abs(n2 - polygon.ypoints[n3]) - 1;
                }
            }
        }
    }

    private void rotatePolygon(Component component, Polygon polygon, int n, int n2) {
        ShapedUtil.rotate(polygon, ShapedUtil.getDirection(component), n, n2);
    }

    private void fixGraphicsOffset(Component component, Polygon polygon, int n, int n2) {
        int n3 = 0;
        while (n3 < polygon.npoints) {
            int n4 = n3;
            polygon.xpoints[n4] = polygon.xpoints[n4] + n;
            int n5 = n3++;
            polygon.ypoints[n5] = polygon.ypoints[n5] + n2;
        }
    }
}

