/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.laf;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import net.infonode.gui.border.EdgeBorder;
import net.infonode.gui.border.EtchedLineBorder;
import net.infonode.gui.border.HighlightBorder;
import net.infonode.gui.border.PopupMenuBorder;
import net.infonode.gui.icon.EmptyIcon;
import net.infonode.gui.icon.button.BorderIcon;
import net.infonode.gui.icon.button.CloseIcon;
import net.infonode.gui.icon.button.MaximizeIcon;
import net.infonode.gui.icon.button.MinimizeIcon;
import net.infonode.gui.icon.button.RestoreIcon;
import net.infonode.gui.icon.button.WindowIcon;
import net.infonode.gui.laf.value.BorderValue;
import net.infonode.gui.laf.value.ColorValue;
import net.infonode.gui.laf.value.FontValue;
import net.infonode.util.ArrayUtil;
import net.infonode.util.ColorUtil;

public class InfoNodeLookAndFeelTheme {
    private static final float PRIMARY_HUE = 0.61f;
    private static final float PRIMARY_SATURATION = 0.6f;
    private static final float PRIMARY_BRIGHTNESS = 0.67f;
    public static final Color DEFAULT_CONTROL_COLOR = Color.getHSBColor(0.12f, 0.058f, 0.89f);
    public static final Color DEFAULT_PRIMARY_CONTROL_COLOR = Color.getHSBColor(0.61f, 0.6f, 1.0f);
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(250, 250, 247);
    public static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    public static final Color DEFAULT_SELECTED_BACKGROUND_COLOR = Color.getHSBColor(0.61f, 0.70000005f, 0.67f);
    public static final Color DEFAULT_SELECTED_TEXT_COLOR = Color.WHITE;
    public static final Color DEFAULT_TOOLTIP_BACKGROUND_COLOR = new Color(255, 255, 180);
    public static final Color DEFAULT_TOOLTIP_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_DESKTOP_COLOR = Color.getHSBColor(0.59000003f, 0.6f, 0.67f);
    public static final int DEFAULT_FONT_SIZE = 11;
    private static final String[] FONT_NAMES = new String[]{"Dialog"};
    private FontUIResource font = new FontUIResource("Dialog", 0, 11);
    private FontUIResource boldFont;
    private ColorValue controlColor = new ColorValue();
    private ColorValue primaryControlColor = new ColorValue();
    private ColorValue backgroundColor = new ColorValue();
    private ColorValue textColor = new ColorValue();
    private ColorValue selectedTextBackgroundColor = new ColorValue();
    private ColorValue focusColor = new ColorValue();
    private ColorValue selectedTextColor = new ColorValue();
    private ColorValue tooltipBackgroundColor = new ColorValue(DEFAULT_TOOLTIP_BACKGROUND_COLOR);
    private ColorValue tooltipForegroundColor = new ColorValue(DEFAULT_TOOLTIP_FOREGROUND_COLOR);
    private ColorValue desktopColor = new ColorValue(DEFAULT_DESKTOP_COLOR);
    private ColorValue treeIconBackgroundColor = new ColorValue();
    private ColorValue selectedMenuBackgroundColor = new ColorValue();
    private ColorValue selectedMenuForegroundColor = new ColorValue();
    private ColorValue inactiveTextColor = new ColorValue();
    private ColorUIResource controlHighlightColor;
    private ColorUIResource controlLightShadowColor;
    private ColorUIResource controlShadowColor;
    private ColorUIResource controlDarkShadowColor;
    private ColorUIResource primaryControlHighlightColor;
    private ColorUIResource primaryControlShadowColor;
    private ColorUIResource primaryControlDarkShadowColor;
    private ColorValue scrollBarBackgroundColor = new ColorValue();
    private ColorUIResource scrollBarBackgroundShadowColor;
    private ColorValue activeInternalFrameTitleBackgroundColor = new ColorValue();
    private ColorValue inactiveInternalFrameTitleBackgroundColor = new ColorValue();
    private IconUIResource internalFrameIcon = new IconUIResource(new BorderIcon(new WindowIcon(Color.BLACK, 12), 2));
    private IconUIResource internalFrameIconifyIcon = new IconUIResource(new MinimizeIcon());
    private IconUIResource internalFrameMinimizeIcon = new IconUIResource(new RestoreIcon());
    private IconUIResource internalFrameMaximizeIcon = new IconUIResource(new MaximizeIcon());
    private IconUIResource internalFrameCloseIcon = new IconUIResource(new CloseIcon());
    private BorderUIResource internalFrameBorder = new BorderUIResource(new LineBorder(Color.BLACK, 2));
    private FontValue internalFrameTitleFont = new FontValue();
    private FontValue optionPaneButtonFont = new FontValue();
    private IconUIResource treeOpenIcon = new IconUIResource(EmptyIcon.INSTANCE);
    private IconUIResource treeClosedIcon = new IconUIResource(EmptyIcon.INSTANCE);
    private IconUIResource treeLeafIcon = new IconUIResource(EmptyIcon.INSTANCE);
    private BorderValue menuBarBorder = new BorderValue();
    private BorderValue popupMenuBorder = new BorderValue();
    private BorderValue tableHeaderCellBorder = new BorderValue();
    private BorderValue textFieldBorder = new BorderValue();
    private BorderValue listItemBorder = new BorderValue(new EmptyBorder(1, 4, 1, 4));
    private BorderValue listFocusedItemBorder = new BorderValue();
    private int splitPaneDividerSize = 7;
    private int scrollBarWidth = 17;
    private InsetsUIResource buttonMargin = new InsetsUIResource(1, 6, 1, 6);
    private double shadingFactor = 1.6;
    private String name;

    public InfoNodeLookAndFeelTheme() {
        this("Default Theme", DEFAULT_CONTROL_COLOR, DEFAULT_PRIMARY_CONTROL_COLOR, DEFAULT_BACKGROUND_COLOR, DEFAULT_TEXT_COLOR, DEFAULT_SELECTED_BACKGROUND_COLOR, DEFAULT_SELECTED_TEXT_COLOR);
    }

    public InfoNodeLookAndFeelTheme(String string, Color color, Color color2, Color color3, Color color4) {
        this(string, color, color2, color3, color4, color2, ColorUtil.getOpposite(color2));
    }

    public InfoNodeLookAndFeelTheme(String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        this(string, color, color2, color3, color4, color5, color6, 1.3);
    }

    public InfoNodeLookAndFeelTheme(String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, double d) {
        this.name = string;
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < FONT_NAMES.length; ++i) {
            if (!ArrayUtil.containsEqual(objectArray, FONT_NAMES[i])) continue;
            this.font = new FontUIResource(new Font(FONT_NAMES[i], 0, 11));
            break;
        }
        this.updateFonts();
        this.controlColor.setColor(color);
        this.primaryControlColor.setColor(color2);
        this.backgroundColor.setColor(color3);
        this.selectedTextBackgroundColor.setColor(color5);
        this.selectedTextColor.setColor(color6);
        this.textColor.setColor(color4);
        this.shadingFactor = d;
        this.updateColors();
    }

    private void updateFonts() {
        this.boldFont = new FontUIResource(this.font.deriveFont(1));
        this.internalFrameTitleFont.setDefaultFont(this.boldFont);
        this.optionPaneButtonFont.setDefaultFont(this.boldFont);
    }

    private void updateColors() {
        this.focusColor.setDefaultColor(ColorUtil.blend(this.controlColor.getColor(), this.textColor.getColor(), 0.5));
        this.inactiveTextColor.setDefaultColor(this.focusColor);
        double d = 1.0 / (1.0 + this.shadingFactor * 1.2);
        double d2 = 1.0 / (1.0 + this.shadingFactor / 2.0);
        double d3 = 1.0 / (1.0 + this.shadingFactor / 7.0);
        this.controlHighlightColor = new ColorUIResource(ColorUtil.mult(this.controlColor.getColor(), 1.0 + this.shadingFactor));
        this.controlLightShadowColor = new ColorUIResource(ColorUtil.mult(this.controlColor.getColor(), d3));
        this.controlShadowColor = new ColorUIResource(ColorUtil.mult(this.controlColor.getColor(), d2));
        this.controlDarkShadowColor = new ColorUIResource(ColorUtil.mult(this.controlColor.getColor(), d));
        this.primaryControlHighlightColor = this.controlHighlightColor;
        this.primaryControlShadowColor = new ColorUIResource(ColorUtil.mult(this.primaryControlColor.getColor(), d2));
        this.primaryControlDarkShadowColor = new ColorUIResource(ColorUtil.mult(this.primaryControlColor.getColor(), d));
        this.scrollBarBackgroundColor.setDefaultColor(this.controlLightShadowColor);
        this.scrollBarBackgroundShadowColor = new ColorUIResource(ColorUtil.mult(this.scrollBarBackgroundColor.getColor(), d));
        this.selectedMenuBackgroundColor.setDefaultColor(this.selectedTextBackgroundColor);
        this.selectedMenuForegroundColor.setDefaultColor(this.selectedTextColor);
        this.treeIconBackgroundColor.setDefaultColor(ColorUtil.blend(this.backgroundColor.getColor(), this.primaryControlColor.getColor(), 0.15f));
        this.activeInternalFrameTitleBackgroundColor.setDefaultColor(ColorUtil.blend(this.primaryControlColor.getColor(), ColorUtil.getOpposite(this.getTextColor()), 0.5));
        this.inactiveInternalFrameTitleBackgroundColor.setDefaultColor(this.controlLightShadowColor);
        this.menuBarBorder.setDefaultBorder(new BorderUIResource(new EtchedLineBorder(false, false, true, false, this.controlHighlightColor, this.controlDarkShadowColor)));
        this.popupMenuBorder.setDefaultBorder(new BorderUIResource(new PopupMenuBorder(this.controlHighlightColor, this.controlDarkShadowColor)));
        this.textFieldBorder.setDefaultBorder(new BorderUIResource(new CompoundBorder(new LineBorder(this.controlDarkShadowColor), new EmptyBorder(1, 2, 1, 2))));
        this.tableHeaderCellBorder.setDefaultBorder(new BorderUIResource(new CompoundBorder(new CompoundBorder(new EdgeBorder(this.controlDarkShadowColor, false, true, false, true), new HighlightBorder(false, this.controlHighlightColor)), new EmptyBorder(1, 4, 1, 4))));
        this.listFocusedItemBorder.setDefaultBorder(new CompoundBorder(new LineBorder(this.focusColor.getColor()), new EmptyBorder(0, 3, 0, 3)));
    }

    public String getName() {
        return this.name;
    }

    public double getShadingFactor() {
        return this.shadingFactor;
    }

    public void setShadingFactor(double d) {
        this.shadingFactor = d;
        this.updateColors();
    }

    public FontUIResource getFont() {
        return this.font;
    }

    public void setFont(FontUIResource fontUIResource) {
        this.font = fontUIResource;
        this.updateFonts();
    }

    public ColorUIResource getControlColor() {
        return this.controlColor.getColor();
    }

    public ColorUIResource getPrimaryControlColor() {
        return this.primaryControlColor.getColor();
    }

    public ColorUIResource getBackgroundColor() {
        return this.backgroundColor.getColor();
    }

    public ColorUIResource getTextColor() {
        return this.textColor.getColor();
    }

    public ColorUIResource getSelectedTextBackgroundColor() {
        return this.selectedTextBackgroundColor.getColor();
    }

    public ColorUIResource getFocusColor() {
        return this.focusColor.getColor();
    }

    public ColorUIResource getSelectedTextColor() {
        return this.selectedTextColor.getColor();
    }

    public ColorUIResource getTooltipBackgroundColor() {
        return this.tooltipBackgroundColor.getColor();
    }

    public ColorUIResource getDesktopColor() {
        return this.desktopColor.getColor();
    }

    public ColorUIResource getTreeIconBackgroundColor() {
        return this.treeIconBackgroundColor.getColor();
    }

    public ColorUIResource getSelectedMenuBackgroundColor() {
        return this.selectedMenuBackgroundColor.getColor();
    }

    public ColorUIResource getSelectedMenuForegroundColor() {
        return this.selectedMenuForegroundColor.getColor();
    }

    public ColorUIResource getInactiveTextColor() {
        return this.inactiveTextColor.getColor();
    }

    public ColorUIResource getControlHighlightColor() {
        return this.controlHighlightColor;
    }

    public ColorUIResource getControlLightShadowColor() {
        return this.controlLightShadowColor;
    }

    public ColorUIResource getControlShadowColor() {
        return this.controlShadowColor;
    }

    public ColorUIResource getControlDarkShadowColor() {
        return this.controlDarkShadowColor;
    }

    public ColorUIResource getPrimaryControlHighlightColor() {
        return this.primaryControlHighlightColor;
    }

    public ColorUIResource getPrimaryControlShadowColor() {
        return this.primaryControlShadowColor;
    }

    public ColorUIResource getPrimaryControlDarkShadowColor() {
        return this.primaryControlDarkShadowColor;
    }

    public ColorUIResource getScrollBarBackgroundColor() {
        return this.scrollBarBackgroundColor.getColor();
    }

    public ColorUIResource getScrollBarBackgroundShadowColor() {
        return this.scrollBarBackgroundShadowColor;
    }

    public ColorUIResource getActiveInternalFrameTitleBackgroundColor() {
        return this.activeInternalFrameTitleBackgroundColor.getColor();
    }

    public ColorUIResource getInactiveInternalFrameTitleBackgroundColor() {
        return this.inactiveInternalFrameTitleBackgroundColor.getColor();
    }

    public BorderUIResource getTableHeaderCellBorder() {
        return this.tableHeaderCellBorder.getBorder();
    }

    public IconUIResource getInternalFrameIcon() {
        return this.internalFrameIcon;
    }

    public void setInternalFrameIcon(IconUIResource iconUIResource) {
        this.internalFrameIcon = iconUIResource;
    }

    public IconUIResource getInternalFrameMinimizeIcon() {
        return this.internalFrameMinimizeIcon;
    }

    public void setInternalFrameMinimizeIcon(IconUIResource iconUIResource) {
        this.internalFrameMinimizeIcon = iconUIResource;
    }

    public IconUIResource getInternalFrameMaximizeIcon() {
        return this.internalFrameMaximizeIcon;
    }

    public void setInternalFrameMaximizeIcon(IconUIResource iconUIResource) {
        this.internalFrameMaximizeIcon = iconUIResource;
    }

    public IconUIResource getInternalFrameCloseIcon() {
        return this.internalFrameCloseIcon;
    }

    public void setInternalFrameCloseIcon(IconUIResource iconUIResource) {
        this.internalFrameCloseIcon = iconUIResource;
    }

    public BorderUIResource getInternalFrameBorder() {
        return this.internalFrameBorder;
    }

    public void setInternalFrameBorder(BorderUIResource borderUIResource) {
        this.internalFrameBorder = borderUIResource;
    }

    public FontUIResource getInternalFrameTitleFont() {
        return this.internalFrameTitleFont.getFont();
    }

    public void setInternalFrameTitleFont(FontUIResource fontUIResource) {
        this.internalFrameTitleFont.setFont(fontUIResource);
    }

    public void setControlColor(Color color) {
        this.controlColor.setColor(color);
        this.updateColors();
    }

    public void setPrimaryControlColor(Color color) {
        this.primaryControlColor.setColor(color);
        this.updateColors();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor.setColor(color);
        this.updateColors();
    }

    public void setTextColor(Color color) {
        this.textColor.setColor(color);
        this.updateColors();
    }

    public FontUIResource getOptionPaneButtonFont() {
        return this.optionPaneButtonFont.getFont();
    }

    public void setOptionPaneButtonFont(FontUIResource fontUIResource) {
        this.optionPaneButtonFont.setFont(fontUIResource);
    }

    public int getSplitPaneDividerSize() {
        return this.splitPaneDividerSize;
    }

    public void setSplitPaneDividerSize(int n) {
        this.splitPaneDividerSize = n;
    }

    public BorderUIResource getTextFieldBorder() {
        return this.textFieldBorder.getBorder();
    }

    public void setTextFieldBorder(BorderUIResource borderUIResource) {
        this.textFieldBorder.setBorder(borderUIResource);
    }

    public IconUIResource getTreeOpenIcon() {
        return this.treeOpenIcon;
    }

    public void setTreeOpenIcon(IconUIResource iconUIResource) {
        this.treeOpenIcon = iconUIResource;
    }

    public IconUIResource getTreeClosedIcon() {
        return this.treeClosedIcon;
    }

    public void setTreeClosedIcon(IconUIResource iconUIResource) {
        this.treeClosedIcon = iconUIResource;
    }

    public IconUIResource getTreeLeafIcon() {
        return this.treeLeafIcon;
    }

    public void setTreeLeafIcon(IconUIResource iconUIResource) {
        this.treeLeafIcon = iconUIResource;
    }

    public BorderUIResource getMenuBarBorder() {
        return this.menuBarBorder.getBorder();
    }

    public void setMenuBarBorder(BorderUIResource borderUIResource) {
        this.menuBarBorder.setBorder(borderUIResource);
    }

    public void setSelectedTextBackgroundColor(Color color) {
        this.selectedTextBackgroundColor.setColor(color);
        this.updateColors();
    }

    public void setFocusColor(Color color) {
        this.focusColor.setColor(color);
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor.setColor(color);
    }

    public void setTooltipBackgroundColor(Color color) {
        this.tooltipBackgroundColor.setColor(color);
    }

    public void setDesktopColor(Color color) {
        this.desktopColor.setColor(color);
        this.updateColors();
    }

    public void setTreeIconBackgroundColor(Color color) {
        this.treeIconBackgroundColor.setColor(color);
    }

    public void setSelectedMenuBackgroundColor(Color color) {
        this.selectedMenuBackgroundColor.setColor(color);
        this.updateColors();
    }

    public void setSelectedMenuForegroundColor(Color color) {
        this.selectedMenuForegroundColor.setColor(color);
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setColor(color);
    }

    public void setScrollBarBackgroundColor(Color color) {
        this.scrollBarBackgroundColor.setColor(color);
        this.updateColors();
    }

    public void setActiveInternalFrameTitleBackgroundColor(Color color) {
        this.activeInternalFrameTitleBackgroundColor.setColor(color);
        this.updateColors();
    }

    public void setInactiveInternalFrameTitleBackgroundColor(Color color) {
        this.inactiveInternalFrameTitleBackgroundColor.setColor(color);
        this.updateColors();
    }

    public void setInternalFrameTitleFont(Font font) {
        this.internalFrameTitleFont.setFont(font);
    }

    public void setOptionPaneButtonFont(Font font) {
        this.optionPaneButtonFont.setFont(font);
    }

    public void setTableHeaderCellBorder(BorderUIResource borderUIResource) {
        this.tableHeaderCellBorder.setBorder(borderUIResource);
    }

    public int getScrollBarWidth() {
        return this.scrollBarWidth;
    }

    public void setScrollBarWidth(int n) {
        this.scrollBarWidth = n;
    }

    public InsetsUIResource getButtonMargin() {
        return this.buttonMargin;
    }

    public void setButtonMargin(InsetsUIResource insetsUIResource) {
        this.buttonMargin = insetsUIResource;
    }

    public BorderUIResource getPopupMenuBorder() {
        return this.popupMenuBorder.getBorder();
    }

    public void setPopupMenuBorder(BorderUIResource borderUIResource) {
        this.popupMenuBorder.setBorder(borderUIResource);
    }

    public IconUIResource getInternalFrameIconifyIcon() {
        return this.internalFrameIconifyIcon;
    }

    public void setInternalFrameIconifyIcon(IconUIResource iconUIResource) {
        this.internalFrameIconifyIcon = iconUIResource;
    }

    public ColorUIResource getTooltipForegroundColor() {
        return this.tooltipForegroundColor.getColor();
    }

    public void setTooltipForegroundColor(ColorUIResource colorUIResource) {
        this.tooltipForegroundColor.setColor(colorUIResource);
        this.updateColors();
    }

    public BorderUIResource getListItemBorder() {
        return this.listItemBorder.getBorder();
    }

    public void setListItemBorder(BorderUIResource borderUIResource) {
        this.listItemBorder.setBorder(borderUIResource);
    }

    public BorderUIResource getListFocusedItemBorder() {
        return this.listFocusedItemBorder.getBorder();
    }

    public void setListFocusedItemBorder(BorderUIResource borderUIResource) {
        this.listFocusedItemBorder.setBorder(borderUIResource);
    }
}

