/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.hover.hoverable;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.hover.hoverable.Hoverable;

public class HoverManager {
    private static HoverManager INSTANCE = new HoverManager();
    private HierarchyListener hierarchyListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            SwingUtilities.invokeLater(new Runnable(this, hierarchyEvent){
                private final /* synthetic */ HierarchyEvent val$e;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$e = hierarchyEvent;
                }

                public void run() {
                    if ((this.val$e.getChangeFlags() & 4L) != 0L) {
                        if (((Component)this.val$e.getSource()).isShowing()) {
                            1.access$000(this.this$1).addHoverable((Hoverable)this.val$e.getSource());
                        } else {
                            1.access$000(this.this$1).removeHoverable((Hoverable)this.val$e.getSource());
                        }
                    }
                }
            });
        }

        static /* synthetic */ HoverManager access$000(1 var0) {
            return var0.HoverManager.this;
        }
    };
    private MouseInputAdapter mouseAdapter = new MouseInputAdapter(){};
    private HashSet hoverableComponents = new HashSet();
    private ArrayList enteredComponents = new ArrayList();
    private boolean enabled = true;
    private boolean hasPermission = false;
    private boolean active = true;
    private boolean gotEnterAfterExit = false;
    private boolean isDrag = false;
    private AWTEventListener eventListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent aWTEvent) {
            if (HoverManager.this.active) {
                HoverManager.this.eventDispatched(aWTEvent);
            }
        }
    };

    private void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
            this.handleButtonEvent(mouseEvent);
        } else if (mouseEvent.getID() == 504 || mouseEvent.getID() == 503) {
            this.handleEnterEvent(mouseEvent);
        } else if (mouseEvent.getID() == 505) {
            this.handleExitEvent(mouseEvent);
        } else if (mouseEvent.getID() == 506) {
            this.isDrag = true;
        }
    }

    private void handleButtonEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1) {
            this.enabled = false;
            this.isDrag = false;
        } else if (!this.enabled && mouseEvent.getID() == 502) {
            this.enabled = true;
            if (this.isDrag) {
                final Component component = ComponentUtil.getTopLevelAncestor((Component)mouseEvent.getSource());
                if (component == null) {
                    this.exitAll();
                } else if (!((Component)mouseEvent.getSource()).contains(mouseEvent.getPoint())) {
                    final Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
                    if (!component.contains(point.x, point.y)) {
                        this.exitAll();
                    } else if (component instanceof Container) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(this){
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        Component component = ComponentUtil.findComponentUnderGlassPaneAt(5.access$300(this.this$1), 5.access$400(this.this$1));
                                        if (component != null) {
                                            Point point = SwingUtilities.convertPoint(5.access$400(this.this$1), 5.access$300(this.this$1), component);
                                            HoverManager.access$200(5.access$500(this.this$1), new MouseEvent(component, 504, 0L, 0, point.x, point.y, 0, false));
                                        }
                                    }
                                });
                            }

                            static /* synthetic */ Point access$300(5 var0) {
                                return var0.point;
                            }

                            static /* synthetic */ Component access$400(5 var0) {
                                return var0.component;
                            }

                            static /* synthetic */ HoverManager access$500(5 var0) {
                                return var0.HoverManager.this;
                            }
                        });
                    }
                }
            }
        }
    }

    private void handleEnterEvent(MouseEvent mouseEvent) {
        int n;
        this.gotEnterAfterExit = true;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.enteredComponents);
        ArrayList<Component> arrayList2 = new ArrayList<Component>();
        for (Component component = (Component)mouseEvent.getSource(); component != null; component = component.getParent()) {
            if (!this.hoverableComponents.contains(component)) continue;
            arrayList.remove(component);
            arrayList2.add(component);
        }
        if (arrayList2.size() > 0) {
            Object[] objectArray = arrayList2.toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                if (((Hoverable)objectArray[i]).acceptHover(arrayList2)) continue;
                arrayList2.remove(objectArray[i]);
                arrayList.add(objectArray[i]);
            }
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            this.dispatchExit((Hoverable)arrayList.get(n));
        }
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            this.dispatchEnter((Hoverable)arrayList2.get(n));
        }
    }

    private void handleExitEvent(MouseEvent mouseEvent) {
        this.gotEnterAfterExit = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!HoverManager.this.gotEnterAfterExit) {
                    HoverManager.this.exitAll();
                }
            }
        });
    }

    public static HoverManager getInstance() {
        return INSTANCE;
    }

    private HoverManager() {
    }

    private void exitAll() {
        this.gotEnterAfterExit = false;
        Object[] objectArray = this.enteredComponents.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            this.dispatchExit((Hoverable)objectArray[i]);
        }
    }

    public void init() {
        this.gotEnterAfterExit = false;
        this.isDrag = false;
        this.enabled = true;
    }

    public void setEventListeningActive(boolean bl) {
        this.active = bl;
    }

    public void dispatchEvent(MouseEvent mouseEvent) {
        this.eventDispatched(mouseEvent);
    }

    public void addHoverable(Hoverable hoverable) {
        if (hoverable instanceof Component && !this.hoverableComponents.contains(hoverable)) {
            if (this.active && this.hoverableComponents.size() == 0) {
                try {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.eventListener, 48L);
                    this.hasPermission = true;
                }
                catch (SecurityException securityException) {
                    this.hasPermission = false;
                }
            }
            this.addHierarchyListener((Component)((Object)hoverable));
            ((Component)((Object)hoverable)).addMouseListener(this.mouseAdapter);
            ((Component)((Object)hoverable)).addMouseMotionListener(this.mouseAdapter);
            this.hoverableComponents.add(hoverable);
        }
    }

    public void removeHoverable(Hoverable hoverable) {
        if (this.hoverableComponents.contains(hoverable)) {
            ((Component)((Object)hoverable)).removeMouseListener(this.mouseAdapter);
            ((Component)((Object)hoverable)).removeMouseMotionListener(this.mouseAdapter);
            this.hoverableComponents.remove(hoverable);
            if (this.enteredComponents.contains(hoverable)) {
                this.enteredComponents.remove(hoverable);
                hoverable.hoverExit();
            }
            if (this.hasPermission && this.hoverableComponents.size() == 0) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.eventListener);
            }
        }
    }

    public boolean isHovered(Hoverable hoverable) {
        return this.enteredComponents.contains(hoverable);
    }

    public boolean isEventListeningActive() {
        return this.active && this.hasPermission;
    }

    private void addHierarchyListener(Component component) {
        HierarchyListener[] hierarchyListenerArray = component.getHierarchyListeners();
        if (hierarchyListenerArray.length == 0) {
            component.addHierarchyListener(this.hierarchyListener);
        } else {
            for (int i = 0; i < hierarchyListenerArray.length && hierarchyListenerArray[i] != this.hierarchyListener; ++i) {
                if (i != hierarchyListenerArray.length - 1) continue;
                component.addHierarchyListener(this.hierarchyListener);
            }
        }
    }

    private void dispatchEnter(Hoverable hoverable) {
        if (this.enabled && !this.enteredComponents.contains(hoverable)) {
            this.enteredComponents.add(hoverable);
            hoverable.hoverEnter();
        }
    }

    private void dispatchExit(Hoverable hoverable) {
        if (this.enabled) {
            this.enteredComponents.remove(hoverable);
            hoverable.hoverExit();
        }
    }
}

