/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.componentpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.AbstractComponentPainter;
import net.infonode.util.Direction;

public class RectangleComponentPainter
extends AbstractComponentPainter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private ColorProvider xorColor;
    private Insets insets;

    public RectangleComponentPainter(Color color, int n) {
        this(new FixedColorProvider(color), n);
    }

    public RectangleComponentPainter(Color color, Color color2, int n) {
        this((ColorProvider)new FixedColorProvider(color), (ColorProvider)new FixedColorProvider(color2), n);
    }

    public RectangleComponentPainter(ColorProvider colorProvider, int n) {
        this(colorProvider, null, n);
    }

    public RectangleComponentPainter(ColorProvider colorProvider, ColorProvider colorProvider2, int n) {
        this(colorProvider, colorProvider2, new Insets(n, n, n, n));
    }

    public RectangleComponentPainter(ColorProvider colorProvider, ColorProvider colorProvider2, Insets insets) {
        this.color = colorProvider;
        this.xorColor = colorProvider2;
        this.insets = (Insets)insets.clone();
    }

    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
        Color color = null;
        graphics.setColor(this.color.getColor(component));
        if (this.xorColor != null && (color = this.xorColor.getColor(component)) != null) {
            graphics.setXORMode(color);
        }
        Insets insets = InsetsUtil.rotate(direction, new Insets(bl2 ? this.insets.bottom : this.insets.top, bl ? this.insets.right : this.insets.left, bl2 ? this.insets.top : this.insets.bottom, bl ? this.insets.left : this.insets.right));
        graphics.fillRect(n + insets.left, n2, n3 - insets.left - insets.right, insets.top);
        graphics.fillRect(n + insets.left, n2 + n4 - insets.bottom, n3 - insets.left - insets.right, insets.bottom);
        graphics.fillRect(n, n2, insets.left, n4);
        graphics.fillRect(n + n3 - insets.right, n2, insets.right, n4);
        if (color != null) {
            graphics.setPaintMode();
        }
    }

    public boolean isOpaque(Component component) {
        return false;
    }

    public Color getColor(Component component) {
        return this.color.getColor(component);
    }
}

